/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console.service.impl;

import com.google.common.base.Optional;
import io.elasticjob.lite.console.domain.EventTraceDataSourceConfiguration;
import io.elasticjob.lite.console.domain.EventTraceDataSourceConfigurations;
import io.elasticjob.lite.console.domain.GlobalConfiguration;
import io.elasticjob.lite.console.repository.ConfigurationsXmlRepository;
import io.elasticjob.lite.console.repository.impl.ConfigurationsXmlRepositoryImpl;
import io.elasticjob.lite.console.service.EventTraceDataSourceConfigurationService;

public final class EventTraceDataSourceConfigurationServiceImpl
implements EventTraceDataSourceConfigurationService {
    private ConfigurationsXmlRepository configurationsXmlRepository = new ConfigurationsXmlRepositoryImpl();

    @Override
    public EventTraceDataSourceConfigurations loadAll() {
        return this.loadGlobal().getEventTraceDataSourceConfigurations();
    }

    @Override
    public EventTraceDataSourceConfiguration load(String name) {
        GlobalConfiguration configs = this.loadGlobal();
        EventTraceDataSourceConfiguration result = this.find(name, configs.getEventTraceDataSourceConfigurations());
        this.setActivated(configs, result);
        return result;
    }

    @Override
    public EventTraceDataSourceConfiguration find(String name, EventTraceDataSourceConfigurations configs) {
        for (EventTraceDataSourceConfiguration each : configs.getEventTraceDataSourceConfiguration()) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    private void setActivated(GlobalConfiguration configs, EventTraceDataSourceConfiguration toBeConnectedConfig) {
        EventTraceDataSourceConfiguration activatedConfig = this.findActivatedDataSourceConfiguration(configs);
        if (!toBeConnectedConfig.equals(activatedConfig)) {
            if (null != activatedConfig) {
                activatedConfig.setActivated(false);
            }
            toBeConnectedConfig.setActivated(true);
            this.configurationsXmlRepository.save(configs);
        }
    }

    @Override
    public Optional<EventTraceDataSourceConfiguration> loadActivated() {
        return Optional.fromNullable((Object)this.findActivatedDataSourceConfiguration(this.loadGlobal()));
    }

    private EventTraceDataSourceConfiguration findActivatedDataSourceConfiguration(GlobalConfiguration configs) {
        for (EventTraceDataSourceConfiguration each : configs.getEventTraceDataSourceConfigurations().getEventTraceDataSourceConfiguration()) {
            if (!each.isActivated()) continue;
            return each;
        }
        return null;
    }

    @Override
    public boolean add(EventTraceDataSourceConfiguration config) {
        GlobalConfiguration configs = this.loadGlobal();
        boolean result = configs.getEventTraceDataSourceConfigurations().getEventTraceDataSourceConfiguration().add(config);
        if (result) {
            this.configurationsXmlRepository.save(configs);
        }
        return result;
    }

    @Override
    public void delete(String name) {
        GlobalConfiguration configs = this.loadGlobal();
        EventTraceDataSourceConfiguration toBeRemovedConfig = this.find(name, configs.getEventTraceDataSourceConfigurations());
        if (null != toBeRemovedConfig) {
            configs.getEventTraceDataSourceConfigurations().getEventTraceDataSourceConfiguration().remove(toBeRemovedConfig);
            this.configurationsXmlRepository.save(configs);
        }
    }

    private GlobalConfiguration loadGlobal() {
        GlobalConfiguration result = (GlobalConfiguration)this.configurationsXmlRepository.load();
        if (null == result.getEventTraceDataSourceConfigurations()) {
            result.setEventTraceDataSourceConfigurations(new EventTraceDataSourceConfigurations());
        }
        return result;
    }
}

