package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerListBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HorizontalPodAutoscalerListBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerListBuilder(java.lang.Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerList(), validationEnabled);
    }

    public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluent<?> fluent) {
        this(fluent, true);
    }

    public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerList(), validationEnabled);
    }

    public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList instance) {
        this(instance,true);
    }

    public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList build() {
        HorizontalPodAutoscalerList buildable = new HorizontalPodAutoscalerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HorizontalPodAutoscalerListBuilder that = (HorizontalPodAutoscalerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
