package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ContainerResourceMetricSourceFluentImpl<A extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricSourceFluent<A> {

    private java.lang.String container;
    private java.lang.String name;
    private java.lang.Integer targetAverageUtilization;
    private io.fabric8.kubernetes.api.model.Quantity targetAverageValue;

    public ContainerResourceMetricSourceFluentImpl() {
    }

    public ContainerResourceMetricSourceFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricSource instance) {
        this.withContainer(instance.getContainer()); 
        this.withName(instance.getName()); 
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
        this.withTargetAverageValue(instance.getTargetAverageValue()); 
    }

    public java.lang.String getContainer() {
        return this.container;
    }

    public A withContainer(java.lang.String container) {
        this.container=container; return (A) this;
    }

    public java.lang.Boolean hasContainer() {
        return this.container != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withContainer instead.
     */
        public A withNewContainer(java.lang.String arg0) {
        return (A)withContainer(new String(arg0));
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0) {
        return (A)withName(new String(arg0));
    }

    public java.lang.Integer getTargetAverageUtilization() {
        return this.targetAverageUtilization;
    }

    public A withTargetAverageUtilization(java.lang.Integer targetAverageUtilization) {
        this.targetAverageUtilization=targetAverageUtilization; return (A) this;
    }

    public java.lang.Boolean hasTargetAverageUtilization() {
        return this.targetAverageUtilization != null;
    }

    public io.fabric8.kubernetes.api.model.Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public A withTargetAverageValue(io.fabric8.kubernetes.api.model.Quantity targetAverageValue) {
        this.targetAverageValue=targetAverageValue; return (A) this;
    }

    public java.lang.Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    public A withNewTargetAverageValue(java.lang.String amount,java.lang.String format) {
        return (A)withTargetAverageValue(new Quantity(amount, format));
    }

    public A withNewTargetAverageValue(java.lang.String amount) {
        return (A)withTargetAverageValue(new Quantity(amount));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ContainerResourceMetricSourceFluentImpl that = (ContainerResourceMetricSourceFluentImpl) o;
        if (container != null ? !container.equals(that.container) :that.container != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (targetAverageUtilization != null ? !targetAverageUtilization.equals(that.targetAverageUtilization) :that.targetAverageUtilization != null) return false;
        if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(container,  name,  targetAverageUtilization,  targetAverageValue,  super.hashCode());
    }

}
