package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MetricStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatusBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MetricStatusBuilder() {
        this(true);
    }

    public MetricStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new MetricStatus(), validationEnabled);
    }

    public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MetricStatus(), validationEnabled);
    }

    public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatus instance) {
        this(fluent, instance, true);
    }

    public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withContainerResource(instance.getContainerResource()); 
        fluent.withExternal(instance.getExternal()); 
        fluent.withObject(instance.getObject()); 
        fluent.withPods(instance.getPods()); 
        fluent.withResource(instance.getResource()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatus instance) {
        this(instance,true);
    }

    public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withContainerResource(instance.getContainerResource()); 
        this.withExternal(instance.getExternal()); 
        this.withObject(instance.getObject()); 
        this.withPods(instance.getPods()); 
        this.withResource(instance.getResource()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricStatus build() {
        MetricStatus buildable = new MetricStatus(fluent.getContainerResource(),fluent.getExternal(),fluent.getObject(),fluent.getPods(),fluent.getResource(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MetricStatusBuilder that = (MetricStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
