package io.fabric8.kubernetes.api.model.events.v1;

import java.lang.Integer;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EventSeriesFluentImpl<A extends io.fabric8.kubernetes.api.model.events.v1.EventSeriesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.events.v1.EventSeriesFluent<A> {

    private java.lang.Integer count;
    private io.fabric8.kubernetes.api.model.MicroTime lastObservedTime;

    public EventSeriesFluentImpl() {
    }

    public EventSeriesFluentImpl(io.fabric8.kubernetes.api.model.events.v1.EventSeries instance) {
        this.withCount(instance.getCount()); 
        this.withLastObservedTime(instance.getLastObservedTime()); 
    }

    public java.lang.Integer getCount() {
        return this.count;
    }

    public A withCount(java.lang.Integer count) {
        this.count=count; return (A) this;
    }

    public java.lang.Boolean hasCount() {
        return this.count != null;
    }

    public io.fabric8.kubernetes.api.model.MicroTime getLastObservedTime() {
        return this.lastObservedTime;
    }

    public A withLastObservedTime(io.fabric8.kubernetes.api.model.MicroTime lastObservedTime) {
        this.lastObservedTime=lastObservedTime; return (A) this;
    }

    public java.lang.Boolean hasLastObservedTime() {
        return this.lastObservedTime != null;
    }

    public A withNewLastObservedTime(java.lang.String time) {
        return (A)withLastObservedTime(new MicroTime(time));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EventSeriesFluentImpl that = (EventSeriesFluentImpl) o;
        if (count != null ? !count.equals(that.count) :that.count != null) return false;
        if (lastObservedTime != null ? !lastObservedTime.equals(that.lastObservedTime) :that.lastObservedTime != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(count,  lastObservedTime,  super.hashCode());
    }

}
