/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceScale;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceScaleFluent;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceScaleFluentImpl;
import javax.validation.Validator;

public class CustomResourceSubresourceScaleBuilder
extends CustomResourceSubresourceScaleFluentImpl<CustomResourceSubresourceScaleBuilder>
implements VisitableBuilder<CustomResourceSubresourceScale, CustomResourceSubresourceScaleBuilder> {
    CustomResourceSubresourceScaleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CustomResourceSubresourceScaleBuilder() {
        this(true);
    }

    public CustomResourceSubresourceScaleBuilder(Boolean validationEnabled) {
        this(new CustomResourceSubresourceScale(), validationEnabled);
    }

    public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CustomResourceSubresourceScale(), validationEnabled);
    }

    public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent, CustomResourceSubresourceScale instance) {
        this(fluent, instance, true);
    }

    public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent, CustomResourceSubresourceScale instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLabelSelectorPath(instance.getLabelSelectorPath());
        fluent.withSpecReplicasPath(instance.getSpecReplicasPath());
        fluent.withStatusReplicasPath(instance.getStatusReplicasPath());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScale instance) {
        this(instance, (Boolean)true);
    }

    public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScale instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLabelSelectorPath(instance.getLabelSelectorPath());
        this.withSpecReplicasPath(instance.getSpecReplicasPath());
        this.withStatusReplicasPath(instance.getStatusReplicasPath());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceSubresourceScaleBuilder(Validator validator) {
        this(new CustomResourceSubresourceScale(), (Boolean)true);
    }

    public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent, CustomResourceSubresourceScale instance, Validator validator) {
        this.fluent = fluent;
        fluent.withLabelSelectorPath(instance.getLabelSelectorPath());
        fluent.withSpecReplicasPath(instance.getSpecReplicasPath());
        fluent.withStatusReplicasPath(instance.getStatusReplicasPath());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScale instance, Validator validator) {
        this.fluent = this;
        this.withLabelSelectorPath(instance.getLabelSelectorPath());
        this.withSpecReplicasPath(instance.getSpecReplicasPath());
        this.withStatusReplicasPath(instance.getStatusReplicasPath());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public CustomResourceSubresourceScale build() {
        CustomResourceSubresourceScale buildable = new CustomResourceSubresourceScale(this.fluent.getLabelSelectorPath(), this.fluent.getSpecReplicasPath(), this.fluent.getStatusReplicasPath());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceSubresourceScaleBuilder that = (CustomResourceSubresourceScaleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

