package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class GroupVersionForDiscoveryBuilder extends GroupVersionForDiscoveryFluentImpl<GroupVersionForDiscoveryBuilder> implements VisitableBuilder<GroupVersionForDiscovery,GroupVersionForDiscoveryBuilder>{

    GroupVersionForDiscoveryFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public GroupVersionForDiscoveryBuilder(){
            this(true);
    }
    public GroupVersionForDiscoveryBuilder(Boolean validationEnabled){
            this(new GroupVersionForDiscovery(), validationEnabled);
    }
    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent){
            this(fluent, true);
    }
    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GroupVersionForDiscovery(), validationEnabled);
    }
    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent,GroupVersionForDiscovery instance){
            this(fluent, instance, true);
    }
    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent,GroupVersionForDiscovery instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGroupVersion(instance.getGroupVersion()); 
            fluent.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscovery instance){
            this(instance,true);
    }
    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscovery instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGroupVersion(instance.getGroupVersion()); 
            this.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public GroupVersionForDiscoveryBuilder(Validator validator){
            this(new GroupVersionForDiscovery(), true);
    }
    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent,GroupVersionForDiscovery instance,Validator validator){
            this.fluent = fluent; 
            fluent.withGroupVersion(instance.getGroupVersion()); 
            fluent.withVersion(instance.getVersion()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public GroupVersionForDiscoveryBuilder(GroupVersionForDiscovery instance,Validator validator){
            this.fluent = this; 
            this.withGroupVersion(instance.getGroupVersion()); 
            this.withVersion(instance.getVersion()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public GroupVersionForDiscovery build(){
            GroupVersionForDiscovery buildable = new GroupVersionForDiscovery(fluent.getGroupVersion(),fluent.getVersion());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GroupVersionForDiscoveryBuilder that = (GroupVersionForDiscoveryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
