/*
 * Decompiled with CFR 0.152.
 */
package io.franzbecker.gradle.lombok.task;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.franzbecker.gradle.lombok.LombokPlugin;
import io.franzbecker.gradle.lombok.LombokPluginExtension;
import io.franzbecker.gradle.lombok.util.HashUtil;
import java.io.File;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.tasks.TaskAction;

public class VerifyLombokTask
extends DefaultTask
implements GroovyObject {
    private static final String NAME = "verifyLombok";
    private HashUtil hashUtil;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public VerifyLombokTask() {
        MetaClass metaClass;
        CallSite[] callSiteArray = VerifyLombokTask.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(HashUtil.class);
        this.hashUtil = (HashUtil)ScriptBytecodeAdapter.castToType((Object)object, HashUtil.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void verifyLombok() {
        CallSite[] callSiteArray = VerifyLombokTask.$getCallSiteArray();
        Object extension = callSiteArray[1].call(callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), LombokPluginExtension.class);
        Object configuration = callSiteArray[4].call(callSiteArray[5].callGetProperty(callSiteArray[6].callGroovyObjectGetProperty((Object)this)), callSiteArray[7].callGetProperty(LombokPlugin.class));
        callSiteArray[8].callCurrent((GroovyObject)this, extension, configuration);
    }

    protected Object verifyLombok(LombokPluginExtension extension, Configuration configuration) {
        CallSite[] callSiteArray = VerifyLombokTask.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGroovyObjectGetProperty((Object)extension))) {
            Object lombokJar = callSiteArray[10].callCurrent((GroovyObject)this, callSiteArray[11].callGroovyObjectGetProperty((Object)extension), (Object)configuration);
            return callSiteArray[12].callCurrent((GroovyObject)this, callSiteArray[13].callGroovyObjectGetProperty((Object)extension), lombokJar);
        }
        return callSiteArray[14].call(callSiteArray[15].callGroovyObjectGetProperty((Object)this), (Object)"Skipping verification of Lombok since SHA-256 was not configured.");
    }

    protected File getLombokJar(String lombokVersion, Configuration configuration) {
        CallSite[] callSiteArray = VerifyLombokTask.$getCallSiteArray();
        Reference lombokFileName = new Reference((Object)new GStringImpl(new Object[]{lombokVersion}, new String[]{"lombok-", ".jar"}));
        callSiteArray[16].call(callSiteArray[17].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{lombokFileName.get(), callSiteArray[18].callGetProperty(LombokPlugin.class)}, new String[]{"Searching for '", "' in dependencies of configuration '", "'."}));
        public class _getLombokJar_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference lombokFileName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getLombokJar_closure1(Object _outerInstance, Object _thisObject, Reference lombokFileName) {
                Reference reference;
                CallSite[] callSiteArray = _getLombokJar_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.lombokFileName = reference = lombokFileName;
            }

            public Object doCall(File file) {
                CallSite[] callSiteArray = _getLombokJar_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)file), (Object)this.lombokFileName.get());
            }

            public Object call(File file) {
                CallSite[] callSiteArray = _getLombokJar_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)file);
            }

            public Object getLombokFileName() {
                CallSite[] callSiteArray = _getLombokJar_closure1.$getCallSiteArray();
                return this.lombokFileName.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLombokJar_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getLombokJar_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getLombokJar_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getLombokJar_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object lombokJar = callSiteArray[19].call((Object)configuration, (Object)new _getLombokJar_closure1((Object)this, (Object)this, lombokFileName));
        if (!DefaultTypeTransformation.booleanUnbox((Object)lombokJar)) {
            throw (Throwable)callSiteArray[20].callConstructor(ResourceException.class, (Object)new GStringImpl(new Object[]{lombokFileName.get(), callSiteArray[21].callGetProperty(LombokPlugin.class)}, new String[]{"Could not find '", "' in dependencies of configuration '", "'."}));
        }
        callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{lombokJar}, new String[]{"Found '", "'."}));
        return (File)ScriptBytecodeAdapter.castToType((Object)lombokJar, File.class);
    }

    protected void verifyIntegrity(String expectedSha256, File lombokJar) {
        CallSite[] callSiteArray = VerifyLombokTask.$getCallSiteArray();
        Object actualSha256 = callSiteArray[24].call((Object)this.hashUtil, (Object)lombokJar);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)expectedSha256, (Object)actualSha256)) {
            Object message = callSiteArray[25].call((Object)new GStringImpl(new Object[]{lombokJar, expectedSha256, actualSha256}, new String[]{"                Verification of Lombok JAR failed!\n\n                Local JAR file:    ", "\n\n                Expected checksum: ", "\n                  Actual checksum: ", "\n            "}));
            throw (Throwable)callSiteArray[26].callConstructor(ResourceException.class, message);
        }
        callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{actualSha256, lombokJar}, new String[]{"Calculates matching hash '", "' for '", "'."}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != VerifyLombokTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public static String getNAME() {
        return NAME;
    }

    public HashUtil getHashUtil() {
        return this.hashUtil;
    }

    public void setHashUtil(HashUtil hashUtil) {
        this.hashUtil = hashUtil;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "findByType";
        stringArray[2] = "extensions";
        stringArray[3] = "project";
        stringArray[4] = "getByName";
        stringArray[5] = "configurations";
        stringArray[6] = "project";
        stringArray[7] = "LOMBOK_CONFIGURATION_NAME";
        stringArray[8] = NAME;
        stringArray[9] = "sha256";
        stringArray[10] = "getLombokJar";
        stringArray[11] = "version";
        stringArray[12] = "verifyIntegrity";
        stringArray[13] = "sha256";
        stringArray[14] = "info";
        stringArray[15] = "logger";
        stringArray[16] = "debug";
        stringArray[17] = "logger";
        stringArray[18] = "LOMBOK_CONFIGURATION_NAME";
        stringArray[19] = "find";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "LOMBOK_CONFIGURATION_NAME";
        stringArray[22] = "debug";
        stringArray[23] = "logger";
        stringArray[24] = "calculateSha256";
        stringArray[25] = "stripIndent";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "debug";
        stringArray[28] = "logger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[29];
        VerifyLombokTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(VerifyLombokTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = VerifyLombokTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

