/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class ChromeDriverManager
extends BrowserManager {
    public static synchronized BrowserManager getInstance() {
        if (instance == null || !instance.getClass().equals(ChromeDriverManager.class)) {
            instance = new ChromeDriverManager();
        }
        return instance;
    }

    public ChromeDriverManager() {
        this.exportParameter = WdmConfig.getString("wdm.chromeDriverExport");
        this.driverVersionKey = "wdm.chromeDriverVersion";
        this.driverUrlKey = "wdm.chromeDriverUrl";
        this.driverName = Arrays.asList("chromedriver");
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        URL driverUrl = this.getDriverUrl();
        List<URL> urls = this.isUsingTaobaoMirror() ? this.getDriversFromMirror(driverUrl) : this.getDriversFromXml(this.getDriverUrl());
        return urls;
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        if (this.isUsingTaobaoMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            return url.getFile().substring(j, i);
        }
        return super.getCurrentVersion(url, driverName);
    }

    @Override
    public BrowserManager useTaobaoMirror() {
        return this.useTaobaoMirror("wdm.chromeDriverTaobaoUrl");
    }
}

