/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.OperativeSystem;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class FirefoxDriverManager
extends BrowserManager {
    public static synchronized BrowserManager getInstance() {
        if (instance == null || !instance.getClass().equals(FirefoxDriverManager.class)) {
            instance = new FirefoxDriverManager();
        }
        return instance;
    }

    public FirefoxDriverManager() {
        this.exportParameter = WdmConfig.getString("wdm.geckoDriverExport");
        this.driverVersionKey = "wdm.geckoDriverVersion";
        this.driverUrlKey = "wdm.geckoDriverUrl";
        this.driverName = Arrays.asList("wires", "geckodriver");
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        return this.getDriversFromGitHub();
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        String currentVersion = url.getFile().substring(url.getFile().indexOf(45) + 1, url.getFile().lastIndexOf(45));
        if (currentVersion.startsWith("v")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected String preDownload(String target, String version) {
        int iSeparator = target.indexOf(version) - 1;
        int iDash = target.lastIndexOf(version) + version.length();
        int iPoint = target.lastIndexOf(".zip");
        int iPointTazGz = target.lastIndexOf(".tar.gz");
        int iPointGz = target.lastIndexOf(".gz");
        if (iPointTazGz != -1) {
            iPoint = iPointTazGz;
        } else if (iPointGz != -1) {
            iPoint = iPointGz;
        }
        target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint).toLowerCase() + target.substring(iSeparator);
        return target;
    }

    @Override
    public BrowserManager useTaobaoMirror() {
        return this.useTaobaoMirror("wdm.geckoDriverTaobaoUrl");
    }

    @Override
    protected boolean shouldCheckArchitecture() {
        return !this.myOsName.contains(OperativeSystem.MAC.name());
    }
}

