/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.camel.core.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.camel.core.runtime.CamelConfig;
import io.quarkus.camel.core.runtime.CamelProducers;
import io.quarkus.camel.core.runtime.CamelRuntime;
import io.quarkus.camel.core.runtime.support.FastCamelRuntime;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Template;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.Registry;

@Template
public class CamelTemplate {
    public RuntimeValue<CamelRuntime> create(Registry registry, Properties properties, List<RuntimeValue<?>> builders) {
        FastCamelRuntime runtime = new FastCamelRuntime();
        runtime.setRegistry(registry);
        runtime.setProperties(properties);
        runtime.setBuilders(builders.stream().map(RuntimeValue::getValue).map(RoutesBuilder.class::cast).collect(Collectors.toList()));
        return new RuntimeValue((Object)runtime);
    }

    public void init(BeanContainer beanContainer, RuntimeValue<CamelRuntime> runtime, CamelConfig.BuildTime buildTimeConfig) throws Exception {
        ((FastCamelRuntime)runtime.getValue()).setBeanContainer(beanContainer);
        ((CamelRuntime)runtime.getValue()).init(buildTimeConfig);
    }

    public void start(ShutdownContext shutdown, final RuntimeValue<CamelRuntime> runtime, CamelConfig.Runtime runtimeConfig) throws Exception {
        ((CamelRuntime)runtime.getValue()).start(runtimeConfig);
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                try {
                    ((CamelRuntime)runtime.getValue()).stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public BeanContainerListener initRuntimeInjection(RuntimeValue<CamelRuntime> runtime) {
        return container -> ((CamelProducers)container.instance(CamelProducers.class, new Annotation[0])).setCamelRuntime((CamelRuntime)runtime.getValue());
    }
}

