/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.camel.core.runtime.support;

import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;

@Vetoed
final class BeanManagerHelper {
    private BeanManagerHelper() {
    }

    static <T> Set<T> getReferencesByType(Class<T> type, Annotation ... qualifiers) {
        BeanManager manager = Arc.container().beanManager();
        return BeanManagerHelper.getReferencesByType(manager, type, qualifiers);
    }

    static <T> Optional<T> getReferenceByName(String name, Class<T> type) {
        BeanManager manager = Arc.container().beanManager();
        return BeanManagerHelper.getReferenceByName(manager, name, type);
    }

    static <T> Map<String, T> getReferencesByTypeWithName(Class<T> type, Annotation ... qualifiers) {
        BeanManager manager = Arc.container().beanManager();
        return BeanManagerHelper.getReferencesByTypeWithName(manager, type, qualifiers);
    }

    static <T> Set<T> getReferencesByType(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        return manager.getBeans(type, qualifiers).stream().map(bean -> BeanManagerHelper.getReference(manager, type, bean)).collect(Collectors.toSet());
    }

    static <T> Optional<T> getReferenceByName(BeanManager manager, String name, Class<T> type) {
        return Optional.of(manager.getBeans(name)).map(arg_0 -> ((BeanManager)manager).resolve(arg_0)).map(bean -> BeanManagerHelper.getReference(manager, type, bean));
    }

    static <T> T getReference(BeanManager manager, Class<T> type, Bean<?> bean) {
        return type.cast(manager.getReference(bean, type, manager.createCreationalContext(bean)));
    }

    static <T> Map<String, T> getReferencesByTypeWithName(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        return manager.getBeans(type, qualifiers).stream().collect(Collectors.toMap(BeanAttributes::getName, b -> BeanManagerHelper.getReference(manager, type, b)));
    }
}

