/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.camel.core.runtime.support;

import io.quarkus.camel.core.runtime.support.BeanManagerHelper;
import io.quarkus.runtime.RuntimeValue;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeRegistry
extends HashMap<String, Map<Class<?>, Object>>
implements Registry {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public void bind(String name, Object object) {
        this.bind(name, object.getClass(), object);
    }

    public void bind(String name, Class<?> clazz, Object object) {
        this.computeIfAbsent(name, k -> new HashMap()).put(clazz, object);
    }

    public Object lookupByName(String name) {
        return this.lookupByNameAndType(name, Object.class);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Optional<T> t = BeanManagerHelper.getReferenceByName(name, type);
        if (t.isPresent()) {
            return t.get();
        }
        Map map = (Map)this.get(name);
        if (map == null) {
            return null;
        }
        Object answer = map.get(type);
        if (answer == null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!type.isAssignableFrom((Class)entry.getKey())) continue;
                answer = entry.getValue();
                break;
            }
        }
        if (answer instanceof RuntimeValue) {
            this.log.info("Creating {} for name {}", (Object)type.toString(), (Object)name);
            answer = ((RuntimeValue)answer).getValue();
        }
        try {
            return type.cast(answer);
        }
        catch (Throwable e) {
            String msg = "Found bean: " + name + " in SimpleRegistry: " + this + " of type: " + answer.getClass().getName() + " expected type was: " + type;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.entrySet()) {
            for (Object answer : ((Map)entry.getValue()).values()) {
                if (answer instanceof RuntimeValue) {
                    answer = ((RuntimeValue)answer).getValue();
                }
                if (!type.isInstance(answer)) continue;
                result.put(entry.getKey(), type.cast(answer));
            }
        }
        result.putAll(BeanManagerHelper.getReferencesByTypeWithName(type, new Annotation[0]));
        return result;
    }

    public <T> Set<T> findByType(Class<T> type) {
        HashSet<T> result = new HashSet<T>();
        for (Map.Entry entry : this.entrySet()) {
            for (Object answer : ((Map)entry.getValue()).values()) {
                if (answer instanceof RuntimeValue) {
                    answer = ((RuntimeValue)answer).getValue();
                }
                if (!type.isInstance(answer)) continue;
                result.add(type.cast(answer));
            }
        }
        result.addAll(BeanManagerHelper.getReferencesByType(type, new Annotation[0]));
        return result;
    }
}

