/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.wildfly.common.Assert;

public class InMemoryLogHandler
extends Handler {
    private final Predicate<LogRecord> predicate;
    public final List<LogRecord> records = new ArrayList<LogRecord>();

    public InMemoryLogHandler(Predicate<LogRecord> predicate) {
        this.predicate = (Predicate)Assert.checkNotNullParam((String)"predicate", predicate);
    }

    @Override
    public void publish(LogRecord record) {
        if (this.predicate.test(record)) {
            this.records.add(record);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public Level getLevel() {
        return Level.FINE;
    }

    @Override
    public void close() throws SecurityException {
    }
}

