/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.runtime.annotations.Template;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentProducer;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@Template
public class SmallRyeOpenApiTemplate {
    public BeanContainerListener setupModel(final OpenAPI staticModel, final OpenAPI annotationModel) {
        return new BeanContainerListener(){

            public void created(BeanContainer container) {
                Config config = ConfigProvider.getConfig();
                OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
                OpenAPIImpl readerModel = OpenApiProcessor.modelFromReader((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader());
                OpenApiDocument document = SmallRyeOpenApiTemplate.this.createDocument((OpenApiConfig)openApiConfig);
                document.modelFromAnnotations(annotationModel);
                document.modelFromReader((OpenAPI)readerModel);
                document.modelFromStaticFile(staticModel);
                document.filter(SmallRyeOpenApiTemplate.this.filter((OpenApiConfig)openApiConfig));
                document.initialize();
                ((OpenApiDocumentProducer)container.instance(OpenApiDocumentProducer.class, new Annotation[0])).setDocument(document);
            }
        };
    }

    private OpenApiDocument createDocument(OpenApiConfig openApiConfig) {
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        document.reset();
        document.config(openApiConfig);
        return document;
    }

    private OASFilter filter(OpenApiConfig openApiConfig) {
        return OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }
}

