/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.response;

import io.servicecomb.swagger.invocation.converter.Converter;
import io.servicecomb.swagger.invocation.converter.ConverterMgr;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public abstract class ResponseMapperFactory<MAPPER> {
    @Inject
    protected ConverterMgr converterMgr;
    protected Map<Class<?>, MAPPER> mappers = new HashMap();

    public void setConverterMgr(ConverterMgr converterMgr) {
        this.converterMgr = converterMgr;
    }

    public MAPPER createResponseMapper(Type src, Type target) {
        MAPPER mapper;
        Type type = this.choose(src, target);
        if (ParameterizedType.class.isAssignableFrom(type.getClass())) {
            type = ((ParameterizedType)type).getRawType();
        }
        if ((mapper = this.mappers.get(type)) != null) {
            return mapper;
        }
        Converter converter = this.converterMgr.findConverter(src, target);
        return this.doCreateResponseMapper(converter);
    }

    protected abstract Type choose(Type var1, Type var2);

    protected abstract MAPPER doCreateResponseMapper(Converter var1);
}

