/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.BeanValidators;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class DecimalMinMaxAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DecimalMinMaxAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<DecimalMin> min = this.extractMin(context);
        Optional<DecimalMax> max = this.extractMax(context);
        context.getBuilder().allowableValues(this.createAllowableValuesFromDecimalMinMaxForNumbers(min, max));
    }

    @VisibleForTesting
    Optional<DecimalMin> extractMin(ModelPropertyContext context) {
        return BeanValidators.validatorFromBean(context, DecimalMin.class).or(BeanValidators.validatorFromField(context, DecimalMin.class));
    }

    @VisibleForTesting
    Optional<DecimalMax> extractMax(ModelPropertyContext context) {
        return BeanValidators.validatorFromBean(context, DecimalMax.class).or(BeanValidators.validatorFromField(context, DecimalMax.class));
    }

    private AllowableValues createAllowableValuesFromDecimalMinMaxForNumbers(Optional<DecimalMin> decimalMin, Optional<DecimalMax> decimalMax) {
        AllowableRangeValues myvalues = null;
        if (decimalMin.isPresent() && decimalMax.isPresent()) {
            LOG.debug("@DecimalMin+@DecimalMax detected: adding AllowableRangeValues to field ");
            DecimalMin min = (DecimalMin)decimalMin.get();
            DecimalMax max = (DecimalMax)decimalMax.get();
            myvalues = new AllowableRangeValues(min.value(), Boolean.valueOf(!min.inclusive()), max.value(), Boolean.valueOf(!max.inclusive()));
        } else if (decimalMin.isPresent()) {
            LOG.debug("@DecimalMin detected: adding AllowableRangeValues to field ");
            DecimalMin min = (DecimalMin)decimalMin.get();
            myvalues = new AllowableRangeValues(min.value(), Boolean.valueOf(!min.inclusive()), null, null);
        } else if (decimalMax.isPresent()) {
            LOG.debug("@DecimalMax detected: adding AllowableRangeValues to field ");
            DecimalMax max = (DecimalMax)decimalMax.get();
            myvalues = new AllowableRangeValues(null, null, max.value(), Boolean.valueOf(!max.inclusive()));
        }
        return myvalues;
    }
}

