/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.BeanValidators;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class MinMaxAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(MinMaxAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<Min> min = this.extractMin(context);
        Optional<Max> max = this.extractMax(context);
        context.getBuilder().allowableValues(this.createAllowableValuesFromMinMaxForNumbers(min, max));
    }

    @VisibleForTesting
    Optional<Min> extractMin(ModelPropertyContext context) {
        return BeanValidators.validatorFromBean(context, Min.class).or(BeanValidators.validatorFromField(context, Min.class));
    }

    @VisibleForTesting
    Optional<Max> extractMax(ModelPropertyContext context) {
        return BeanValidators.validatorFromBean(context, Max.class).or(BeanValidators.validatorFromField(context, Max.class));
    }

    private AllowableValues createAllowableValuesFromMinMaxForNumbers(Optional<Min> min, Optional<Max> max) {
        AllowableRangeValues myvalues = null;
        if (min.isPresent() && max.isPresent()) {
            LOG.debug("@Min+@Max detected: adding AllowableRangeValues to field ");
            myvalues = new AllowableRangeValues(Double.toString(((Min)min.get()).value()), Boolean.valueOf(false), Double.toString(((Max)max.get()).value()), Boolean.valueOf(false));
        } else if (min.isPresent()) {
            LOG.debug("@Min detected: adding AllowableRangeValues to field ");
            myvalues = new AllowableRangeValues(Double.toString(((Min)min.get()).value()), Boolean.valueOf(false), null, null);
        } else if (max.isPresent()) {
            LOG.debug("@Max detected: adding AllowableRangeValues to field ");
            myvalues = new AllowableRangeValues(null, null, Double.toString(((Max)max.get()).value()), Boolean.valueOf(false));
        }
        return myvalues;
    }
}

