/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.HashMap;
import java.util.Map;
import springfox.documentation.builders.BodyParameterSpecificationProvider;
import springfox.documentation.builders.CookieParameterSpecificationProvider;
import springfox.documentation.builders.FormParameterSpecificationProvider;
import springfox.documentation.builders.HeaderParameterSpecificationProvider;
import springfox.documentation.builders.MultipartFormDataParameterSpecificationProvider;
import springfox.documentation.builders.ParameterSpecificationContext;
import springfox.documentation.builders.ParameterSpecificationProvider;
import springfox.documentation.builders.PathParameterSpecificationProvider;
import springfox.documentation.builders.QueryParameterSpecificationProvider;
import springfox.documentation.service.ParameterSpecification;
import springfox.documentation.service.ParameterType;

public class RootParameterSpecificationProvider
implements ParameterSpecificationProvider {
    static final Map<ParameterType, ParameterSpecificationProvider> SPECIFICATION_PROVIDER_LOOKUP = new HashMap<ParameterType, ParameterSpecificationProvider>();

    @Override
    public ParameterSpecification create(ParameterSpecificationContext context) {
        if (context.getSimpleParameterSpecificationBuilder() == null && context.getContentSpecificationBuilder() == null) {
            throw new IllegalStateException("Parameter should either be a simple parameter or content");
        }
        return SPECIFICATION_PROVIDER_LOOKUP.getOrDefault((Object)context.getIn(), new PassThroughSpecificationProvider()).create(context);
    }

    static {
        SPECIFICATION_PROVIDER_LOOKUP.put(ParameterType.QUERY, new QueryParameterSpecificationProvider());
        SPECIFICATION_PROVIDER_LOOKUP.put(ParameterType.COOKIE, new CookieParameterSpecificationProvider());
        SPECIFICATION_PROVIDER_LOOKUP.put(ParameterType.HEADER, new HeaderParameterSpecificationProvider());
        SPECIFICATION_PROVIDER_LOOKUP.put(ParameterType.PATH, new PathParameterSpecificationProvider());
        SPECIFICATION_PROVIDER_LOOKUP.put(ParameterType.FORM, new FormParameterSpecificationProvider());
        SPECIFICATION_PROVIDER_LOOKUP.put(ParameterType.BODY, new BodyParameterSpecificationProvider());
        SPECIFICATION_PROVIDER_LOOKUP.put(ParameterType.FORMDATA, new MultipartFormDataParameterSpecificationProvider());
    }

    private static class PassThroughSpecificationProvider
    implements ParameterSpecificationProvider {
        private PassThroughSpecificationProvider() {
        }

        @Override
        public ParameterSpecification create(ParameterSpecificationContext context) {
            return new ParameterSpecification(context.getSimpleParameter(), context.getContentParameter());
        }
    }
}

