/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.paths;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Set;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.PathDecorator;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.PathContext;

@Component
@Order(value=-2147483588)
class QueryStringUriTemplateDecorator
implements PathDecorator {
    QueryStringUriTemplateDecorator() {
    }

    public Function<String, String> decorator(final PathContext context) {
        return new Function<String, String>(){

            public String apply(String input) {
                Set expressions;
                StringBuilder sb = new StringBuilder(input);
                String prefilled = QueryStringUriTemplateDecorator.this.prefilledQueryParams(context);
                if (!Strings.isNullOrEmpty((String)prefilled)) {
                    sb.append(QueryStringUriTemplateDecorator.this.requiresContinuation(input) ? "&" : "?");
                    sb.append(prefilled);
                }
                if ((expressions = QueryStringUriTemplateDecorator.this.queryParamNames(context)).size() == 0) {
                    return sb.toString();
                }
                String prefix = QueryStringUriTemplateDecorator.this.queryTemplatePrefix(input, prefilled);
                String queryTemplate = Joiner.on((char)',').join((Iterable)expressions);
                sb.append(prefix).append(queryTemplate).append("}");
                return sb.toString();
            }
        };
    }

    private String queryTemplatePrefix(String input, String prefilled) {
        String prefix = Strings.isNullOrEmpty((String)prefilled) ? (this.requiresContinuation(input) ? "{&" : "{?") : "{&";
        return prefix;
    }

    private boolean requiresContinuation(String url) {
        return url.contains("?");
    }

    private Set<String> queryParamNames(PathContext context) {
        return FluentIterable.from((Iterable)context.getParameters()).filter(Predicates.and(this.queryStringParams(), (Predicate)Predicates.not(this.onlyOneAllowableValue()))).transform(this.paramName()).toSortedSet((Comparator)Ordering.natural());
    }

    private String prefilledQueryParams(PathContext context) {
        return Joiner.on((String)"&").join((Iterable)FluentIterable.from((Iterable)context.getParameters()).filter(this.onlyOneAllowableValue()).transform(this.queryStringWithValue()).toSortedSet((Comparator)Ordering.natural())).trim();
    }

    private Predicate<Parameter> onlyOneAllowableValue() {
        return new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                AllowableValues allowableValues = input.getAllowableValues();
                return allowableValues != null && allowableValues instanceof AllowableListValues && ((AllowableListValues)allowableValues).getValues().size() == 1;
            }
        };
    }

    private Predicate<Parameter> queryStringParams() {
        return new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                return "query".equals(input.getParamType());
            }
        };
    }

    private Function<Parameter, String> paramName() {
        return new Function<Parameter, String>(){

            public String apply(Parameter input) {
                return input.getName();
            }
        };
    }

    private Function<Parameter, String> queryStringWithValue() {
        return new Function<Parameter, String>(){

            public String apply(Parameter input) {
                AllowableListValues allowableValues = (AllowableListValues)input.getAllowableValues();
                return String.format("%s=%s", input.getName(), ((String)allowableValues.getValues().get(0)).trim());
            }
        };
    }

    public boolean supports(DocumentationContext delimiter) {
        return delimiter.isUriTemplatesEnabled();
    }
}

