/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;

public class CombinedRequestHandler
implements RequestHandler {
    private final RequestHandler first;
    private final RequestHandler second;

    public CombinedRequestHandler(RequestHandler first, RequestHandler second) {
        this.first = first;
        this.second = second;
    }

    public Class<?> declaringClass() {
        return this.first.declaringClass();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.first.isAnnotatedWith(annotation) || this.second.isAnnotatedWith(annotation);
    }

    public PatternsRequestCondition getPatternsCondition() {
        Sets.SetView patterns = Sets.union((Set)this.first.getPatternsCondition().getPatterns(), (Set)this.second.getPatternsCondition().getPatterns());
        return new PatternsRequestCondition((String[])patterns.toArray((Object[])new String[patterns.size()]));
    }

    public String groupName() {
        return this.first.groupName();
    }

    public String getName() {
        return this.first.getName();
    }

    public Set<RequestMethod> supportedMethods() {
        return Sets.union((Set)this.first.supportedMethods(), (Set)this.second.supportedMethods());
    }

    public Set<? extends MediaType> produces() {
        return Sets.union((Set)this.first.produces(), (Set)this.second.produces());
    }

    public Set<? extends MediaType> consumes() {
        return Sets.union((Set)this.first.consumes(), (Set)this.second.consumes());
    }

    public Set<NameValueExpression<String>> headers() {
        return Sets.union((Set)this.first.headers(), (Set)this.second.headers());
    }

    public Set<NameValueExpression<String>> params() {
        return this.first.params();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return this.first.findAnnotation(annotation).or(this.second.findAnnotation(annotation));
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.getPatternsCondition().getPatterns(), this.supportedMethods(), this.consumes(), this.produces());
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.first.getParameters();
    }

    public ResolvedType getReturnType() {
        return this.first.getReturnType();
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return this.first.findControllerAnnotation(annotation).or(this.second.findControllerAnnotation(annotation));
    }

    public RequestMappingInfo getRequestMapping() {
        return this.first.getRequestMapping();
    }

    public HandlerMethod getHandlerMethod() {
        return this.second.getHandlerMethod();
    }

    public RequestHandler combine(RequestHandler other) {
        return new CombinedRequestHandler(this, other);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CombinedRequestHandler{");
        sb.append("first key=").append(this.first.key());
        sb.append("second key=").append(this.second.key());
        sb.append("combined key=").append(this.key());
        sb.append('}');
        return sb.toString();
    }
}

