/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Function;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spring.web.paths.Paths;

@Component
@Order(value=-2147483648)
public class ApiListingReader
implements ApiListingBuilderPlugin {
    public void apply(ApiListingContext apiListingContext) {
        ResourceGroup group = apiListingContext.getResourceGroup();
        String description = (String)group.getControllerClass().transform(this.description()).or((Object)group.getGroupName());
        apiListingContext.apiListingBuilder().description(description);
    }

    private Function<Class<?>, String> description() {
        return new Function<Class<?>, String>(){

            public String apply(Class<?> input) {
                return Paths.splitCamelCase(input.getSimpleName(), " ");
            }
        };
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

