/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import java.util.ArrayList;
import java.util.List;

public class HttpClientResponseImpl
implements HttpClientResponse {
    private static final Logger log = LoggerFactory.getLogger(HttpClientResponseImpl.class);
    private final HttpVersion version;
    private final int statusCode;
    private final String statusMessage;
    private final HttpClientRequestBase request;
    private final HttpConnection conn;
    private final HttpClientStream stream;
    private Handler<Buffer> dataHandler;
    private Handler<HttpFrame> customFrameHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean hasPausedEnd;
    private boolean paused;
    private Buffer pausedLastChunk;
    private MultiMap pausedTrailers;
    private NetSocket netSocket;
    private long bytesRead;
    private MultiMap headers;
    private MultiMap trailers;
    private List<String> cookies;

    HttpClientResponseImpl(HttpClientRequestBase request, HttpVersion version, HttpClientStream stream, int statusCode, String statusMessage, MultiMap headers) {
        this.version = version;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.request = request;
        this.stream = stream;
        this.conn = stream.connection();
        this.headers = headers;
    }

    @Override
    public HttpClientRequestBase request() {
        return this.request;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public String getHeader(CharSequence headerName) {
        return this.headers().get(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap trailers() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.trailers == null) {
                this.trailers = new HeadersAdaptor((io.netty.handler.codec.http.HttpHeaders)new DefaultHttpHeaders());
            }
            return this.trailers;
        }
    }

    @Override
    public String getTrailer(String trailerName) {
        return this.trailers != null ? this.trailers.get(trailerName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> cookies() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<String>();
                this.cookies.addAll(this.headers().getAll(HttpHeaders.SET_COOKIE));
                if (this.trailers != null) {
                    this.cookies.addAll(this.trailers.getAll(HttpHeaders.SET_COOKIE));
                }
            }
            return this.cookies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse handler(Handler<Buffer> dataHandler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            this.dataHandler = dataHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse endHandler(Handler<Void> endHandler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            this.endHandler = endHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> exceptionHandler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse pause() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (!this.paused) {
                this.paused = true;
                this.stream.doPause();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse resume() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.paused) {
                this.paused = false;
                this.doResume();
                this.stream.doResume();
            }
            return this;
        }
    }

    @Override
    public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
        BodyHandler handler = new BodyHandler();
        this.handler((Handler)handler);
        this.endHandler(v -> handler.notifyHandler(bodyHandler));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            this.customFrameHandler = handler;
            return this;
        }
    }

    private void doResume() {
        if (this.hasPausedEnd) {
            Buffer theChunk = this.pausedLastChunk;
            MultiMap theTrailer = this.pausedTrailers;
            this.stream.getContext().runOnContext(v -> this.handleEnd(theChunk, theTrailer));
            this.hasPausedEnd = false;
            this.pausedTrailers = null;
            this.pausedLastChunk = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnknowFrame(HttpFrame frame) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.customFrameHandler != null) {
                try {
                    this.customFrameHandler.handle(frame);
                }
                catch (Throwable t) {
                    this.handleException(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleChunk(Buffer data) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            this.request.dataReceived();
            this.bytesRead += (long)data.length();
            if (this.dataHandler != null) {
                try {
                    this.dataHandler.handle(data);
                }
                catch (Throwable t) {
                    this.handleException(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd(Buffer lastChunk, MultiMap trailers) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            this.stream.reportBytesRead(this.bytesRead);
            this.bytesRead = 0L;
            if (this.paused) {
                this.pausedLastChunk = lastChunk;
                this.hasPausedEnd = true;
                this.pausedTrailers = trailers;
            } else {
                if (lastChunk != null) {
                    this.handleChunk(lastChunk);
                }
                this.trailers = trailers;
                if (this.endHandler != null) {
                    try {
                        this.endHandler.handle(null);
                    }
                    catch (Throwable t) {
                        this.handleException(t);
                    }
                }
                this.request.handleResponseEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable e) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(e);
            } else {
                log.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket netSocket() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.netSocket == null) {
                this.netSocket = this.stream.createNetSocket();
            }
            return this.netSocket;
        }
    }

    private static final class BodyHandler
    implements Handler<Buffer> {
        private Buffer body;

        private BodyHandler() {
        }

        @Override
        public void handle(Buffer event) {
            this.body().appendBuffer(event);
        }

        private Buffer body() {
            if (this.body == null) {
                this.body = Buffer.buffer();
            }
            return this.body;
        }

        void notifyHandler(Handler<Buffer> bodyHandler) {
            bodyHandler.handle(this.body());
            this.body = null;
        }
    }
}

