/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.internal.Platform;
import io.grpc.Metadata;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

final class TagContextBinaryMarshaller
implements Metadata.BinaryMarshaller<Map<String, String>> {
    static final byte VERSION = 0;
    static final byte TAG_FIELD_ID = 0;
    static final byte[] EMPTY_BYTES = new byte[0];

    TagContextBinaryMarshaller() {
    }

    public byte[] toBytes(Map<String, String> tagContext) {
        if (tagContext == null) {
            throw new NullPointerException("tagContext == null");
        }
        if (tagContext.isEmpty()) {
            return EMPTY_BYTES;
        }
        byte[] result = new byte[TagContextBinaryMarshaller.sizeInBytes(tagContext)];
        Buffer bytes = new Buffer(result);
        bytes.writeByte(0);
        for (Map.Entry<String, String> entry : tagContext.entrySet()) {
            bytes.writeByte(0);
            bytes.writeLengthPrefixed(entry.getKey());
            bytes.writeLengthPrefixed(entry.getValue());
        }
        return result;
    }

    public Map<String, String> parseBytes(byte[] buf) {
        if (buf == null) {
            throw new NullPointerException("buf == null");
        }
        if (buf.length == 0) {
            return Collections.emptyMap();
        }
        Buffer bytes = new Buffer(buf);
        byte version = bytes.readByte();
        if (version != 0) {
            Platform.get().log("Invalid input: unsupported version {0}", (Object)version, null);
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (bytes.remaining() > 3) {
            if (bytes.readByte() == 0) {
                String val;
                String key = bytes.readLengthPrefixed();
                if (key == null || (val = bytes.readLengthPrefixed()) == null) break;
                result.put(key, val);
                continue;
            }
            Platform.get().log("Invalid input: expected TAG_FIELD_ID at offset {0}", (Object)bytes.pos, null);
            break;
        }
        return result;
    }

    static int sizeInBytes(Map<String, String> tagContext) {
        int sizeInBytes = 1;
        for (Map.Entry<String, String> entry : tagContext.entrySet()) {
            ++sizeInBytes;
            int keyLength = entry.getKey().length();
            int valLength = entry.getValue().length();
            if (keyLength > 16383 || valLength > 16383) {
                return sizeInBytes;
            }
            sizeInBytes += TagContextBinaryMarshaller.sizeOfLengthPrefixedString(keyLength);
            sizeInBytes += TagContextBinaryMarshaller.sizeOfLengthPrefixedString(valLength);
        }
        return sizeInBytes;
    }

    static int sizeOfLengthPrefixedString(int length) {
        return (length > 127 ? 2 : 1) + length;
    }

    static final class Buffer {
        final byte[] buf;
        int pos;

        Buffer(byte[] buf) {
            this.buf = buf;
        }

        int remaining() {
            return this.buf.length - this.pos;
        }

        byte readByte() {
            return this.buf[this.pos++];
        }

        void writeByte(int v) {
            this.buf[this.pos++] = (byte)v;
        }

        boolean writeLengthPrefixed(String value) {
            int length = value.length();
            if (length > 16383) {
                return false;
            }
            if (length > 127) {
                this.buf[this.pos++] = (byte)(length & 0x7F | 0x80);
                this.buf[this.pos++] = (byte)(length >>> 7);
            } else {
                this.buf[this.pos++] = (byte)length;
            }
            for (int i = 0; i < length; ++i) {
                this.buf[this.pos++] = (byte)value.charAt(i);
            }
            return true;
        }

        String readLengthPrefixed() {
            byte b1;
            if ((b1 = this.buf[this.pos++]) >= 0) {
                return this.readAsciiString(b1);
            }
            return this.readAsciiString(this.readVarint(b1));
        }

        private int readVarint(byte b1) {
            byte b2;
            if (((b2 = this.buf[this.pos++]) & 0xF0) != 0) {
                Platform.get().log("Greater than 14-bit varint at position {0}", (Object)this.pos, null);
                return -1;
            }
            return b1 & 0x7F | b2 << 28;
        }

        String readAsciiString(int length) {
            if (length == -1 || this.remaining() < length) {
                return null;
            }
            char[] string = new char[length];
            for (int i = 0; i < length; ++i) {
                string[i] = (char)this.buf[this.pos++];
            }
            return new String(string);
        }
    }
}

