/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.grpc.GrpcPropagation;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.propagation.TraceContext;
import com.google.common.base.Preconditions;
import java.util.Collections;

final class TraceContextBinaryFormat {
    static final byte VERSION = 0;
    static final byte TRACE_ID_FIELD_ID = 0;
    static final byte SPAN_ID_FIELD_ID = 1;
    static final byte TRACE_OPTION_FIELD_ID = 2;
    static final int FORMAT_LENGTH = 29;

    TraceContextBinaryFormat() {
    }

    static byte[] toBytes(TraceContext traceContext) {
        Preconditions.checkNotNull((Object)traceContext, (Object)"traceContext");
        byte[] bytes = new byte[29];
        bytes[0] = 0;
        bytes[1] = 0;
        TraceContextBinaryFormat.writeLong(bytes, 2, traceContext.traceIdHigh());
        TraceContextBinaryFormat.writeLong(bytes, 10, traceContext.traceId());
        bytes[18] = 1;
        TraceContextBinaryFormat.writeLong(bytes, 19, traceContext.spanId());
        bytes[27] = 2;
        if (traceContext.sampled() != null && traceContext.sampled().booleanValue()) {
            bytes[28] = 1;
        }
        return bytes;
    }

    @Nullable
    static TraceContext parseBytes(byte[] bytes, @Nullable GrpcPropagation.Tags tags) {
        if (bytes == null) {
            throw new NullPointerException("bytes == null");
        }
        if (bytes.length == 0) {
            return null;
        }
        if (bytes[0] != 0) {
            Platform.get().log("Invalid input: unsupported version {0}", (Object)bytes[0], null);
            return null;
        }
        if (bytes.length < 27) {
            Platform.get().log("Invalid input: truncated", null);
            return null;
        }
        int pos = 1;
        if (bytes[pos] != 0) {
            Platform.get().log("Invalid input: expected trace ID at offset {0}", (Object)pos, null);
            return null;
        }
        long traceIdHigh = TraceContextBinaryFormat.readLong(bytes, ++pos);
        long traceId = TraceContextBinaryFormat.readLong(bytes, pos + 8);
        if (bytes[pos += 16] != 1) {
            Platform.get().log("Invalid input: expected span ID at offset {0}", (Object)pos, null);
            return null;
        }
        long spanId = TraceContextBinaryFormat.readLong(bytes, ++pos);
        Boolean sampled = null;
        if (bytes.length > (pos += 8) && bytes[pos] == 2) {
            if (bytes.length < ++pos + 1) {
                Platform.get().log("Invalid input: truncated", null);
                return null;
            }
            sampled = bytes[pos] == 1;
        }
        TraceContext.Builder builder = TraceContext.newBuilder().traceIdHigh(traceIdHigh).traceId(traceId).spanId(spanId);
        if (sampled != null) {
            builder.sampled(sampled.booleanValue());
        }
        if (tags != null) {
            builder.extra(Collections.singletonList(tags));
        }
        return builder.build();
    }

    static void writeLong(byte[] data, int pos, long v) {
        data[pos + 0] = (byte)(v >>> 56 & 0xFFL);
        data[pos + 1] = (byte)(v >>> 48 & 0xFFL);
        data[pos + 2] = (byte)(v >>> 40 & 0xFFL);
        data[pos + 3] = (byte)(v >>> 32 & 0xFFL);
        data[pos + 4] = (byte)(v >>> 24 & 0xFFL);
        data[pos + 5] = (byte)(v >>> 16 & 0xFFL);
        data[pos + 6] = (byte)(v >>> 8 & 0xFFL);
        data[pos + 7] = (byte)(v & 0xFFL);
    }

    static long readLong(byte[] data, int pos) {
        return ((long)data[pos] & 0xFFL) << 56 | ((long)data[pos + 1] & 0xFFL) << 48 | ((long)data[pos + 2] & 0xFFL) << 40 | ((long)data[pos + 3] & 0xFFL) << 32 | ((long)data[pos + 4] & 0xFFL) << 24 | ((long)data[pos + 5] & 0xFFL) << 16 | ((long)data[pos + 6] & 0xFFL) << 8 | (long)data[pos + 7] & 0xFFL;
    }
}

