/*
 * Decompiled with CFR 0.152.
 */
package brave.rpc;

import brave.Tracing;
import brave.internal.Nullable;
import brave.rpc.RpcRequest;
import brave.rpc.RpcRequestParser;
import brave.rpc.RpcResponseParser;
import brave.sampler.SamplerFunction;
import brave.sampler.SamplerFunctions;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;

public class RpcTracing
implements Closeable {
    static final AtomicReference<RpcTracing> CURRENT = new AtomicReference();
    final Tracing tracing;
    final RpcRequestParser clientRequestParser;
    final RpcRequestParser serverRequestParser;
    final RpcResponseParser clientResponseParser;
    final RpcResponseParser serverResponseParser;
    final SamplerFunction<RpcRequest> clientSampler;
    final SamplerFunction<RpcRequest> serverSampler;

    public static RpcTracing create(Tracing tracing) {
        return RpcTracing.newBuilder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    public Tracing tracing() {
        return this.tracing;
    }

    public RpcRequestParser clientRequestParser() {
        return this.clientRequestParser;
    }

    public RpcResponseParser clientResponseParser() {
        return this.clientResponseParser;
    }

    public RpcRequestParser serverRequestParser() {
        return this.serverRequestParser;
    }

    public RpcResponseParser serverResponseParser() {
        return this.serverResponseParser;
    }

    public SamplerFunction<RpcRequest> clientSampler() {
        return this.clientSampler;
    }

    public SamplerFunction<RpcRequest> serverSampler() {
        return this.serverSampler;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    RpcTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.clientRequestParser = builder.clientRequestParser;
        this.serverRequestParser = builder.serverRequestParser;
        this.clientResponseParser = builder.clientResponseParser;
        this.serverResponseParser = builder.serverResponseParser;
        this.clientSampler = builder.clientSampler;
        this.serverSampler = builder.serverSampler;
        CURRENT.compareAndSet(null, this);
    }

    @Nullable
    public static RpcTracing current() {
        return CURRENT.get();
    }

    @Override
    public void close() {
        CURRENT.compareAndSet(this, null);
    }

    public static final class Builder {
        Tracing tracing;
        RpcRequestParser clientRequestParser;
        RpcRequestParser serverRequestParser;
        RpcResponseParser clientResponseParser;
        RpcResponseParser serverResponseParser;
        SamplerFunction<RpcRequest> clientSampler;
        SamplerFunction<RpcRequest> serverSampler;

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
            this.clientRequestParser = this.serverRequestParser = RpcRequestParser.DEFAULT;
            this.clientResponseParser = this.serverResponseParser = RpcResponseParser.DEFAULT;
            this.clientSampler = SamplerFunctions.deferDecision();
            this.serverSampler = SamplerFunctions.deferDecision();
        }

        Builder(RpcTracing source) {
            this.tracing = source.tracing;
            this.clientRequestParser = source.clientRequestParser;
            this.serverRequestParser = source.serverRequestParser;
            this.clientResponseParser = source.clientResponseParser;
            this.serverResponseParser = source.serverResponseParser;
            this.clientSampler = source.clientSampler;
            this.serverSampler = source.serverSampler;
        }

        public Builder tracing(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
            return this;
        }

        public Builder clientRequestParser(RpcRequestParser clientRequestParser) {
            if (clientRequestParser == null) {
                throw new NullPointerException("clientRequestParser == null");
            }
            this.clientRequestParser = clientRequestParser;
            return this;
        }

        public Builder clientResponseParser(RpcResponseParser clientResponseParser) {
            if (clientResponseParser == null) {
                throw new NullPointerException("clientResponseParser == null");
            }
            this.clientResponseParser = clientResponseParser;
            return this;
        }

        public Builder serverRequestParser(RpcRequestParser serverRequestParser) {
            if (serverRequestParser == null) {
                throw new NullPointerException("serverRequestParser == null");
            }
            this.serverRequestParser = serverRequestParser;
            return this;
        }

        public Builder serverResponseParser(RpcResponseParser serverResponseParser) {
            if (serverResponseParser == null) {
                throw new NullPointerException("serverResponseParser == null");
            }
            this.serverResponseParser = serverResponseParser;
            return this;
        }

        public Builder clientSampler(SamplerFunction<RpcRequest> clientSampler) {
            if (clientSampler == null) {
                throw new NullPointerException("clientSampler == null");
            }
            this.clientSampler = clientSampler;
            return this;
        }

        public Builder serverSampler(SamplerFunction<RpcRequest> serverSampler) {
            if (serverSampler == null) {
                throw new NullPointerException("serverSampler == null");
            }
            this.serverSampler = serverSampler;
            return this;
        }

        public RpcTracing build() {
            return new RpcTracing(this);
        }
    }
}

