/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class MessageIdProvider {
    private final int messageIdLength;
    private final MessageDigest messageDigest;
    private final String hostname;

    public MessageIdProvider(String hostname) throws NoSuchAlgorithmException {
        this(8, MessageDigest.getInstance("MD5"), hostname);
    }

    public MessageIdProvider(int message_id_length, MessageDigest messageDigest, String hostname) {
        this.messageIdLength = message_id_length;
        this.messageDigest = messageDigest;
        this.hostname = hostname;
    }

    public byte[] get() {
        String timestamp = String.valueOf(System.nanoTime());
        byte[] digestString = (this.hostname + timestamp).getBytes();
        return Arrays.copyOf(this.messageDigest.digest(digestString), this.messageIdLength);
    }
}

