/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentationMagician;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation_swipeback.R;
import me.yokeyword.fragmentation_swipeback.core.ISwipeBackActivity;

public class SwipeBackLayout
extends FrameLayout {
    public static final int EDGE_LEFT = 1;
    public static final int EDGE_RIGHT = 2;
    public static final int EDGE_ALL = 3;
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int STATE_FINISHED = 3;
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final float DEFAULT_PARALLAX = 0.33f;
    private static final int FULL_ALPHA = 255;
    private static final float DEFAULT_SCROLL_THRESHOLD = 0.4f;
    private static final int OVERSCROLL_DISTANCE = 10;
    private float mScrollFinishThreshold = 0.4f;
    private ViewDragHelper mHelper;
    private float mScrollPercent;
    private float mScrimOpacity;
    private FragmentActivity mActivity;
    private View mContentView;
    private ISupportFragment mFragment;
    private Fragment mPreFragment;
    private Drawable mShadowLeft;
    private Drawable mShadowRight;
    private Rect mTmpRect = new Rect();
    private int mEdgeFlag;
    private boolean mEnable = true;
    private int mCurrentSwipeOrientation;
    private float mParallaxOffset = 0.33f;
    private boolean mCallOnDestroyView;
    private boolean mInLayout;
    private int mContentLeft;
    private int mContentTop;
    private List<OnSwipeListener> mListeners;
    private Context mContext;

    public SwipeBackLayout(Context context) {
        this(context, null);
    }

    public SwipeBackLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeBackLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)new ViewDragCallback());
        this.setShadow(R.drawable.shadow_left, 1);
        this.setEdgeOrientation(1);
    }

    public ViewDragHelper getViewDragHelper() {
        return this.mHelper;
    }

    public void setScrollThresHold(float threshold) {
        if (threshold >= 1.0f || threshold <= 0.0f) {
            throw new IllegalArgumentException("Threshold value should be between 0 and 1.0");
        }
        this.mScrollFinishThreshold = threshold;
    }

    public void setParallaxOffset(float offset) {
        this.mParallaxOffset = offset;
    }

    public void setEdgeOrientation(int orientation) {
        this.mEdgeFlag = orientation;
        this.mHelper.setEdgeTrackingEnabled(orientation);
        if (orientation == 2 || orientation == 3) {
            this.setShadow(R.drawable.shadow_right, 2);
        }
    }

    public void setShadow(Drawable shadow, int edgeFlag) {
        if ((edgeFlag & 1) != 0) {
            this.mShadowLeft = shadow;
        } else if ((edgeFlag & 2) != 0) {
            this.mShadowRight = shadow;
        }
        this.invalidate();
    }

    public void setShadow(int resId, int edgeFlag) {
        this.setShadow(this.getResources().getDrawable(resId), edgeFlag);
    }

    public void addSwipeListener(OnSwipeListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<OnSwipeListener>();
        }
        this.mListeners.add(listener);
    }

    public void removeSwipeListener(OnSwipeListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean isDrawView = child == this.mContentView;
        boolean drawChild = super.drawChild(canvas, child, drawingTime);
        if (isDrawView && this.mScrimOpacity > 0.0f && this.mHelper.getViewDragState() != 0) {
            this.drawShadow(canvas, child);
            this.drawScrim(canvas, child);
        }
        return drawChild;
    }

    private void drawShadow(Canvas canvas, View child) {
        Rect childRect = this.mTmpRect;
        child.getHitRect(childRect);
        if ((this.mCurrentSwipeOrientation & 1) != 0) {
            this.mShadowLeft.setBounds(childRect.left - this.mShadowLeft.getIntrinsicWidth(), childRect.top, childRect.left, childRect.bottom);
            this.mShadowLeft.setAlpha((int)(this.mScrimOpacity * 255.0f));
            this.mShadowLeft.draw(canvas);
        } else if ((this.mCurrentSwipeOrientation & 2) != 0) {
            this.mShadowRight.setBounds(childRect.right, childRect.top, childRect.right + this.mShadowRight.getIntrinsicWidth(), childRect.bottom);
            this.mShadowRight.setAlpha((int)(this.mScrimOpacity * 255.0f));
            this.mShadowRight.draw(canvas);
        }
    }

    private void drawScrim(Canvas canvas, View child) {
        int baseAlpha = 153;
        int alpha = (int)(153.0f * this.mScrimOpacity);
        int color = alpha << 24;
        if ((this.mCurrentSwipeOrientation & 1) != 0) {
            canvas.clipRect(0, 0, child.getLeft(), this.getHeight());
        } else if ((this.mCurrentSwipeOrientation & 2) != 0) {
            canvas.clipRect(child.getRight(), 0, this.getRight(), this.getHeight());
        }
        canvas.drawColor(color);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mInLayout = true;
        if (this.mContentView != null) {
            this.mContentView.layout(this.mContentLeft, this.mContentTop, this.mContentLeft + this.mContentView.getMeasuredWidth(), this.mContentTop + this.mContentView.getMeasuredHeight());
        }
        this.mInLayout = false;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    public void computeScroll() {
        this.mScrimOpacity = 1.0f - this.mScrollPercent;
        if (this.mScrimOpacity >= 0.0f) {
            if (this.mHelper.continueSettling(true)) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
            if (this.mPreFragment != null && this.mPreFragment.getView() != null) {
                if (this.mCallOnDestroyView) {
                    this.mPreFragment.getView().setX(0.0f);
                    return;
                }
                if (this.mHelper.getCapturedView() != null) {
                    int leftOffset = (int)((float)(this.mHelper.getCapturedView().getLeft() - this.getWidth()) * this.mParallaxOffset * this.mScrimOpacity);
                    this.mPreFragment.getView().setX(leftOffset > 0 ? 0.0f : (float)leftOffset);
                }
            }
        }
    }

    public void internalCallOnDestroyView() {
        this.mCallOnDestroyView = true;
    }

    public void setFragment(ISupportFragment fragment, View view) {
        this.mFragment = fragment;
        this.mContentView = view;
    }

    public void hiddenFragment() {
        if (this.mPreFragment != null && this.mPreFragment.getView() != null) {
            this.mPreFragment.getView().setVisibility(8);
        }
    }

    public void attachToActivity(FragmentActivity activity) {
        this.mActivity = activity;
        TypedArray a = activity.getTheme().obtainStyledAttributes(new int[]{16842836});
        int background = a.getResourceId(0, 0);
        a.recycle();
        ViewGroup decor = (ViewGroup)activity.getWindow().getDecorView();
        ViewGroup decorChild = (ViewGroup)decor.getChildAt(0);
        decorChild.setBackgroundResource(background);
        decor.removeView((View)decorChild);
        this.addView((View)decorChild);
        this.setContentView((View)decorChild);
        decor.addView((View)this);
    }

    public void attachToFragment(ISupportFragment fragment, View view) {
        this.addView(view);
        this.setFragment(fragment, view);
    }

    private void setContentView(View view) {
        this.mContentView = view;
    }

    public void setEnableGesture(boolean enable) {
        this.mEnable = enable;
    }

    public void setEdgeLevel(EdgeLevel edgeLevel) {
        this.validateEdgeLevel(-1, edgeLevel);
    }

    public void setEdgeLevel(int widthPixel) {
        this.validateEdgeLevel(widthPixel, null);
    }

    private void validateEdgeLevel(int widthPixel, EdgeLevel edgeLevel) {
        try {
            DisplayMetrics metrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(metrics);
            Field mEdgeSize = this.mHelper.getClass().getDeclaredField("mEdgeSize");
            mEdgeSize.setAccessible(true);
            if (widthPixel >= 0) {
                mEdgeSize.setInt(this.mHelper, widthPixel);
            } else if (edgeLevel == EdgeLevel.MAX) {
                mEdgeSize.setInt(this.mHelper, metrics.widthPixels);
            } else if (edgeLevel == EdgeLevel.MED) {
                mEdgeSize.setInt(this.mHelper, metrics.widthPixels / 2);
            } else {
                mEdgeSize.setInt(this.mHelper, (int)(20.0f * metrics.density + 0.5f));
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void onDragFinished() {
        if (this.mListeners != null) {
            for (OnSwipeListener listener : this.mListeners) {
                listener.onDragStateChange(3);
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mEnable) {
            return super.onInterceptTouchEvent(ev);
        }
        try {
            return this.mHelper.shouldInterceptTouchEvent(ev);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return false;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnable) {
            return super.onTouchEvent(event);
        }
        try {
            this.mHelper.processTouchEvent(event);
            return true;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return false;
        }
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private ViewDragCallback() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            boolean dragEnable = SwipeBackLayout.this.mHelper.isEdgeTouched(SwipeBackLayout.this.mEdgeFlag, pointerId);
            if (dragEnable) {
                if (SwipeBackLayout.this.mHelper.isEdgeTouched(1, pointerId)) {
                    SwipeBackLayout.this.mCurrentSwipeOrientation = 1;
                } else if (SwipeBackLayout.this.mHelper.isEdgeTouched(2, pointerId)) {
                    SwipeBackLayout.this.mCurrentSwipeOrientation = 2;
                }
                if (SwipeBackLayout.this.mListeners != null) {
                    for (OnSwipeListener listener : SwipeBackLayout.this.mListeners) {
                        listener.onEdgeTouch(SwipeBackLayout.this.mCurrentSwipeOrientation);
                    }
                }
                if (SwipeBackLayout.this.mPreFragment == null) {
                    List fragmentList;
                    if (SwipeBackLayout.this.mFragment != null && (fragmentList = FragmentationMagician.getActiveFragments((FragmentManager)((Fragment)SwipeBackLayout.this.mFragment).getFragmentManager())) != null && fragmentList.size() > 1) {
                        int index = fragmentList.indexOf(SwipeBackLayout.this.mFragment);
                        for (int i = index - 1; i >= 0; --i) {
                            Fragment fragment = (Fragment)fragmentList.get(i);
                            if (fragment == null || fragment.getView() == null) continue;
                            fragment.getView().setVisibility(0);
                            SwipeBackLayout.this.mPreFragment = fragment;
                            break;
                        }
                    }
                } else {
                    View preView = SwipeBackLayout.this.mPreFragment.getView();
                    if (preView != null && preView.getVisibility() != 0) {
                        preView.setVisibility(0);
                    }
                }
            }
            return dragEnable;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            int ret = 0;
            if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 1) != 0) {
                ret = Math.min(child.getWidth(), Math.max(left, 0));
            } else if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 2) != 0) {
                ret = Math.min(0, Math.max(left, -child.getWidth()));
            }
            return ret;
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 1) != 0) {
                SwipeBackLayout.this.mScrollPercent = Math.abs((float)left / (float)(SwipeBackLayout.this.mContentView.getWidth() + SwipeBackLayout.this.mShadowLeft.getIntrinsicWidth()));
            } else if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 2) != 0) {
                SwipeBackLayout.this.mScrollPercent = Math.abs((float)left / (float)(SwipeBackLayout.this.mContentView.getWidth() + SwipeBackLayout.this.mShadowRight.getIntrinsicWidth()));
            }
            SwipeBackLayout.this.mContentLeft = left;
            SwipeBackLayout.this.mContentTop = top;
            SwipeBackLayout.this.invalidate();
            if (SwipeBackLayout.this.mListeners != null && SwipeBackLayout.this.mHelper.getViewDragState() == 1 && SwipeBackLayout.this.mScrollPercent <= 1.0f && SwipeBackLayout.this.mScrollPercent > 0.0f) {
                for (OnSwipeListener listener : SwipeBackLayout.this.mListeners) {
                    listener.onDragScrolled(SwipeBackLayout.this.mScrollPercent);
                }
            }
            if (SwipeBackLayout.this.mScrollPercent > 1.0f) {
                if (SwipeBackLayout.this.mFragment != null) {
                    if (SwipeBackLayout.this.mCallOnDestroyView) {
                        return;
                    }
                    if (!((Fragment)SwipeBackLayout.this.mFragment).isDetached()) {
                        SwipeBackLayout.this.onDragFinished();
                        SwipeBackLayout.this.mFragment.getSupportDelegate().popQuiet();
                    }
                } else if (!SwipeBackLayout.this.mActivity.isFinishing()) {
                    SwipeBackLayout.this.onDragFinished();
                    SwipeBackLayout.this.mActivity.finish();
                    SwipeBackLayout.this.mActivity.overridePendingTransition(0, 0);
                }
            }
        }

        public int getViewHorizontalDragRange(View child) {
            if (SwipeBackLayout.this.mFragment != null) {
                return 1;
            }
            if (SwipeBackLayout.this.mActivity instanceof ISwipeBackActivity && ((ISwipeBackActivity)SwipeBackLayout.this.mActivity).swipeBackPriority()) {
                return 1;
            }
            return 0;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int childWidth = releasedChild.getWidth();
            int left = 0;
            int top = 0;
            if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 1) != 0) {
                left = xvel > 0.0f || xvel == 0.0f && SwipeBackLayout.this.mScrollPercent > SwipeBackLayout.this.mScrollFinishThreshold ? childWidth + SwipeBackLayout.this.mShadowLeft.getIntrinsicWidth() + 10 : 0;
            } else if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 2) != 0) {
                left = xvel < 0.0f || xvel == 0.0f && SwipeBackLayout.this.mScrollPercent > SwipeBackLayout.this.mScrollFinishThreshold ? -(childWidth + SwipeBackLayout.this.mShadowRight.getIntrinsicWidth() + 10) : 0;
            }
            SwipeBackLayout.this.mHelper.settleCapturedViewAt(left, top);
            SwipeBackLayout.this.invalidate();
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SwipeBackLayout.this.mListeners != null) {
                for (OnSwipeListener listener : SwipeBackLayout.this.mListeners) {
                    listener.onDragStateChange(state);
                }
            }
        }

        public void onEdgeTouched(int edgeFlags, int pointerId) {
            super.onEdgeTouched(edgeFlags, pointerId);
            if ((SwipeBackLayout.this.mEdgeFlag & edgeFlags) != 0) {
                SwipeBackLayout.this.mCurrentSwipeOrientation = edgeFlags;
            }
        }
    }

    public static interface OnSwipeListener {
        public void onDragStateChange(int var1);

        public void onEdgeTouch(int var1);

        public void onDragScrolled(float var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EdgeOrientation {
    }

    public static enum EdgeLevel {
        MAX,
        MIN,
        MED;

    }
}

