/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation_swipeback.core;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.ViewGroup;
import me.yokeyword.fragmentation.ISupportActivity;
import me.yokeyword.fragmentation.SwipeBackLayout;
import me.yokeyword.fragmentation_swipeback.core.ISwipeBackActivity;

public class SwipeBackActivityDelegate {
    private FragmentActivity mActivity;
    private SwipeBackLayout mSwipeBackLayout;

    public SwipeBackActivityDelegate(ISwipeBackActivity swipeBackActivity) {
        if (!(swipeBackActivity instanceof FragmentActivity) || !(swipeBackActivity instanceof ISupportActivity)) {
            throw new RuntimeException("Must extends FragmentActivity/AppCompatActivity and implements ISupportActivity");
        }
        this.mActivity = (FragmentActivity)swipeBackActivity;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.onActivityCreate();
    }

    public void onPostCreate(Bundle savedInstanceState) {
        this.mSwipeBackLayout.attachToActivity(this.mActivity);
    }

    public SwipeBackLayout getSwipeBackLayout() {
        return this.mSwipeBackLayout;
    }

    public void setSwipeBackEnable(boolean enable) {
        this.mSwipeBackLayout.setEnableGesture(enable);
    }

    public void setEdgeLevel(SwipeBackLayout.EdgeLevel edgeLevel) {
        this.mSwipeBackLayout.setEdgeLevel(edgeLevel);
    }

    public void setEdgeLevel(int widthPixel) {
        this.mSwipeBackLayout.setEdgeLevel(widthPixel);
    }

    public boolean swipeBackPriority() {
        return this.mActivity.getSupportFragmentManager().getBackStackEntryCount() <= 1;
    }

    private void onActivityCreate() {
        this.mActivity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mActivity.getWindow().getDecorView().setBackgroundColor(0);
        this.mSwipeBackLayout = new SwipeBackLayout((Context)this.mActivity);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mSwipeBackLayout.setLayoutParams(params);
    }
}

