/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.fragmentation_swipeback.core;

import android.os.Bundle;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.View;
import android.view.ViewGroup;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SwipeBackLayout;
import me.yokeyword.fragmentation_swipeback.core.ISwipeBackFragment;

public class SwipeBackFragmentDelegate {
    private Fragment mFragment;
    private ISupportFragment mSupport;
    private SwipeBackLayout mSwipeBackLayout;

    public SwipeBackFragmentDelegate(ISwipeBackFragment swipeBackFragment) {
        if (!(swipeBackFragment instanceof Fragment) || !(swipeBackFragment instanceof ISupportFragment)) {
            throw new RuntimeException("Must extends Fragment and implements ISupportFragment!");
        }
        this.mFragment = (Fragment)swipeBackFragment;
        this.mSupport = (ISupportFragment)swipeBackFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        this.onFragmentCreate();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        if (view instanceof SwipeBackLayout) {
            View childView = ((SwipeBackLayout)view).getChildAt(0);
            this.mSupport.getSupportDelegate().setBackground(childView);
        } else {
            this.mSupport.getSupportDelegate().setBackground(view);
        }
    }

    public View attachToSwipeBack(View view) {
        this.mSwipeBackLayout.attachToFragment(this.mSupport, view);
        return this.mSwipeBackLayout;
    }

    public void setEdgeLevel(SwipeBackLayout.EdgeLevel edgeLevel) {
        this.mSwipeBackLayout.setEdgeLevel(edgeLevel);
    }

    public void setEdgeLevel(int widthPixel) {
        this.mSwipeBackLayout.setEdgeLevel(widthPixel);
    }

    public void onHiddenChanged(boolean hidden) {
        if (hidden && this.mSwipeBackLayout != null) {
            this.mSwipeBackLayout.hiddenFragment();
        }
    }

    public SwipeBackLayout getSwipeBackLayout() {
        return this.mSwipeBackLayout;
    }

    public void setSwipeBackEnable(boolean enable) {
        this.mSwipeBackLayout.setEnableGesture(enable);
    }

    public void setParallaxOffset(@FloatRange(from=0.0, to=1.0) float offset) {
        this.mSwipeBackLayout.setParallaxOffset(offset);
    }

    public void onDestroyView() {
        this.mSwipeBackLayout.internalCallOnDestroyView();
    }

    private void onFragmentCreate() {
        if (this.mFragment.getContext() == null) {
            return;
        }
        this.mSwipeBackLayout = new SwipeBackLayout(this.mFragment.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mSwipeBackLayout.setLayoutParams(params);
        this.mSwipeBackLayout.setBackgroundColor(0);
    }
}

