/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamtools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class SplitNode {
    private String first;
    private String last;
    private SplitNode left;
    private SplitNode right;
    private long count;
    private final long start;
    private long end;
    private String threadName;

    public SplitNode() {
        this.end = this.start = System.nanoTime();
        this.threadName = Thread.currentThread().getName();
    }

    void accept(Object obj) {
        if (this.first == null) {
            this.first = obj.toString();
        } else {
            this.last = obj.toString();
        }
        ++this.count;
        this.end = System.nanoTime();
    }

    public long getCount() {
        return this.count;
    }

    public SplitNode getLeft() {
        return this.left;
    }

    public String getFirst() {
        return this.first;
    }

    public String getLast() {
        return this.last;
    }

    public SplitNode getRight() {
        return this.right;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public boolean isLeaf() {
        return this.left == null;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public long getStartNanos() {
        return this.start;
    }

    public long getEndNanos() {
        return this.end;
    }

    SplitNode combine(SplitNode that) {
        SplitNode p = new SplitNode();
        p.threadName = Thread.currentThread().getName();
        p.count = this.count + that.count;
        p.first = this.first == null ? that.first : this.first;
        p.last = Stream.of(that.last, that.first, this.last, this.first).filter(Objects::nonNull).findFirst().orElse(null);
        p.left = this;
        p.right = that;
        p.end = System.nanoTime();
        return p;
    }

    private static String pad(String s, int left, int len) {
        if (len == s.length()) {
            return s;
        }
        char[] result = new char[len];
        Arrays.fill(result, ' ');
        s.getChars(0, s.length(), result, left);
        return new String(result);
    }

    private static int leftSpaces(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            return i;
        }
        return s.length();
    }

    private static int rightSpaces(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(s.length() - 1 - i) == ' ') continue;
            return i;
        }
        return s.length();
    }

    List<String> asLines() {
        String cur = this.toString();
        if (this.left == null) {
            return Collections.singletonList(cur);
        }
        List<String> l = this.left.asLines();
        List<String> r = this.right.asLines();
        int len1 = l.get(0).length();
        int len2 = r.get(0).length();
        int mid1 = len1 / 2;
        int mid2 = len2 / 2;
        if (l.size() > r.size()) {
            len1 -= Math.min(len2, Math.max(0, l.stream().limit(r.size()).mapToInt(SplitNode::rightSpaces).max().getAsInt() - 1));
        } else if (l.size() < r.size()) {
            len2 -= Math.min(len1, Math.max(0, r.stream().limit(l.size()).mapToInt(SplitNode::leftSpaces).max().getAsInt() - 1));
        }
        int totalLen = len1 + len2 + 1;
        int leftAdd = 0;
        if (cur.length() < totalLen) {
            cur = SplitNode.pad(cur, (totalLen - cur.length()) / 2, totalLen);
        } else {
            leftAdd = (cur.length() - totalLen) / 2;
            totalLen = cur.length();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(cur);
        char[] dashes = new char[totalLen];
        Arrays.fill(dashes, ' ');
        Arrays.fill(dashes, mid1 + leftAdd + 1, len1 + len2 + 1 - mid2 + leftAdd, '_');
        int mid = totalLen / 2;
        dashes[mid] = mid1 + leftAdd == mid ? 124 : 47;
        dashes[mid + 1] = len1 + len2 - mid2 + leftAdd == mid ? 124 : 92;
        result.add(new String(dashes));
        Arrays.fill(dashes, ' ');
        dashes[mid1 + leftAdd] = 124;
        dashes[len1 + len2 + 1 - mid2 + leftAdd] = 124;
        result.add(new String(dashes));
        int maxSize = Math.max(l.size(), r.size());
        for (int i = 0; i < maxSize; ++i) {
            String rstr;
            String lstr;
            String string = l.size() > i ? (r.size() > i ? l.get(i).substring(0, len1) : l.get(i)) : (lstr = "");
            String string2 = r.size() > i ? (l.size() > i ? r.get(i).substring(r.get(i).length() - len2) : r.get(i)) : (rstr = "");
            if (lstr.isEmpty()) {
                result.add(SplitNode.pad(rstr, leftAdd + len1 - rstr.length() + len2 + 1, totalLen));
                continue;
            }
            result.add(SplitNode.pad(lstr + " " + rstr, leftAdd, totalLen));
        }
        return result;
    }

    public String toString() {
        if (this.first == null) {
            return "(empty)";
        }
        if (this.last == null) {
            return "[" + this.first + "]";
        }
        return "[" + this.first + ".." + this.last + "]";
    }
}

