/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamtools;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import one.util.streamtools.SplitNode;

public class SplitTree {
    private final SplitNode root;

    SplitTree(SplitNode root) {
        this.root = root;
    }

    private static <T> Stream<T> flatTraverse(Stream<T> src, Function<T, Stream<T>> streamProvider) {
        return src.flatMap(t -> {
            Stream result = (Stream)streamProvider.apply(t);
            return result == null ? Stream.of(t) : Stream.concat(Stream.of(t), SplitTree.flatTraverse(result, streamProvider));
        });
    }

    public SplitNode root() {
        return this.root;
    }

    public long totalNanos() {
        long min = this.nodes().mapToLong(SplitNode::getStartNanos).min().getAsLong();
        long max = this.nodes().mapToLong(SplitNode::getEndNanos).max().getAsLong();
        return max - min;
    }

    public Stream<SplitNode> nodes() {
        return SplitTree.flatTraverse(Stream.of(this.root), node -> node.isLeaf() ? null : Stream.of(node.getLeft(), node.getRight()));
    }

    public Stream<SplitNode> leafs() {
        return this.nodes().filter(SplitNode::isLeaf);
    }

    public List<String> asLines() {
        return this.root.asLines();
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.root.asLines());
    }

    public static Collector<Object, ?, SplitTree> collector() {
        return Collector.of(SplitNode::new, SplitNode::accept, SplitNode::combine, SplitTree::new, new Collector.Characteristics[0]);
    }

    public static SplitTree inspect(Stream<?> stream) {
        return ((Stream)stream.parallel()).collect(SplitTree.collector());
    }

    public static SplitTree inspect(IntStream stream) {
        return stream.parallel().collect(() -> new NodeBox(), NodeBox::accept, NodeBox::combine).tree();
    }

    public static SplitTree inspect(LongStream stream) {
        return stream.parallel().collect(() -> new NodeBox(), NodeBox::accept, NodeBox::combine).tree();
    }

    public static SplitTree inspect(DoubleStream stream) {
        return stream.parallel().collect(() -> new NodeBox(), NodeBox::accept, NodeBox::combine).tree();
    }

    private static class NodeBox {
        SplitNode node = new SplitNode();

        private NodeBox() {
        }

        void accept(Object obj) {
            this.node.accept(obj);
        }

        void combine(NodeBox other) {
            this.node = this.node.combine(other.node);
        }

        SplitTree tree() {
            return new SplitTree(this.node);
        }
    }
}

