/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.calcite.avatica.metrics.MetricsSystemConfiguration;
import org.apache.calcite.avatica.remote.AuthenticationType;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaHandler;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.AvaticaSpnegoAuthenticator;
import org.apache.calcite.avatica.server.DelegatingAvaticaHandler;
import org.apache.calcite.avatica.server.DoAsRemoteUserCallback;
import org.apache.calcite.avatica.server.HandlerFactory;
import org.apache.calcite.avatica.server.HttpRequestRemoteUserExtractor;
import org.apache.calcite.avatica.server.PropertyBasedSpnegoLoginService;
import org.apache.calcite.avatica.server.RemoteUserExtractor;
import org.apache.calcite.avatica.server.ServerCustomizer;
import org.apache.calcite.avatica.server.ServerKeytabJaasConf;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServer.class);
    private static final int MAX_ALLOWED_HEADER_SIZE = 65536;
    private Server server;
    private int port = -1;
    private final AvaticaHandler handler;
    private final AvaticaServerConfiguration config;
    private final Subject subject;
    private final SslContextFactory sslFactory;
    private final List<ServerCustomizer<Server>> serverCustomizers;
    private final int maxAllowedHeaderSize;

    @Deprecated
    public HttpServer(Handler handler) {
        this(HttpServer.wrapJettyHandler(handler));
    }

    public HttpServer(AvaticaHandler handler) {
        this(0, handler);
    }

    @Deprecated
    public HttpServer(int port, Handler handler) {
        this(port, HttpServer.wrapJettyHandler(handler));
    }

    public HttpServer(int port, AvaticaHandler handler) {
        this(port, handler, null);
    }

    public HttpServer(int port, AvaticaHandler handler, AvaticaServerConfiguration config) {
        this(port, handler, config, null);
    }

    public HttpServer(int port, AvaticaHandler handler, AvaticaServerConfiguration config, Subject subject) {
        this(port, handler, config, subject, null);
    }

    public HttpServer(int port, AvaticaHandler handler, AvaticaServerConfiguration config, Subject subject, SslContextFactory sslFactory) {
        this(port, handler, config, subject, sslFactory, Collections.emptyList(), 65536);
    }

    public HttpServer(int port, AvaticaHandler handler, AvaticaServerConfiguration config, Subject subject, SslContextFactory sslFactory, int maxAllowedHeaderSize) {
        this(port, handler, config, subject, sslFactory, Collections.emptyList(), maxAllowedHeaderSize);
    }

    private HttpServer(int port, AvaticaHandler handler, AvaticaServerConfiguration config, Subject subject, SslContextFactory sslFactory, List<ServerCustomizer<Server>> serverCustomizers, int maxAllowedHeaderSize) {
        this.port = port;
        this.handler = handler;
        this.config = config;
        this.subject = subject;
        this.sslFactory = sslFactory;
        this.serverCustomizers = serverCustomizers;
        this.maxAllowedHeaderSize = maxAllowedHeaderSize;
    }

    static AvaticaHandler wrapJettyHandler(Handler handler) {
        if (handler instanceof AvaticaHandler) {
            return (AvaticaHandler)handler;
        }
        return new DelegatingAvaticaHandler(handler);
    }

    public void start() {
        if (null != this.subject) {
            Subject.doAs(this.subject, new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    HttpServer.this.internalStart();
                    return null;
                }
            });
        } else {
            this.internalStart();
        }
    }

    protected void internalStart() {
        if (this.server != null) {
            throw new RuntimeException("Server is already started");
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(true);
        this.server = new Server((ThreadPool)threadPool);
        this.server.manage((Object)threadPool);
        ServerConnector serverConnector = null;
        HandlerList handlerList = null;
        if (null != this.config && AuthenticationType.CUSTOM == this.config.getAuthenticationType()) {
            if (null != this.handler || null != this.sslFactory) {
                throw new IllegalStateException("Handlers and SSLFactory cannot be configured with the HTTPServer Builder when using CUSTOM Authentication Type.");
            }
        } else {
            serverConnector = this.configureServerConnector();
            handlerList = this.configureHandlers();
        }
        for (ServerCustomizer<Server> customizer : this.serverCustomizers) {
            LOG.info("Customizing server with customizer: " + customizer.getClass());
            customizer.customize(this.server);
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (null != serverConnector && null != handlerList) {
            this.port = serverConnector.getLocalPort();
            LOG.info("Service listening on port {}.", (Object)this.getPort());
            try {
                this.handler.setServerRpcMetadata(this.createRpcServerMetadata(serverConnector));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        } else if (0 == this.server.getConnectors().length) {
            String error = "No server connectors have been configured for this Avatica server";
            LOG.error(error);
            throw new RuntimeException(error);
        }
    }

    private ServerConnector configureServerConnector() {
        ServerConnector connector = this.getServerConnector();
        connector.setIdleTimeout(60000L);
        connector.setSoLingerTime(-1);
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        return connector;
    }

    private HandlerList configureHandlers() {
        HandlerList handlerList = new HandlerList();
        AvaticaHandler avaticaHandler = this.handler;
        if (null != this.config) {
            ConstraintSecurityHandler securityHandler = this.getSecurityHandler();
            securityHandler.setHandler((Handler)this.handler);
            avaticaHandler = securityHandler;
        }
        handlerList.setHandlers(new Handler[]{avaticaHandler, new DefaultHandler()});
        this.server.setHandler((Handler)handlerList);
        return handlerList;
    }

    private ConstraintSecurityHandler getSecurityHandler() {
        ConstraintSecurityHandler securityHandler = null;
        switch (this.config.getAuthenticationType()) {
            case SPNEGO: {
                securityHandler = this.configureSpnego(this.server, this.config);
                break;
            }
            case BASIC: {
                securityHandler = this.configureBasicAuthentication(this.server, this.config);
                break;
            }
            case DIGEST: {
                securityHandler = this.configureDigestAuthentication(this.server, this.config);
                break;
            }
        }
        return securityHandler;
    }

    protected ServerConnector getServerConnector() {
        HttpConnectionFactory factory = new HttpConnectionFactory();
        factory.getHttpConfiguration().setRequestHeaderSize(this.maxAllowedHeaderSize);
        if (null == this.sslFactory) {
            return new ServerConnector(this.server, new ConnectionFactory[]{factory});
        }
        return new ServerConnector(this.server, AbstractConnectionFactory.getFactories((SslContextFactory)this.sslFactory, (ConnectionFactory[])new ConnectionFactory[]{factory}));
    }

    private Service.RpcMetadataResponse createRpcServerMetadata(ServerConnector connector) throws UnknownHostException {
        String host = connector.getHost();
        if (null == host) {
            host = InetAddress.getLocalHost().getHostName();
        }
        int port = connector.getLocalPort();
        return new Service.RpcMetadataResponse(String.format(Locale.ROOT, "%s:%d", host, port));
    }

    protected ConstraintSecurityHandler configureSpnego(Server server, AvaticaServerConfiguration config) {
        String realm = Objects.requireNonNull(config.getKerberosRealm());
        String principal = Objects.requireNonNull(config.getKerberosPrincipal());
        PropertyBasedSpnegoLoginService spnegoLoginService = new PropertyBasedSpnegoLoginService(realm, principal);
        String[] allowedRealms = this.getAllowedRealms(realm, config);
        return this.configureCommonAuthentication("SPNEGO", allowedRealms, (Authenticator)new AvaticaSpnegoAuthenticator(), realm, (LoginService)spnegoLoginService);
    }

    protected String[] getAllowedRealms(String serverRealm, AvaticaServerConfiguration config) {
        String[] allowedRealms = new String[]{serverRealm};
        if (null != config.getAllowedRoles()) {
            allowedRealms = new String[config.getAllowedRoles().length + 1];
            allowedRealms[0] = serverRealm;
            System.arraycopy(config.getAllowedRoles(), 0, allowedRealms, 1, config.getAllowedRoles().length);
        }
        return allowedRealms;
    }

    protected ConstraintSecurityHandler configureBasicAuthentication(Server server, AvaticaServerConfiguration config) {
        String[] allowedRoles = config.getAllowedRoles();
        String realm = config.getHashLoginServiceRealm();
        String loginServiceProperties = config.getHashLoginServiceProperties();
        HashLoginService loginService = new HashLoginService(realm, loginServiceProperties);
        server.addBean((Object)loginService);
        return this.configureCommonAuthentication("BASIC", allowedRoles, (Authenticator)new BasicAuthenticator(), null, (LoginService)loginService);
    }

    protected ConstraintSecurityHandler configureDigestAuthentication(Server server, AvaticaServerConfiguration config) {
        String[] allowedRoles = config.getAllowedRoles();
        String realm = config.getHashLoginServiceRealm();
        String loginServiceProperties = config.getHashLoginServiceProperties();
        HashLoginService loginService = new HashLoginService(realm, loginServiceProperties);
        server.addBean((Object)loginService);
        return this.configureCommonAuthentication("DIGEST", allowedRoles, (Authenticator)new DigestAuthenticator(), null, (LoginService)loginService);
    }

    protected ConstraintSecurityHandler configureCommonAuthentication(String constraintName, String[] allowedRoles, Authenticator authenticator, String realm, LoginService loginService) {
        Constraint constraint = new Constraint();
        constraint.setName(constraintName);
        constraint.setRoles(allowedRoles);
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
        sh.setAuthenticator(authenticator);
        sh.setLoginService(loginService);
        sh.setConstraintMappings(new ConstraintMapping[]{cm});
        sh.setRealmName(realm);
        return sh;
    }

    protected ServerConnector configureConnector(ServerConnector connector, int port) {
        connector.setIdleTimeout(60000L);
        connector.setSoLingerTime(-1);
        connector.setPort(port);
        return connector;
    }

    protected AvaticaServerConfiguration getConfig() {
        return this.config;
    }

    public void stop() {
        if (this.server == null) {
            throw new RuntimeException("Server is already stopped");
        }
        LOG.info("Service terminating.");
        try {
            Server server1 = this.server;
            this.port = -1;
            this.server = null;
            server1.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public int getPort() {
        return this.port;
    }

    public static class Builder<T> {
        private int port;
        private Service service;
        private Driver.Serialization serialization;
        private AvaticaHandler handler = null;
        private MetricsSystemConfiguration<?> metricsConfig;
        private AuthenticationType authenticationType = AuthenticationType.NONE;
        private String kerberosPrincipal;
        private String kerberosRealm;
        private File keytab;
        private DoAsRemoteUserCallback remoteUserCallback;
        private RemoteUserExtractor remoteUserExtractor = new HttpRequestRemoteUserExtractor();
        private String loginServiceRealm;
        private String loginServiceProperties;
        private String[] loginServiceAllowedRoles;
        private boolean usingTLS = false;
        private File keystore;
        private String keystorePassword;
        private File truststore;
        private String truststorePassword;
        private List<ServerCustomizer<T>> serverCustomizers = Collections.emptyList();
        private int maxAllowedHeaderSize = 65536;
        private AvaticaServerConfiguration serverConfig;
        private Subject subject;

        public static <T> Builder<T> newBuilder() {
            return new Builder<T>();
        }

        public Builder<T> withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> withHandler(Service service, Driver.Serialization serialization) {
            this.service = Objects.requireNonNull(service);
            this.serialization = Objects.requireNonNull(serialization);
            return this;
        }

        public Builder<T> withHandler(AvaticaHandler handler) {
            this.handler = Objects.requireNonNull(handler);
            return this;
        }

        public Builder<T> withMetricsConfiguration(MetricsSystemConfiguration<?> metricsConfig) {
            this.metricsConfig = Objects.requireNonNull(metricsConfig);
            return this;
        }

        public Builder<T> withSpnego(String principal) {
            return this.withSpnego(principal, (String[])null);
        }

        public Builder<T> withSpnego(String principal, String[] additionalAllowedRealms) {
            int index = Objects.requireNonNull(principal).lastIndexOf(64);
            if (-1 == index) {
                throw new IllegalArgumentException("Could not find '@' symbol in '" + principal + "' to parse the Kerberos realm from the principal");
            }
            String realm = principal.substring(index + 1);
            return this.withSpnego(principal, realm, additionalAllowedRealms);
        }

        public Builder<T> withSpnego(String principal, String realm) {
            return this.withSpnego(principal, realm, null);
        }

        public Builder<T> withSpnego(String principal, String realm, String[] additionalAllowedRealms) {
            this.authenticationType = AuthenticationType.SPNEGO;
            this.kerberosPrincipal = Objects.requireNonNull(principal);
            this.kerberosRealm = Objects.requireNonNull(realm);
            this.loginServiceAllowedRoles = additionalAllowedRealms;
            return this;
        }

        public Builder<T> withAutomaticLogin(File keytab) {
            this.keytab = Objects.requireNonNull(keytab);
            return this;
        }

        public Builder<T> withImpersonation(DoAsRemoteUserCallback remoteUserCallback) {
            this.remoteUserCallback = Objects.requireNonNull(remoteUserCallback);
            return this;
        }

        public Builder withRemoteUserExtractor(RemoteUserExtractor remoteUserExtractor) {
            this.remoteUserExtractor = Objects.requireNonNull(remoteUserExtractor);
            return this;
        }

        public Builder<T> withBasicAuthentication(String properties, String[] allowedRoles) {
            return this.withAuthentication(AuthenticationType.BASIC, properties, allowedRoles);
        }

        public Builder<T> withDigestAuthentication(String properties, String[] allowedRoles) {
            return this.withAuthentication(AuthenticationType.DIGEST, properties, allowedRoles);
        }

        public Builder<T> withCustomAuthentication(AvaticaServerConfiguration config) {
            this.authenticationType = AuthenticationType.CUSTOM;
            this.serverConfig = config;
            return this;
        }

        private Builder<T> withAuthentication(AuthenticationType authType, String properties, String[] allowedRoles) {
            this.loginServiceRealm = "Avatica";
            this.authenticationType = authType;
            this.loginServiceProperties = Objects.requireNonNull(properties);
            this.loginServiceAllowedRoles = Objects.requireNonNull(allowedRoles);
            return this;
        }

        public Builder<T> withTLS(File keystore, String keystorePassword, File truststore, String truststorePassword) {
            this.usingTLS = true;
            this.keystore = Objects.requireNonNull(keystore);
            this.keystorePassword = Objects.requireNonNull(keystorePassword);
            this.truststore = Objects.requireNonNull(truststore);
            this.truststorePassword = Objects.requireNonNull(truststorePassword);
            return this;
        }

        public Builder<T> withServerCustomizers(List<ServerCustomizer<T>> serverCustomizers, Class<T> clazz) {
            Objects.requireNonNull(clazz);
            if (!clazz.isAssignableFrom(Server.class)) {
                throw new IllegalArgumentException("Only Jetty Server customizers are supported");
            }
            this.serverCustomizers = Objects.requireNonNull(serverCustomizers);
            return this;
        }

        public Builder<T> withMaxHeaderSize(int maxHeaderSize) {
            this.maxAllowedHeaderSize = maxHeaderSize;
            return this;
        }

        public HttpServer build() {
            switch (this.authenticationType) {
                case NONE: {
                    this.serverConfig = null;
                    this.subject = null;
                    this.handler = this.buildHandler(this, this.serverConfig);
                    break;
                }
                case BASIC: 
                case DIGEST: {
                    this.serverConfig = this.buildUserAuthenticationConfiguration(this);
                    this.subject = null;
                    this.handler = this.buildHandler(this, this.serverConfig);
                    break;
                }
                case SPNEGO: {
                    if (this.usingTLS) {
                        throw new IllegalArgumentException("TLS has not been tested wtih SPNEGO");
                    }
                    if (null != this.keytab) {
                        LOG.debug("Performing Kerberos login with {} as {}", (Object)this.keytab, (Object)this.kerberosPrincipal);
                        this.subject = this.loginViaKerberos(this);
                    } else {
                        LOG.debug("Not performing Kerberos login");
                        this.subject = null;
                    }
                    this.serverConfig = this.buildSpnegoConfiguration(this);
                    this.handler = this.buildHandler(this, this.serverConfig);
                    break;
                }
                case CUSTOM: {
                    this.serverConfig = this.buildCustomConfiguration(this);
                    this.subject = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled AuthenticationType");
                }
            }
            SslContextFactory sslFactory = this.buildSSLContextFactory();
            ArrayList<ServerCustomizer<T>> jettyCustomizers = new ArrayList<ServerCustomizer<T>>();
            for (ServerCustomizer<T> customizer : this.serverCustomizers) {
                jettyCustomizers.add(customizer);
            }
            return new HttpServer(this.port, this.handler, this.serverConfig, this.subject, sslFactory, jettyCustomizers, this.maxAllowedHeaderSize);
        }

        protected SslContextFactory buildSSLContextFactory() {
            SslContextFactory sslFactory = null;
            if (this.usingTLS) {
                sslFactory = new SslContextFactory();
                sslFactory.setKeyStorePath(this.keystore.getAbsolutePath());
                sslFactory.setKeyStorePassword(this.keystorePassword);
                sslFactory.setTrustStorePath(this.truststore.getAbsolutePath());
                sslFactory.setTrustStorePassword(this.truststorePassword);
            }
            return sslFactory;
        }

        private AvaticaServerConfiguration buildCustomConfiguration(Builder<T> tBuilder) {
            return tBuilder.serverConfig;
        }

        private AvaticaHandler buildHandler(Builder b, AvaticaServerConfiguration config) {
            if (null != b.handler) {
                return b.handler;
            }
            HandlerFactory factory = new HandlerFactory();
            return factory.getHandler(b.service, b.serialization, b.metricsConfig, config);
        }

        private AvaticaServerConfiguration buildSpnegoConfiguration(Builder b) {
            final String principal = b.kerberosPrincipal;
            final String realm = b.kerberosRealm;
            final String[] additionalAllowedRealms = b.loginServiceAllowedRoles;
            final DoAsRemoteUserCallback callback = b.remoteUserCallback;
            final RemoteUserExtractor remoteUserExtractor = b.remoteUserExtractor;
            return new AvaticaServerConfiguration(){

                @Override
                public AuthenticationType getAuthenticationType() {
                    return AuthenticationType.SPNEGO;
                }

                @Override
                public String getKerberosRealm() {
                    return realm;
                }

                @Override
                public String getKerberosPrincipal() {
                    return principal;
                }

                @Override
                public boolean supportsImpersonation() {
                    return null != callback;
                }

                @Override
                public <T> T doAsRemoteUser(String remoteUserName, String remoteAddress, Callable<T> action) throws Exception {
                    return callback.doAsRemoteUser(remoteUserName, remoteAddress, action);
                }

                @Override
                public RemoteUserExtractor getRemoteUserExtractor() {
                    return remoteUserExtractor;
                }

                @Override
                public String[] getAllowedRoles() {
                    return additionalAllowedRealms;
                }

                @Override
                public String getHashLoginServiceRealm() {
                    return null;
                }

                @Override
                public String getHashLoginServiceProperties() {
                    return null;
                }
            };
        }

        private AvaticaServerConfiguration buildUserAuthenticationConfiguration(Builder b) {
            final AuthenticationType authType = b.authenticationType;
            final String[] allowedRoles = b.loginServiceAllowedRoles;
            final String realm = b.loginServiceRealm;
            final String properties = b.loginServiceProperties;
            final RemoteUserExtractor remoteUserExtractor = b.remoteUserExtractor;
            return new AvaticaServerConfiguration(){

                @Override
                public AuthenticationType getAuthenticationType() {
                    return authType;
                }

                @Override
                public String[] getAllowedRoles() {
                    return allowedRoles;
                }

                @Override
                public String getHashLoginServiceRealm() {
                    return realm;
                }

                @Override
                public String getHashLoginServiceProperties() {
                    return properties;
                }

                @Override
                public String getKerberosRealm() {
                    return null;
                }

                @Override
                public String getKerberosPrincipal() {
                    return null;
                }

                @Override
                public boolean supportsImpersonation() {
                    return false;
                }

                @Override
                public <T> T doAsRemoteUser(String remoteUserName, String remoteAddress, Callable<T> action) throws Exception {
                    return null;
                }

                @Override
                public RemoteUserExtractor getRemoteUserExtractor() {
                    return remoteUserExtractor;
                }
            };
        }

        private Subject loginViaKerberos(Builder b) {
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(b.kerberosPrincipal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            ServerKeytabJaasConf conf = new ServerKeytabJaasConf(b.kerberosPrincipal, b.keytab.toString());
            String confName = "NotUsed";
            try {
                LoginContext loginContext = new LoginContext(confName, subject, null, conf);
                loginContext.login();
                return loginContext.getSubject();
            }
            catch (LoginException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

