/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.calcite.linq4j.tree.AbstractNode;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Types;

class ExpressionWriter {
    static final Indent INDENT = new Indent(20);
    private final StringBuilder buf = new StringBuilder();
    private int level;
    private String indent = "";
    private boolean indentPending;
    private final boolean generics;

    public ExpressionWriter() {
        this(true);
    }

    public ExpressionWriter(boolean generics) {
        this.generics = generics;
    }

    public void write(Node expression) {
        if (expression instanceof Expression) {
            Expression expression1 = (Expression)expression;
            expression1.accept(this, 0, 0);
        } else {
            expression.accept(this);
        }
    }

    public String toString() {
        return this.buf.toString();
    }

    public boolean requireParentheses(Expression expression, int lprec, int rprec) {
        if (lprec < expression.nodeType.lprec && expression.nodeType.rprec >= rprec) {
            return false;
        }
        this.buf.append("(");
        expression.accept(this, 0, 0);
        this.buf.append(")");
        return true;
    }

    public void begin() {
        this.indent = (String)INDENT.get(++this.level);
    }

    public void end() {
        this.indent = (String)INDENT.get(--this.level);
    }

    public ExpressionWriter newlineAndIndent() {
        this.buf.append("\n");
        this.indentPending = true;
        return this;
    }

    public ExpressionWriter indent() {
        this.buf.append(this.indent);
        return this;
    }

    public ExpressionWriter begin(String s) {
        this.append(s);
        this.begin();
        this.indentPending = s.endsWith("\n");
        return this;
    }

    public ExpressionWriter end(String s) {
        this.end();
        this.append(s);
        this.indentPending = s.endsWith("\n");
        return this;
    }

    public ExpressionWriter append(char c) {
        this.checkIndent();
        this.buf.append(c);
        return this;
    }

    public ExpressionWriter append(Type type) {
        this.checkIndent();
        if (!this.generics) {
            type = Types.stripGenerics(type);
        }
        this.buf.append(Types.className(type));
        return this;
    }

    public ExpressionWriter append(AbstractNode o) {
        o.accept0(this);
        return this;
    }

    public ExpressionWriter append(Object o) {
        this.checkIndent();
        this.buf.append(o);
        return this;
    }

    public ExpressionWriter append(String s) {
        this.checkIndent();
        this.buf.append(s);
        return this;
    }

    private void checkIndent() {
        if (this.indentPending) {
            this.buf.append(this.indent);
            this.indentPending = false;
        }
    }

    public StringBuilder getBuf() {
        this.checkIndent();
        return this.buf;
    }

    public ExpressionWriter list(String begin, String sep, String end, Iterable<?> list) {
        Iterator<?> iterator = list.iterator();
        if (iterator.hasNext()) {
            this.begin(begin);
            while (true) {
                Object o;
                if ((o = iterator.next()) instanceof Expression) {
                    ((Expression)o).accept(this, 0, 0);
                } else if (o instanceof MemberDeclaration) {
                    ((MemberDeclaration)o).accept(this);
                } else if (o instanceof Type) {
                    this.append((Type)o);
                } else {
                    this.append(o);
                }
                if (!iterator.hasNext()) break;
                this.buf.append(sep);
                if (!sep.endsWith("\n")) continue;
                this.indentPending = true;
            }
            this.end(end);
        } else {
            while (begin.endsWith("\n")) {
                begin = begin.substring(0, begin.length() - 1);
            }
            this.buf.append(begin).append(end);
        }
        return this;
    }

    public void backUp() {
        if (this.buf.lastIndexOf("\n") == this.buf.length() - 1) {
            this.buf.delete(this.buf.length() - 1, this.buf.length());
            this.indentPending = false;
        }
    }

    private static class Indent
    extends ArrayList<String> {
        public Indent(int initialCapacity) {
            super(initialCapacity);
            this.ensureSize(initialCapacity);
        }

        public synchronized String of(int index) {
            this.ensureSize(index + 1);
            return (String)this.get(index);
        }

        private void ensureSize(int targetSize) {
            if (targetSize < this.size()) {
                return;
            }
            char[] chars = new char[2 * targetSize];
            Arrays.fill(chars, ' ');
            String bigString = new String(chars);
            this.clear();
            for (int i = 0; i < targetSize; ++i) {
                this.add(bigString.substring(0, i * 2));
            }
        }
    }
}

