/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Visitor;

public class ThrowStatement
extends Statement {
    public final Expression expression;

    public ThrowStatement(Expression expression) {
        super(ExpressionType.Throw, Void.TYPE);
        this.expression = expression;
    }

    @Override
    public Statement accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        Expression expression = this.expression.accept(visitor);
        return visitor.visit(this, expression);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("throw ").append(this.expression).append(';').newlineAndIndent();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThrowStatement that = (ThrowStatement)o;
        return !(this.expression != null ? !this.expression.equals(that.expression) : that.expression != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        return result;
    }
}

