/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.buffer.ByteBuf;
import org.apache.drill.common.concurrent.AbstractCheckedFuture;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.AbstractFuture;

class DrillRpcFutureImpl<V>
extends AbstractCheckedFuture<V, RpcException>
implements DrillRpcFuture<V>,
RpcOutcomeListener<V> {
    private volatile ByteBuf buffer;

    public DrillRpcFutureImpl() {
        super(new InnerFuture());
    }

    protected RpcException mapException(Exception ex) {
        return RpcException.mapException(ex);
    }

    @Override
    public void failed(RpcException ex) {
        ((InnerFuture)this.delegate()).setException((Throwable)((Object)ex));
    }

    @Override
    public void success(V value, ByteBuf buffer) {
        this.buffer = buffer;
        ((InnerFuture)this.delegate()).setValue(value);
    }

    @Override
    public void interrupted(InterruptedException ex) {
        this.delegate().cancel(true);
    }

    @Override
    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public void release() {
        if (this.buffer != null) {
            this.buffer.release();
        }
    }

    private static class InnerFuture<T>
    extends AbstractFuture<T> {
        private InnerFuture() {
        }

        void setValue(T value) {
            super.set(value);
        }

        protected boolean setException(Throwable t) {
            return super.setException(t);
        }
    }
}

