/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.multiple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;

public class MultipleServiceDiscovery
implements ServiceDiscovery {
    public static final String REGISTRY_PREFIX_KEY = "child.";
    private static final String REGISTRY_TYPE = "registry-type";
    private static final String SERVICE = "service";
    private final Map<String, ServiceDiscovery> serviceDiscoveries = new ConcurrentHashMap<String, ServiceDiscovery>();
    private URL registryURL;
    private String applicationName;
    private volatile boolean isDestroy;

    public MultipleServiceDiscovery(URL registryURL) {
        this.registryURL = registryURL;
        this.applicationName = registryURL.getApplication();
        Map parameters = registryURL.getParameters();
        for (String key : parameters.keySet()) {
            if (!key.startsWith(REGISTRY_PREFIX_KEY)) continue;
            URL url = URL.valueOf((String)registryURL.getParameter(key)).addParameter("application", this.applicationName).addParameter(REGISTRY_TYPE, SERVICE);
            ServiceDiscovery serviceDiscovery = ServiceDiscoveryFactory.getExtension((URL)url).getServiceDiscovery(url);
            this.serviceDiscoveries.put(key, serviceDiscovery);
        }
    }

    public URL getUrl() {
        return this.registryURL;
    }

    public void destroy() throws Exception {
        this.isDestroy = true;
        for (ServiceDiscovery serviceDiscovery : this.serviceDiscoveries.values()) {
            serviceDiscovery.destroy();
        }
    }

    public boolean isDestroy() {
        return this.isDestroy;
    }

    public void register() throws RuntimeException {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.register());
    }

    public void update() throws RuntimeException {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.update());
    }

    public void unregister() throws RuntimeException {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.unregister());
    }

    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        MultiServiceInstancesChangedListener multiListener = (MultiServiceInstancesChangedListener)listener;
        for (String registryKey : this.serviceDiscoveries.keySet()) {
            ServiceDiscovery serviceDiscovery = this.serviceDiscoveries.get(registryKey);
            SingleServiceInstancesChangedListener singleListener = multiListener.getAndComputeIfAbsent(registryKey, k -> new SingleServiceInstancesChangedListener(listener.getServiceNames(), serviceDiscovery, multiListener));
            serviceDiscovery.addServiceInstancesChangedListener((ServiceInstancesChangedListener)singleListener);
        }
    }

    public ServiceInstancesChangedListener createListener(Set<String> serviceNames) {
        return new MultiServiceInstancesChangedListener(serviceNames, this);
    }

    public List<ServiceInstance> getInstances(String serviceName) {
        ArrayList<ServiceInstance> serviceInstanceList = new ArrayList<ServiceInstance>();
        for (ServiceDiscovery serviceDiscovery : this.serviceDiscoveries.values()) {
            serviceInstanceList.addAll(serviceDiscovery.getInstances(serviceName));
        }
        return serviceInstanceList;
    }

    public Set<String> getServices() {
        HashSet<String> services = new HashSet<String>();
        for (ServiceDiscovery serviceDiscovery : this.serviceDiscoveries.values()) {
            services.addAll(serviceDiscovery.getServices());
        }
        return services;
    }

    public ServiceInstance getLocalInstance() {
        return null;
    }

    public MetadataInfo getLocalMetadata() {
        throw new UnsupportedOperationException("Multiple registry implementation does not support getMetadata() method.");
    }

    public MetadataInfo getRemoteMetadata(String revision) {
        throw new UnsupportedOperationException("Multiple registry implementation does not support getMetadata() method.");
    }

    public MetadataInfo getRemoteMetadata(String revision, ServiceInstance instance) {
        throw new UnsupportedOperationException("Multiple registry implementation does not support getMetadata() method.");
    }

    public void register(URL url) {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.register(url));
    }

    public void unregister(URL url) {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.unregister(url));
    }

    public void subscribe(URL url, NotifyListener listener) {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.subscribe(url, listener));
    }

    public void unsubscribe(URL url, NotifyListener listener) {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.unsubscribe(url, listener));
    }

    public List<URL> lookup(URL url) {
        throw new UnsupportedOperationException("Multiple registry implementation does not support lookup() method.");
    }

    protected static class SingleServiceInstancesChangedListener
    extends ServiceInstancesChangedListener {
        private final MultiServiceInstancesChangedListener multiListener;
        volatile ServiceInstancesChangedEvent event;

        public SingleServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery, MultiServiceInstancesChangedListener multiListener) {
            super(serviceNames, serviceDiscovery);
            this.multiListener = multiListener;
        }

        public void onEvent(ServiceInstancesChangedEvent event) {
            this.event = event;
            if (this.multiListener != null) {
                this.multiListener.onEvent(event);
            }
        }
    }

    protected static class MultiServiceInstancesChangedListener
    extends ServiceInstancesChangedListener {
        private final Map<String, SingleServiceInstancesChangedListener> singleListenerMap = new ConcurrentHashMap<String, SingleServiceInstancesChangedListener>();

        public MultiServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery) {
            super(serviceNames, serviceDiscovery);
        }

        public void onEvent(ServiceInstancesChangedEvent event) {
            ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
            for (SingleServiceInstancesChangedListener singleListener : this.singleListenerMap.values()) {
                if (null == singleListener.event || null == singleListener.event.getServiceInstances()) continue;
                for (ServiceInstance serviceInstance : singleListener.event.getServiceInstances()) {
                    if (serviceInstances.contains(serviceInstance)) continue;
                    serviceInstances.add(serviceInstance);
                }
            }
            super.onEvent(new ServiceInstancesChangedEvent(event.getServiceName(), serviceInstances));
        }

        public void putSingleListener(String registryKey, SingleServiceInstancesChangedListener singleListener) {
            this.singleListenerMap.put(registryKey, singleListener);
        }

        public SingleServiceInstancesChangedListener getAndComputeIfAbsent(String registryKey, Function<String, SingleServiceInstancesChangedListener> func) {
            return this.singleListenerMap.computeIfAbsent(registryKey, func);
        }
    }
}

