/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.kite.parser;

import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flume.Context;
import org.apache.flume.sink.kite.DatasetSinkConstants;
import org.apache.flume.sink.kite.parser.AvroParser;
import org.apache.flume.sink.kite.parser.EntityParser;

public class EntityParserFactory {
    public EntityParser<GenericRecord> newParser(Schema datasetSchema, Context config) {
        EntityParser<Object> parser;
        String parserType = config.getString("kite.entityParser", "avro");
        if (parserType.equals("avro")) {
            parser = new AvroParser.Builder().build(datasetSchema, config);
        } else {
            EntityParser.Builder builder;
            Class<?> c;
            try {
                c = Class.forName(parserType);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("EntityParser.Builder class " + parserType + " not found. Must set " + "kite.entityParser" + " to a class that implements EntityParser.Builder or to a builtin" + " parser: " + Arrays.toString(DatasetSinkConstants.AVAILABLE_PARSERS), ex);
            }
            if (c == null || !EntityParser.Builder.class.isAssignableFrom(c)) {
                throw new IllegalArgumentException("Class " + parserType + " does not" + " implement EntityParser.Builder. Must set " + "kite.entityParser" + " to a class that extends" + " EntityParser.Builder or to a builtin parser: " + Arrays.toString(DatasetSinkConstants.AVAILABLE_PARSERS));
            }
            Class<?> builderClass = c;
            try {
                builder = (EntityParser.Builder)builderClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException("Can't instantiate class " + parserType + ". Must set " + "kite.entityParser" + " to a class" + " that extends EntityParser.Builder or to a builtin parser: " + Arrays.toString(DatasetSinkConstants.AVAILABLE_PARSERS), ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Can't instantiate class " + parserType + ". Must set " + "kite.entityParser" + " to a class" + " that extends EntityParser.Builder or to a builtin parser: " + Arrays.toString(DatasetSinkConstants.AVAILABLE_PARSERS), ex);
            }
            parser = builder.build(datasetSchema, config);
        }
        return parser;
    }
}

