/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class KeyOnlyFilter
extends FilterBase {
    boolean lenAsVal;

    public KeyOnlyFilter() {
        this(false);
    }

    public KeyOnlyFilter(boolean lenAsVal) {
        this.lenAsVal = lenAsVal;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    public Cell transformCell(Cell cell) {
        return this.createKeyOnlyCell(cell);
    }

    private Cell createKeyOnlyCell(Cell c) {
        if (c instanceof ByteBufferExtendedCell) {
            return new KeyOnlyByteBufferExtendedCell((ByteBufferExtendedCell)c, this.lenAsVal);
        }
        return new KeyOnlyCell(c, this.lenAsVal);
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return this.filterCell(ignored);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.isEmpty() || filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected: 0 or 1 but got: %s", (int)filterArguments.size());
        KeyOnlyFilter filter = new KeyOnlyFilter();
        if (filterArguments.size() == 1) {
            filter.lenAsVal = ParseFilter.convertByteArrayToBoolean(filterArguments.get(0));
        }
        return filter;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.KeyOnlyFilter.Builder builder = FilterProtos.KeyOnlyFilter.newBuilder();
        builder.setLenAsVal(this.lenAsVal);
        return builder.build().toByteArray();
    }

    public static KeyOnlyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.KeyOnlyFilter proto;
        try {
            proto = FilterProtos.KeyOnlyFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return new KeyOnlyFilter(proto.getLenAsVal());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyOnlyFilter)) {
            return false;
        }
        KeyOnlyFilter other = (KeyOnlyFilter)o;
        return this.lenAsVal == other.lenAsVal;
    }

    static class KeyOnlyByteBufferExtendedCell
    extends ByteBufferExtendedCell {
        public static final int FIXED_OVERHEAD = ClassSize.OBJECT + ClassSize.REFERENCE + 1;
        private ByteBufferExtendedCell cell;
        private boolean lenAsVal;

        public KeyOnlyByteBufferExtendedCell(ByteBufferExtendedCell c, boolean lenAsVal) {
            this.cell = c;
            this.lenAsVal = lenAsVal;
        }

        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        public short getRowLength() {
            return this.cell.getRowLength();
        }

        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        public void setSequenceId(long seqId) throws IOException {
            this.cell.setSequenceId(seqId);
        }

        public void setTimestamp(long ts) throws IOException {
            this.cell.setTimestamp(ts);
        }

        public void setTimestamp(byte[] ts) throws IOException {
            this.cell.setTimestamp(ts);
        }

        public long getSequenceId() {
            return 0L;
        }

        public Cell.Type getType() {
            return this.cell.getType();
        }

        public byte[] getValueArray() {
            if (this.lenAsVal) {
                return Bytes.toBytes((int)this.cell.getValueLength());
            }
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        public int getValueOffset() {
            return 0;
        }

        public int getValueLength() {
            if (this.lenAsVal) {
                return 4;
            }
            return 0;
        }

        public byte[] getTagsArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        public int getTagsOffset() {
            return 0;
        }

        public int getTagsLength() {
            return 0;
        }

        public ByteBuffer getRowByteBuffer() {
            return this.cell.getRowByteBuffer();
        }

        public int getRowPosition() {
            return this.cell.getRowPosition();
        }

        public ByteBuffer getFamilyByteBuffer() {
            return this.cell.getFamilyByteBuffer();
        }

        public int getFamilyPosition() {
            return this.cell.getFamilyPosition();
        }

        public ByteBuffer getQualifierByteBuffer() {
            return this.cell.getQualifierByteBuffer();
        }

        public int getQualifierPosition() {
            return this.cell.getQualifierPosition();
        }

        public ByteBuffer getValueByteBuffer() {
            if (this.lenAsVal) {
                return ByteBuffer.wrap(Bytes.toBytes((int)this.cell.getValueLength()));
            }
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        public int getValuePosition() {
            return 0;
        }

        public ByteBuffer getTagsByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        public int getTagsPosition() {
            return 0;
        }

        public Iterator<Tag> getTags() {
            return Collections.emptyIterator();
        }

        public Optional<Tag> getTag(byte type) {
            return Optional.empty();
        }

        public long heapSize() {
            return ClassSize.align((long)((long)FIXED_OVERHEAD + this.cell.heapSize()));
        }
    }

    static class KeyOnlyCell
    implements Cell {
        private Cell cell;
        private boolean lenAsVal;

        public KeyOnlyCell(Cell c, boolean lenAsVal) {
            this.cell = c;
            this.lenAsVal = lenAsVal;
        }

        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        public short getRowLength() {
            return this.cell.getRowLength();
        }

        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        public Cell.Type getType() {
            return this.cell.getType();
        }

        public long getSequenceId() {
            return 0L;
        }

        public byte[] getValueArray() {
            if (this.lenAsVal) {
                return Bytes.toBytes((int)this.cell.getValueLength());
            }
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        public int getValueOffset() {
            return 0;
        }

        public int getValueLength() {
            if (this.lenAsVal) {
                return 4;
            }
            return 0;
        }

        public byte[] getTagsArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        public int getTagsOffset() {
            return 0;
        }

        public int getTagsLength() {
            return 0;
        }
    }
}

