/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Counter;
import org.apache.hadoop.hbase.util.FastLongHistogram;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableMetric;

@InterfaceAudience.Private
public class MutableHistogram
extends MutableMetric
implements MetricHistogram {
    protected final FastLongHistogram histogram;
    protected final String name;
    protected final String desc;
    protected final Counter counter = new Counter(0L);

    public MutableHistogram(MetricsInfo info) {
        this(info.name(), info.description());
    }

    public MutableHistogram(String name, String description) {
        this(name, description, -4L);
    }

    protected MutableHistogram(String name, String description, long maxExpected) {
        this.name = StringUtils.capitalize((String)name);
        this.desc = StringUtils.uncapitalize((String)description);
        this.histogram = new FastLongHistogram(255, 1L, maxExpected);
    }

    public void add(long val) {
        this.counter.increment();
        this.histogram.add(val, 1L);
    }

    public synchronized void snapshot(MetricsRecordBuilder metricsRecordBuilder, boolean all) {
        FastLongHistogram histo = this.histogram.reset();
        if (histo != null) {
            this.updateSnapshotMetrics(metricsRecordBuilder, histo);
        }
    }

    protected void updateSnapshotMetrics(MetricsRecordBuilder metricsRecordBuilder, FastLongHistogram histo) {
        metricsRecordBuilder.addCounter(Interns.info((String)(this.name + "_num_ops"), (String)this.desc), this.counter.get());
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_min"), (String)this.desc), histo.getMin());
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_max"), (String)this.desc), histo.getMax());
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_mean"), (String)this.desc), histo.getMean());
        long[] percentiles = histo.getQuantiles();
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_25th_percentile"), (String)this.desc), percentiles[0]);
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_median"), (String)this.desc), percentiles[1]);
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_75th_percentile"), (String)this.desc), percentiles[2]);
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_90th_percentile"), (String)this.desc), percentiles[3]);
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_95th_percentile"), (String)this.desc), percentiles[4]);
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_98th_percentile"), (String)this.desc), percentiles[5]);
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_99th_percentile"), (String)this.desc), percentiles[6]);
        metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_99.9th_percentile"), (String)this.desc), percentiles[7]);
    }
}

