/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.avalon;

import java.util.Arrays;
import org.apache.commons.cli.avalon.CLOptionDescriptor;

public final class CLOption {
    public static final int TEXT_ARGUMENT = 0;
    private static final CLOptionDescriptor TEXT_ARGUMENT_DESCRIPTOR = new CLOptionDescriptor(null, 4, 0, null);
    private String[] arguments;
    private CLOptionDescriptor descriptor = TEXT_ARGUMENT_DESCRIPTOR;

    public final String getArgument() {
        return this.getArgument(0);
    }

    public final String getArgument(int index) {
        if (null == this.arguments || index < 0 || index >= this.arguments.length) {
            return null;
        }
        return this.arguments[index];
    }

    public final CLOptionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public CLOption(CLOptionDescriptor descriptor) {
        if (descriptor != null) {
            this.descriptor = descriptor;
        }
    }

    public CLOption(String argument) {
        this((CLOptionDescriptor)null);
        this.addArgument(argument);
    }

    public final void addArgument(String argument) {
        if (null == this.arguments) {
            this.arguments = new String[]{argument};
        } else {
            String[] arguments = new String[this.arguments.length + 1];
            System.arraycopy(this.arguments, 0, arguments, 0, this.arguments.length);
            arguments[this.arguments.length] = argument;
            this.arguments = arguments;
        }
    }

    public final int getArgumentCount() {
        if (null == this.arguments) {
            return 0;
        }
        return this.arguments.length;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        char id = (char)this.descriptor.getId();
        if (id == '\u0000') {
            sb.append("TEXT ");
        } else {
            sb.append("Option ");
            sb.append(id);
        }
        if (null != this.arguments) {
            sb.append(", ");
            sb.append(Arrays.asList(this.arguments));
        }
        sb.append(" ]");
        return sb.toString();
    }

    final String toShortString() {
        StringBuilder sb = new StringBuilder();
        char id = (char)this.descriptor.getId();
        if (id != '\u0000') {
            sb.append("-");
            sb.append(id);
        }
        if (null != this.arguments) {
            if (id != '\u0000') {
                sb.append("=");
            }
            sb.append(Arrays.asList(this.arguments));
        }
        return sb.toString();
    }
}

