/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.api.IntegrationTestHarness;
import kafka.api.IntegrationTestHarness$class;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.MemberSummary;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001\u001d\u0011q\"\u00113nS:\u001cE.[3oiR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!\u0011b\u0003\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o\u001d\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\tQ!\u001e;jYNL!a\u0007\r\u0003\u000f1{wmZ5oO\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003'\u0001Aq!\t\u0001C\u0002\u0013\u0005!%A\u0007qe>$WoY3s\u0007>,h\u000e^\u000b\u0002GA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t\u0019\u0011J\u001c;\t\r)\u0002\u0001\u0015!\u0003$\u00039\u0001(o\u001c3vG\u0016\u00148i\\;oi\u0002Bq\u0001\f\u0001C\u0002\u0013\u0005!%A\u0007d_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0005\u0007]\u0001\u0001\u000b\u0011B\u0012\u0002\u001d\r|gn];nKJ\u001cu.\u001e8uA!9\u0001\u0007\u0001b\u0001\n\u0003\u0011\u0013aC:feZ,'oQ8v]RDaA\r\u0001!\u0002\u0013\u0019\u0013\u0001D:feZ,'oQ8v]R\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%\t!N\u0001\bOJ|W\u000f]%e+\u00051\u0004CA\u001c=\u001b\u0005A$BA\u001d;\u0003\u0011a\u0017M\\4\u000b\u0003m\nAA[1wC&\u0011Q\b\u000f\u0002\u0007'R\u0014\u0018N\\4\t\r}\u0002\u0001\u0015!\u00037\u0003!9'o\\;q\u0013\u0012\u0004\u0003bB!\u0001\u0005\u0004%\t!N\u0001\tG2LWM\u001c;JI\"11\t\u0001Q\u0001\nY\n\u0011b\u00197jK:$\u0018\n\u001a\u0011\t\u000f\u0015\u0003!\u0019!C\u0001k\u0005)Ao\u001c9jG\"1q\t\u0001Q\u0001\nY\na\u0001^8qS\u000e\u0004\u0003bB%\u0001\u0005\u0004%\tAI\u0001\u0005a\u0006\u0014H\u000f\u0003\u0004L\u0001\u0001\u0006IaI\u0001\u0006a\u0006\u0014H\u000f\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001O\u0003\t!\b/F\u0001P!\t\u0001f+D\u0001R\u0015\t\u00116+\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bQS!!\u0016\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t9\u0016K\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\re\u0003\u0001\u0015!\u0003P\u0003\r!\b\u000f\t\u0005\b7\u0002\u0011\r\u0011\"\u0001#\u0003\u0015\u0001\u0018M\u001d;3\u0011\u0019i\u0006\u0001)A\u0005G\u00051\u0001/\u0019:ue\u0001Bqa\u0018\u0001C\u0002\u0013\u0005a*A\u0002uaJBa!\u0019\u0001!\u0002\u0013y\u0015\u0001\u0002;qe\u0001Bqa\u0019\u0001A\u0002\u0013\u0005A-\u0001\u0004dY&,g\u000e^\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eB\u0001\u0006C\u0012l\u0017N\\\u0005\u0003U\u001e\u00141\"\u00113nS:\u001cE.[3oi\"9A\u000e\u0001a\u0001\n\u0003i\u0017AC2mS\u0016tGo\u0018\u0013fcR\u0011a.\u001d\t\u0003I=L!\u0001]\u0013\u0003\tUs\u0017\u000e\u001e\u0005\be.\f\t\u00111\u0001f\u0003\rAH%\r\u0005\u0007i\u0002\u0001\u000b\u0015B3\u0002\u000f\rd\u0017.\u001a8uA!)a\u000f\u0001C!o\u0006)1/\u001a;VaR\ta\u000e\u000b\u0002vsB\u0011!\u0010`\u0007\u0002w*\u00111BD\u0005\u0003{n\u0014aAQ3g_J,\u0007\"B@\u0001\t\u00039\u0018A\u0004;fgRd\u0015n\u001d;He>,\bo\u001d\u0015\u0004}\u0006\r\u0001c\u0001>\u0002\u0006%\u0019\u0011qA>\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003\u0017\u0001A\u0011A<\u0002#Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3He>,\b\u000f\u000b\u0003\u0002\n\u0005\r\u0001BBA\t\u0001\u0011\u0005q/A\ruKN$H)Z:de&\u0014WmQ8ogVlWM]$s_V\u0004\b\u0006BA\b\u0003\u0007Aa!a\u0006\u0001\t\u00039\u0018\u0001\f;fgR$Um]2sS\n,7i\u001c8tk6,'o\u0012:pkB4uN\u001d(p]\u0016C\u0018n\u001d;f]R<%o\\;qQ\u0011\t)\"a\u0001")
public class AdminClientTest
extends JUnitSuite
implements IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String groupId;
    private final String clientId;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int part2;
    private final TopicPartition tp2;
    private AdminClient client;
    private final Properties producerConfig;
    private final Properties consumerConfig;
    private final Properties serverConfig;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final Option<Function0<BoxedUnit>> setClusterAcl;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        AdminClientTest adminClientTest = this;
        synchronized (adminClientTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = IntegrationTestHarness$class.producerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    @Override
    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    private Properties consumerConfig$lzycompute() {
        AdminClientTest adminClientTest = this;
        synchronized (adminClientTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = IntegrationTestHarness$class.consumerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    @Override
    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    private Properties serverConfig$lzycompute() {
        AdminClientTest adminClientTest = this;
        synchronized (adminClientTest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = IntegrationTestHarness$class.serverConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    @Override
    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    @Override
    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    @Override
    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$consumers_$eq(Buffer x$1) {
        this.consumers = x$1;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$producers_$eq(Buffer x$1) {
        this.producers = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return IntegrationTestHarness$class.generateConfigs(this);
    }

    @Override
    @After
    public void tearDown() {
        IntegrationTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public Option<Function0<BoxedUnit>> setClusterAcl() {
        return this.setClusterAcl;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$setClusterAcl_$eq(Option x$1) {
        this.setClusterAcl = x$1;
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminClientTest adminClientTest = this;
        synchronized (adminClientTest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    @Override
    @Before
    public void setUp() {
        IntegrationTestHarness$class.setUp(this);
        this.client_$eq(AdminClient$.MODULE$.createSimplePlaintext(this.brokerList()));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testListGroups() {
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(0L);
                return !((KafkaConsumer)this.$outer.consumers().apply(0)).assignment().isEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3());
        List groups = this.client().listAllGroupsFlattened();
        Assert.assertFalse((boolean)groups.isEmpty());
        GroupOverview group = (GroupOverview)groups.apply(0);
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)"consumer", (Object)group.protocolType());
    }

    @Test
    public void testDescribeGroup() {
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(0L);
                return !((KafkaConsumer)this.$outer.consumers().apply(0)).assignment().isEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3());
        GroupSummary group = this.client().describeGroup(this.groupId());
        Assert.assertEquals((Object)"consumer", (Object)group.protocolType());
        Assert.assertEquals((Object)"range", (Object)group.protocol());
        Assert.assertEquals((Object)"Stable", (Object)group.state());
        Assert.assertFalse((boolean)group.members().isEmpty());
        MemberSummary member = (MemberSummary)group.members().apply(0);
        Assert.assertEquals((Object)this.clientId(), (Object)member.clientId());
        Assert.assertFalse((boolean)member.clientHost().isEmpty());
        Assert.assertFalse((boolean)member.memberId().isEmpty());
    }

    @Test
    public void testDescribeConsumerGroup() {
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(0L);
                return !((KafkaConsumer)this.$outer.consumers().apply(0)).assignment().isEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3());
        List consumerSummaries = this.client().describeConsumerGroup(this.groupId());
        Assert.assertEquals((long)1L, (long)consumerSummaries.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)((AdminClient.ConsumerSummary)consumerSummaries.head()).assignment().toSet());
    }

    @Test
    public void testDescribeConsumerGroupForNonExistentGroup() {
        String nonExistentGroup = new StringBuilder().append((Object)"non").append((Object)this.groupId()).toString();
        Assert.assertTrue((String)"Expected empty ConsumerSummary list", (boolean)this.client().describeConsumerGroup(nonExistentGroup).isEmpty());
    }

    public AdminClientTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        IntegrationTestHarness$class.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.groupId = "my-test";
        this.clientId = "consumer-498";
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.part2 = 1;
        this.tp2 = new TopicPartition(this.topic(), this.part2());
        this.client = null;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", this.groupId());
        this.consumerConfig().setProperty("client.id", this.clientId());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }
}

