/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.util.Arrays;
import kafka.coordinator.MemberMetadata;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u000f\t\u0011R*Z7cKJlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%\t!G\u0001\bOJ|W\u000f]%e+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011a\u0017M\\4\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0007'R\u0014\u0018N\\4\t\r\r\u0002\u0001\u0015!\u0003\u001b\u0003!9'o\\;q\u0013\u0012\u0004\u0003bB\u0013\u0001\u0005\u0004%\t!G\u0001\tG2LWM\u001c;JI\"1q\u0005\u0001Q\u0001\ni\t\u0011b\u00197jK:$\u0018\n\u001a\u0011\t\u000f%\u0002!\u0019!C\u00013\u0005Q1\r\\5f]RDun\u001d;\t\r-\u0002\u0001\u0015!\u0003\u001b\u0003-\u0019G.[3oi\"{7\u000f\u001e\u0011\t\u000f5\u0002!\u0019!C\u00013\u0005AQ.Z7cKJLE\r\u0003\u00040\u0001\u0001\u0006IAG\u0001\n[\u0016l'-\u001a:JI\u0002Bq!\r\u0001C\u0002\u0013\u0005!'\u0001\ttKN\u001c\u0018n\u001c8US6,w.\u001e;NgV\t1\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATGA\u0002J]RDaA\u000f\u0001!\u0002\u0013\u0019\u0014!E:fgNLwN\u001c+j[\u0016|W\u000f^'tA!)A\b\u0001C\u0001{\u0005iB/Z:u\u001b\u0006$8\r[3t'V\u0004\bo\u001c:uK\u0012\u0004&o\u001c;pG>d7/F\u0001?!\t!t(\u0003\u0002Ak\t!QK\\5uQ\tY$\t\u0005\u0002D\u000b6\tAI\u0003\u0002\f\u001d%\u0011a\t\u0012\u0002\u0005)\u0016\u001cH\u000fC\u0003I\u0001\u0011\u0005Q(\u0001\u000fuKN$hk\u001c;f\r>\u0014\bK]3gKJ\u0014X\r\u001a)s_R|7m\u001c7)\u0005\u001d\u0013\u0005\"B&\u0001\t\u0003i\u0014\u0001\u0004;fgRlU\r^1eCR\f\u0007F\u0001&C\u0011\u0015q\u0005\u0001\"\u0001>\u0003\u001d\"Xm\u001d;NKR\fG-\u0019;b%\u0006L7/Z:P]Vs7/\u001e9q_J$X\r\u001a)s_R|7m\u001c7)\t5\u0013\u0005+U\u0001\tKb\u0004Xm\u0019;fI\u000e\n!\u000b\u0005\u0002T7:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005i+\u0014a\u00029bG.\fw-Z\u0005\u00039v\u0013\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8o\u0015\tQV\u0007C\u0003`\u0001\u0011\u0005Q(\u0001\u0013uKN$hk\u001c;f%\u0006L7/Z:P]:{7+\u001e9q_J$X\r\u001a)s_R|7m\u001c7tQ\u0011q&\tU)")
public class MemberMetadataTest
extends JUnitSuite {
    private final String groupId;
    private final String clientId;
    private final String clientHost;
    private final String memberId;
    private final int sessionTimeoutMs;

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public String memberId() {
        return this.memberId;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    @Test
    public void testMatchesSupportedProtocols() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.sessionTimeoutMs(), protocols);
        Assert.assertTrue((boolean)member.matches(protocols));
        Assert.assertFalse((boolean)member.matches(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()))}))));
        Assert.assertFalse((boolean)member.matches(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}))));
        Assert.assertFalse((boolean)member.matches(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}))));
    }

    @Test
    public void testVoteForPreferredProtocol() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.sessionTimeoutMs(), protocols);
        Assert.assertEquals((Object)"range", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))));
        Assert.assertEquals((Object)"roundrobin", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah", "roundrobin"}))));
    }

    @Test
    public void testMetadata() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.sessionTimeoutMs(), protocols);
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()), member.metadata("range")));
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte()), member.metadata("roundrobin")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMetadataRaisesOnUnsupportedProtocol() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.sessionTimeoutMs(), protocols);
        member.metadata("blah");
        throw this.fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVoteRaisesOnNoSupportedProtocols() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.sessionTimeoutMs(), protocols);
        member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah"})));
        throw this.fail();
    }

    public MemberMetadataTest() {
        this.groupId = "groupId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.memberId = "memberId";
        this.sessionTimeoutMs = 10000;
    }
}

