/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.NoCompressionCodec$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001\u001d\u0011q\u0001T8h)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9ESJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H)\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\ta\u0001\\8h\t&\u0014\bBB\u0014\u0001A\u0003%!$A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000f%\u0002!\u0019!C\u0001U\u0005!A/[7f+\u0005Y\u0003C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0001TF\u0001\u0005N_\u000e\\G+[7f\u0011\u0019\u0011\u0004\u0001)A\u0005W\u0005)A/[7fA!9A\u0007\u0001a\u0001\n\u0003)\u0014AB2p]\u001aLw-F\u00017!\t9$(D\u00019\u0015\tID!\u0001\u0004tKJ4XM]\u0005\u0003wa\u00121bS1gW\u0006\u001cuN\u001c4jO\"9Q\b\u0001a\u0001\n\u0003q\u0014AC2p]\u001aLwm\u0018\u0013fcR\u0011q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0005+:LG\u000fC\u0004Gy\u0005\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004I\u0001\u0001\u0006KAN\u0001\bG>tg-[4!\u0011\u001dQ\u0005A1A\u0005\u0002-\u000b\u0011\u0002\\8h\u0007>tg-[4\u0016\u00031\u0003\"AF'\n\u00059\u0013!!\u0003'pO\u000e{gNZ5h\u0011\u0019\u0001\u0006\u0001)A\u0005\u0019\u0006QAn\\4D_:4\u0017n\u001a\u0011\t\u000bI\u0003A\u0011A*\u0002\u000bM,G/\u00169\u0015\u0003}B#!U+\u0011\u0005YCV\"A,\u000b\u0005-q\u0011BA-X\u0005\u0019\u0011UMZ8sK\")1\f\u0001C\u0001'\u0006AA/Z1s\t><h\u000e\u000b\u0002[;B\u0011aKX\u0005\u0003?^\u0013Q!\u00114uKJDQ!\u0019\u0001\u0005\u0002\t\fqb\u0019:fCR,W)\u001c9us2{wm\u001d\u000b\u0004\u007f\r,\u0007\"\u00023a\u0001\u0004Q\u0012a\u00013je\")a\r\u0019a\u0001O\u00069qN\u001a4tKR\u001c\bc\u0001!iU&\u0011\u0011.\u0011\u0002\u000byI,\u0007/Z1uK\u0012t\u0004C\u0001!l\u0013\ta\u0017IA\u0002J]RDQA\u001c\u0001\u0005\u0002M\u000bA\u0003^3tiRKW.\u001a\"bg\u0016$Gj\\4S_2d\u0007FA7q!\t1\u0016/\u0003\u0002s/\n!A+Z:u\u0011\u0015!\b\u0001\"\u0001T\u0003i!Xm\u001d;US6,')Y:fI2{wMU8mY*KG\u000f^3sQ\t\u0019\b\u000fC\u0003x\u0001\u0011\u00051+\u0001\u000buKN$8+\u001b>f\u0005\u0006\u001cX\r\u001a'pOJ{G\u000e\u001c\u0015\u0003mBDQA\u001f\u0001\u0005\u0002M\u000b\u0001\u0003^3ti2{\u0017\rZ#naRLHj\\4)\u0005e\u0004\b\"B?\u0001\t\u0003\u0019\u0016A\n;fgR\f\u0005\u000f]3oI\u0006sGMU3bI^KG\u000f[*fcV,g\u000e^5bY>3gm]3ug\"\u0012A\u0010\u001d\u0005\u0007\u0003\u0003\u0001A\u0011A*\u0002SQ,7\u000f^!qa\u0016tG-\u00118e%\u0016\fGmV5uQ:{gnU3rk\u0016tG/[1m\u001f\u001a47/\u001a;tQ\ty\b\u000f\u0003\u0004\u0002\b\u0001!\taU\u0001\u0011i\u0016\u001cHOU3bI\u0006#Hj\\4HCBD3!!\u0002q\u0011\u0019\ti\u0001\u0001C\u0001'\u0006\u0011B/Z:u%\u0016\fGmT;u\u001f\u001a\u0014\u0016M\\4fQ\r\tY\u0001\u001d\u0005\u0007\u0003'\u0001A\u0011A*\u0002\u0019Q,7\u000f\u001e'pOJ{G\u000e\\:)\u0007\u0005E\u0001\u000f\u0003\u0004\u0002\u001a\u0001!\taU\u0001\u0017i\u0016\u001cHoQ8naJ,7o]3e\u001b\u0016\u001c8/Y4fg\"\u001a\u0011q\u00039\t\r\u0005}\u0001\u0001\"\u0001T\u0003M\"Xm\u001d;UQ\u0006$x)\u0019:cC\u001e,7i\u001c7mK\u000e$\u0018N\\4TK\u001elWM\u001c;t\t>,7O\u001c;DQ\u0006tw-Z(gMN,G\u000fK\u0002\u0002\u001eADa!!\n\u0001\t\u0003\u0019\u0016a\u0006;fgRlUm]:bO\u0016\u001cV\r^*ju\u0016\u001c\u0005.Z2lQ\r\t\u0019\u0003\u001d\u0005\u0007\u0003W\u0001A\u0011A*\u0002;Q,7\u000f^\"p[B\f7\r^3e)>\u0004\u0018nY\"p]N$(/Y5oiND3!!\u000bq\u0011\u0019\t\t\u0004\u0001C\u0001'\u0006!B/Z:u\u001b\u0016\u001c8/Y4f'&TXm\u00115fG.D3!a\fq\u0011\u0019\t9\u0004\u0001C\u0001'\u0006qB/Z:u\u0019><'+Z2pm\u0016\u00148\u000fV8D_J\u0014Xm\u0019;PM\u001a\u001cX\r\u001e\u0015\u0004\u0003k\u0001\bBBA\u001f\u0001\u0011\u00051+\u0001\tuKN$\u0018J\u001c3fqJ+'-^5mI\"\u001a\u00111\b9\t\r\u0005\r\u0003\u0001\"\u0001T\u0003]!Xm\u001d;D_J\u0014X\u000f\u001d;J]\u0012,\u0007PU3ck&dG\rK\u0002\u0002BADa!!\u0013\u0001\t\u0003\u0019\u0016A\u0004;fgR$&/\u001e8dCR,Gk\u001c\u0015\u0004\u0003\u000f\u0002\bBBA(\u0001\u0011\u00051+A\u000fuKN$\u0018J\u001c3fqJ+7/\u001b>j]\u001e\fE\u000f\u0016:v]\u000e\fG/[8oQ\r\ti\u0005\u001d\u0005\u0007\u0003+\u0002A\u0011A*\u0002AQ,7\u000f\u001e\"pOV\u001c\u0018J\u001c3fqN+w-\\3oiN\f%/\u001a*f[>4X\r\u001a\u0015\u0004\u0003'\u0002\bBBA.\u0001\u0011\u00051+\u0001\fuKN$(+Z8qK:$\u0006.\u001a8UeVt7-\u0019;fQ\r\tI\u0006\u001d\u0005\u0007\u0003C\u0002A\u0011A*\u0002\u001fQ,7\u000f^!ts:\u001cG)\u001a7fi\u0016D3!a\u0018q\u0011\u0019\t9\u0007\u0001C\u0001'\u0006aB/Z:u\u001fB,g\u000eR3mKR,7o\u00142t_2,G/\u001a$jY\u0016\u001c\bfAA3a\"1\u0011Q\u000e\u0001\u0005\u0002M\u000b\u0001\u0005^3ti\u0006\u0003\b/\u001a8e\u001b\u0016\u001c8/Y4f/&$\bNT;mYB\u000b\u0017\u0010\\8bI\"\u001a\u00111\u000e9\t\r\u0005M\u0004\u0001\"\u0001T\u00039\"Xm\u001d;BaB,g\u000eZ,ji\"|U\u000f^(g\u001fJ$WM](gMN,Go\u001d+ie><8/\u0012=dKB$\u0018n\u001c8)\u000f\u0005E\u0004/a\u001e\u0002z\u0005AQ\r\u001f9fGR,Gm\t\u0002\u0002|A!\u0011QPAG\u001d\u0011\ty(!#\u000f\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007S1!!\"\u0007\u0003\u0019a$o\\8u}%\t!)C\u0002\u0002\f\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0010\u0006E%\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0019\u00111R!\t\r\u0005U\u0005\u0001\"\u0001T\u00039!Xm\u001d;D_J\u0014X\u000f\u001d;M_\u001eD3!a%q\u0011\u0019\tY\n\u0001C\u0001'\u0006)B/Z:u\u00072,\u0017M\\*ikR$wn\u001e8GS2,\u0007fAAMa\"1\u0011\u0011\u0015\u0001\u0005\u0002M\u000b1\u0004^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,\u0007fAAPa\"1\u0011q\u0015\u0001\u0005\u0002M\u000bq\u0005^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:F[B$\u0018PT1nK\"\u001a\u0011Q\u00159\t\r\u00055\u0006\u0001\"\u0001T\u0003\t\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'OT;mY\"\u001a\u00111\u00169\t\r\u0005M\u0006\u0001\"\u0001T\u00039\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/T5tg&twmU3qCJ\fGo\u001c:)\u0007\u0005E\u0006\u000f\u0003\u0004\u0002:\u0002!\taU\u0001+i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_Jl\u0015n]:j]\u001e$v\u000e]5dQ\r\t9\f\u001d\u0005\u0007\u0003\u007f\u0003A\u0011A*\u0002]Q,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X*[:tS:<\u0007+\u0019:uSRLwN\u001c\u0015\u0004\u0003{\u0003\bbBAc\u0001\u0011\u0005\u0011qY\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lW\r\u0006\u0004\u0002J\u0006]\u00171\u001c\t\u0005\u0003\u0017\f\tND\u0002A\u0003\u001bL1!a4B\u0003\u0019\u0001&/\u001a3fM&!\u00111[Ak\u0005\u0019\u0019FO]5oO*\u0019\u0011qZ!\t\u0011\u0005e\u00171\u0019a\u0001\u0003\u0013\fQ\u0001^8qS\u000eD\u0001\"!8\u0002D\u0002\u0007\u0011\u0011Z\u0001\na\u0006\u0014H/\u001b;j_:Da!!9\u0001\t\u0003\u0019\u0016a\u0007;fgR$U\r\\3uK>cGmU3h[\u0016tGo]'fi\"|G\rK\u0002\u0002`B\u0004")
public class LogTest
extends JUnitSuite {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime(0L);
    private KafkaConfig config = null;
    private final LogConfig logConfig = LogConfig$.MODULE$.apply();

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @Before
    public void setUp() {
        int x$22 = 0;
        String x$23 = "127.0.0.1:1";
        int x$24 = -1;
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$27 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$28 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$29 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$31 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$32 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$33 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$34 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$35 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$36 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$37 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$22, x$23, x$25, x$26, x$24, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    public void createEmptyLogs(File dir, Seq<Object> offsets) {
        offsets.foreach((Function1)new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final File dir$1;

            public final boolean apply(int offset) {
                return this.apply$mcZI$sp(offset);
            }

            public boolean apply$mcZI$sp(int offset) {
                Log$.MODULE$.logFilename(this.dir$1, (long)offset).createNewFile();
                return Log$.MODULE$.indexFilename(this.dir$1, (long)offset).createNewFile();
            }
            {
                this.dir$1 = dir$1;
            }
        });
    }

    @Test
    public void testTimeBasedLogRoll() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Predef$.MODULE$.long2Long(3600L));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"Log begins with a single empty segment.", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().segmentMs()) + 1L);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log doesn't roll if doing so creates an empty segment.", (long)1L, (long)log.numberOfSegments());
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log rolls on this append since time has expired.", (long)2L, (long)log.numberOfSegments());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final ByteBufferMessageSet set$1;
            private final Log log$1;

            public final void apply(int numSegments) {
                this.apply$mcVI$sp(numSegments);
            }

            public void apply$mcVI$sp(int numSegments) {
                this.$outer.time().sleep(Predef$.MODULE$.Long2long(this.log$1.config().segmentMs()) + 1L);
                this.log$1.append(this.set$1, this.log$1.append$default$2());
                Assert.assertEquals((String)"Changing time beyond rollMs and appending should create a new segment.", (long)numSegments, (long)this.log$1.numberOfSegments());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.set$1 = set$1;
                this.log$1 = log$1;
            }
        });
        int numSegments = log.numberOfSegments();
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().segmentMs()) + 1L);
        log.append(new ByteBufferMessageSet((Seq)Nil$.MODULE$), log.append$default$2());
        Assert.assertEquals((String)"Appending an empty message set should not roll log even if succient time has passed.", (long)numSegments, (long)log.numberOfSegments());
    }

    @Test
    public void testTimeBasedLogRollJitter() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        long maxJitter = 1200L;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Predef$.MODULE$.long2Long(3600L));
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), Predef$.MODULE$.long2Long(maxJitter));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"Log begins with a single empty segment.", (long)1L, (long)log.numberOfSegments());
        log.append(set, log.append$default$2());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().segmentMs()) - maxJitter);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log does not roll on this append because it occurs earlier than max jitter", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(maxJitter - log.activeSegment().rollJitterMs() + 1L);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log should roll after segmentMs adjusted by random jitter", (long)2L, (long)log.numberOfSegments());
    }

    @Test
    public void testSizeBasedLogRoll() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * (setSize - 1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg + 1).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$2;
            private final Log log$2;

            public final LogAppendInfo apply(int i) {
                return this.log$2.append(this.set$2, this.log$2.append$default$2());
            }
            {
                this.set$2 = set$2;
                this.log$2 = log$2;
            }
        });
        Assert.assertEquals((String)"There should be exactly 2 segments.", (long)2L, (long)log.numberOfSegments());
    }

    @Test
    public void testLoadEmptyLog() {
        this.createEmptyLogs(this.logDir(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        Log log = new Log(this.logDir(), this.logConfig(), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4()), log.append$default$2());
    }

    @Test
    public void testAppendAndReadWithSequentialOffsets() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(71));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Message[] messages2 = (Message[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).by(2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Message.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message[] messages$1;

            public final LogAppendInfo apply(int i) {
                return this.log$3.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$1[i]})), this.log$3.append$default$2());
            }
            {
                this.log$3 = log$3;
                this.messages$1 = messages$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach$mVc$sp((Function1)new Serializable(this, log, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message[] messages$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MessageAndOffset read = (MessageAndOffset)this.log$3.read((long)i, 100, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1)))).messageSet().head();
                Assert.assertEquals((String)"Offset read should match order appended.", (long)i, (long)read.offset());
                Assert.assertEquals((String)"Message should match appended.", (Object)this.messages$1[i], (Object)read.message());
            }
            {
                this.log$3 = log$3;
                this.messages$1 = messages$1;
            }
        });
        Assert.assertEquals((String)"Reading beyond the last message returns nothing.", (long)0L, (long)log.read((long)messages2.length, 100, (Option)None$.MODULE$).messageSet().size());
    }

    @Test
    public void testAppendAndReadWithNonSequentialOffsets() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(71));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int[] messageIds = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 200).by(7), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        Message[] messages2 = (Message[])Predef$.MODULE$.intArrayOps(messageIds).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Message.class)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final int[] messageIds$1;
            private final Message[] messages$2;

            public final LogAppendInfo apply(int i) {
                return this.log$4.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new kafka.common.LongRef((long)this.messageIds$1[i]), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$2[i]})), false);
            }
            {
                this.log$4 = log$4;
                this.messageIds$1 = messageIds$1;
                this.messages$2 = messages$2;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(messageIds).max((Ordering)Ordering.Int$.MODULE$))).foreach$mVc$sp((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final int[] messageIds$1;
            private final Message[] messages$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int idx = Predef$.MODULE$.intArrayOps(this.messageIds$1).indexWhere((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final boolean apply(int x$1) {
                        return this.apply$mcZI$sp(x$1);
                    }

                    public boolean apply$mcZI$sp(int x$1) {
                        return x$1 >= this.i$1;
                    }
                    {
                        this.i$1 = i$1;
                    }
                });
                MessageAndOffset read = (MessageAndOffset)this.log$4.read((long)i, 100, (Option)None$.MODULE$).messageSet().head();
                Assert.assertEquals((String)"Offset read should match message id.", (long)this.messageIds$1[idx], (long)read.offset());
                Assert.assertEquals((String)"Message should match appended.", (Object)this.messages$2[idx], (Object)read.message());
            }
            {
                this.log$4 = log$4;
                this.messageIds$1 = messageIds$1;
                this.messages$2 = messages$2;
            }
        });
    }

    @Test
    public void testReadAtLogGap() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        while (log.numberOfSegments() == 1) {
            log.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("42".getBytes())})), log.append$default$2());
        }
        ((LogSegment)log.logSegments().head()).truncateTo(1L);
        Assert.assertEquals((String)"A read should now return the last message in the log", (long)(log.logEndOffset() - 1L), (long)((MessageAndOffset)log.read(1L, 200, (Option)None$.MODULE$).messageSet().head()).offset());
    }

    @Test
    public void testReadOutOfRange() {
        this.createEmptyLogs(this.logDir(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{1024}));
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("42".getBytes())})), log.append$default$2());
        Assert.assertEquals((String)"Reading at the log end offset should produce 0 byte read.", (long)0L, (long)log.read(1025L, 1000, log.read$default$3()).messageSet().sizeInBytes());
        try {
            log.read(0L, 1000, log.read$default$3());
            throw this.fail("Reading below the log start offset should throw OffsetOutOfRangeException");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            try {
                log.read(1026L, 1000, log.read$default$3());
                throw this.fail("Reading at beyond the log end offset should throw OffsetOutOfRangeException");
            }
            catch (OffsetOutOfRangeException offsetOutOfRangeException2) {
                Assert.assertEquals((String)"Reading from below the specified maxOffset should produce 0 byte read.", (long)0L, (long)log.read(1025L, 1000, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1024L))).messageSet().sizeInBytes());
                return;
            }
        }
    }

    @Test
    public void testLogRolls() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int numMessages = 100;
        IndexedSeq messageSets = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ByteBufferMessageSet apply(int i) {
                return TestUtils$.MODULE$.singleMessageSet(((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        messageSets.foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$5;

            public final LogAppendInfo apply(ByteBufferMessageSet x$2) {
                return this.log$5.append(x$2, this.log$5.append$default$2());
            }
            {
                this.log$5 = log$5;
            }
        });
        log.flush();
        LongRef offset = new LongRef(0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log, messageSets, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$5;
            private final IndexedSeq messageSets$1;
            private final LongRef offset$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MessageSet messages2 = this.log$5.read(this.offset$1.elem, 0x100000, this.log$5.read$default$3()).messageSet();
                Assert.assertEquals((String)"Offsets not equal", (long)this.offset$1.elem, (long)((MessageAndOffset)messages2.head()).offset());
                Assert.assertEquals((String)new StringBuilder().append((Object)"Messages not equal at offset ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1.elem)).toString(), (Object)((MessageAndOffset)((IterableLike)this.messageSets$1.apply(i)).head()).message(), (Object)((MessageAndOffset)messages2.head()).message().toFormatVersion(((MessageAndOffset)((IterableLike)this.messageSets$1.apply(i)).head()).message().magic()));
                this.offset$1.elem = ((MessageAndOffset)messages2.head()).offset() + 1L;
            }
            {
                this.log$5 = log$5;
                this.messageSets$1 = messageSets$1;
                this.offset$1 = offset$1;
            }
        });
        MessageSet lastRead = log.read((long)numMessages, 0x100000, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(numMessages + 1)))).messageSet();
        Assert.assertEquals((String)"Should be no more messages", (long)0L, (long)lastRead.size());
        TestUtils$.MODULE$.retry(1000L, (Function0<BoxedUnit>)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertTrue((String)"Log role should have forced flush", (this.log$5.recoveryPoint() >= this.log$5.activeSegment().baseOffset() ? 1 : 0) != 0);
            }
            {
                this.log$5 = log$5;
            }
        });
    }

    @Test
    public void testCompressedMessages() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())})), log.append$default$2());
        log.append(new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("alpha".getBytes()), new Message("beta".getBytes())})), log.append$default$2());
        Assert.assertEquals((String)"Read at offset 0 should produce 0", (long)0L, (long)((MessageAndOffset)this.read$1(0, log).next()).offset());
        Assert.assertEquals((String)"Read at offset 1 should produce 0", (long)0L, (long)((MessageAndOffset)this.read$1(1, log).next()).offset());
        Assert.assertEquals((String)"Read at offset 2 should produce 2", (long)2L, (long)((MessageAndOffset)this.read$1(2, log).next()).offset());
        Assert.assertEquals((String)"Read at offset 3 should produce 2", (long)2L, (long)((MessageAndOffset)this.read$1(3, log).next()).offset());
    }

    @Test
    public void testThatGarbageCollectingSegmentsDoesntChangeOffset() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 25})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;

            public final void apply(int messagesToAppend) {
                this.apply$mcVI$sp(messagesToAppend);
            }

            public void apply$mcVI$sp(int messagesToAppend) {
                this.$outer.logDir().mkdirs();
                Properties logProps = new Properties();
                logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
                Log log = new Log(this.$outer.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesToAppend).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final Log log$7;

                    public final LogAppendInfo apply(int i) {
                        return this.log$7.append(TestUtils$.MODULE$.singleMessageSet(((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4()), this.log$7.append$default$2());
                    }
                    {
                        this.log$7 = log$7;
                    }
                });
                long currOffset = log.logEndOffset();
                Assert.assertEquals((long)currOffset, (long)messagesToAppend);
                log.deleteOldSegments((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogSegment x$3) {
                        return true;
                    }
                });
                Assert.assertEquals((String)"Deleting segments shouldn't have changed the logEndOffset", (long)currOffset, (long)log.logEndOffset());
                Assert.assertEquals((String)"We should still have one segment left", (long)1L, (long)log.numberOfSegments());
                Assert.assertEquals((String)"Further collection shouldn't delete anything", (long)0L, (long)log.deleteOldSegments((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogSegment x$4) {
                        return true;
                    }
                }));
                Assert.assertEquals((String)"Still no change in the logEndOffset", (long)currOffset, (long)log.logEndOffset());
                Assert.assertEquals((String)"Should still be able to append and should get the logEndOffset assigned to the new append", (long)currOffset, (long)log.append(TestUtils$.MODULE$.singleMessageSet("hello".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4()), log.append$default$2()).firstOffset());
                log.delete();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testMessageSetSizeCheck() {
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("You".getBytes()), new Message("bethe".getBytes())}));
        int configSegmentSize = messageSet.sizeInBytes() - 1;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(configSegmentSize));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        try {
            log.append(messageSet, log.append$default$2());
            throw this.fail("message set should throw RecordBatchTooLargeException.");
        }
        catch (RecordBatchTooLargeException recordBatchTooLargeException) {
            return;
        }
    }

    @Test
    public void testCompactedTopicConstraints() {
        Message keyedMessage = new Message("this message has a key".getBytes(), "and here it is".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.CurrentMagicValue());
        Message anotherKeyedMessage = new Message("this message also has a key".getBytes(), "another key".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.CurrentMagicValue());
        Message unkeyedMessage = new Message("this message does not have a key".getBytes());
        ByteBufferMessageSet messageSetWithUnkeyedMessage = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{unkeyedMessage, keyedMessage}));
        ByteBufferMessageSet messageSetWithOneUnkeyedMessage = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{unkeyedMessage}));
        ByteBufferMessageSet messageSetWithCompressedKeyedMessage = new ByteBufferMessageSet((CompressionCodec)GZIPCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{keyedMessage}));
        ByteBufferMessageSet messageSetWithCompressedUnkeyedMessage = new ByteBufferMessageSet((CompressionCodec)GZIPCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{keyedMessage, unkeyedMessage}));
        ByteBufferMessageSet messageSetWithKeyedMessage = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{keyedMessage}));
        ByteBufferMessageSet messageSetWithKeyedMessages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{keyedMessage, anotherKeyedMessage}));
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        try {
            log.append(messageSetWithUnkeyedMessage, log.append$default$2());
            throw this.fail("Compacted topics cannot accept a message without a key.");
        }
        catch (CorruptRecordException corruptRecordException) {
            try {
                log.append(messageSetWithOneUnkeyedMessage, log.append$default$2());
                throw this.fail("Compacted topics cannot accept a message without a key.");
            }
            catch (CorruptRecordException corruptRecordException2) {
                try {
                    log.append(messageSetWithCompressedUnkeyedMessage, log.append$default$2());
                    throw this.fail("Compacted topics cannot accept a message without a key.");
                }
                catch (CorruptRecordException corruptRecordException3) {
                    log.append(messageSetWithKeyedMessage, log.append$default$2());
                    log.append(messageSetWithKeyedMessages, log.append$default$2());
                    log.append(messageSetWithCompressedKeyedMessage, log.append$default$2());
                    return;
                }
            }
        }
    }

    @Test
    public void testMessageSizeCheck() {
        ByteBufferMessageSet first = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("You".getBytes()), new Message("bethe".getBytes())}));
        ByteBufferMessageSet second = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("change (I need more bytes)".getBytes())}));
        int maxMessageSize = second.sizeInBytes() - 1;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageSize));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(first, log.append$default$2());
        try {
            log.append(second, log.append$default$2());
            throw this.fail("Second message set should throw MessageSizeTooLargeException.");
        }
        catch (RecordTooLargeException recordTooLargeException) {
            return;
        }
    }

    @Test
    public void testLogRecoversToCorrectOffset() {
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(indexInterval));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, messageSize, log){
            public static final long serialVersionUID = 0L;
            private final int messageSize$1;
            private final ObjectRef log$8;

            public final LogAppendInfo apply(int i) {
                Log qual$1 = (Log)this.log$8.elem;
                ByteBufferMessageSet x$38 = TestUtils$.MODULE$.singleMessageSet(TestUtils$.MODULE$.randomBytes(this.messageSize$1), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
                boolean x$39 = qual$1.append$default$2();
                return qual$1.append(x$38, x$39);
            }
            {
                this.messageSize$1 = messageSize$1;
                this.log$8 = log$8;
            }
        });
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        long lastIndexOffset = ((Log)log.elem).activeSegment().index().lastOffset();
        int numIndexEntries = ((Log)log.elem).activeSegment().index().entries();
        long lastOffset = ((Log)log.elem).logEndOffset();
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, lastOffset, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened w/o recovery")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        Assert.assertEquals((String)"Should have same last index offset as before.", (long)lastIndexOffset, (long)((Log)log.elem).activeSegment().index().lastOffset());
        Assert.assertEquals((String)"Should have same number of index entries as before.", (long)numIndexEntries, (long)((Log)log.elem).activeSegment().index().entries());
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened with recovery")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        Assert.assertEquals((String)"Should have same last index offset as before.", (long)lastIndexOffset, (long)((Log)log.elem).activeSegment().index().lastOffset());
        Assert.assertEquals((String)"Should have same number of index entries as before.", (long)numIndexEntries, (long)((Log)log.elem).activeSegment().index().entries());
        ((Log)log.elem).close();
    }

    @Test
    public void testIndexRebuild() {
        int numMessages = 200;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(200));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final ObjectRef log$9;

            public final LogAppendInfo apply(int i) {
                Log qual$2 = (Log)this.log$9.elem;
                ByteBufferMessageSet x$40 = TestUtils$.MODULE$.singleMessageSet(TestUtils$.MODULE$.randomBytes(10), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
                boolean x$41 = qual$2.append$default$2();
                return qual$2.append(x$40, x$41);
            }
            {
                this.log$9 = log$9;
            }
        });
        Iterable indexFiles = (Iterable)((Log)log.elem).logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$5) {
                return x$5.index().file();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ((Log)log.elem).close();
        indexFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$6) {
                return x$6.delete();
            }
        });
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final ObjectRef log$9;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((MessageAndOffset)((Log)this.log$9.elem).read((long)i, 100, (Option)None$.MODULE$).messageSet().head()).offset());
            }
            {
                this.log$9 = log$9;
            }
        });
        ((Log)log.elem).close();
    }

    @Test
    public void testCorruptIndexRebuild() {
        int numMessages = 200;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(200));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final ObjectRef log$10;

            public final LogAppendInfo apply(int i) {
                Log qual$3 = (Log)this.log$10.elem;
                ByteBufferMessageSet x$42 = TestUtils$.MODULE$.singleMessageSet(TestUtils$.MODULE$.randomBytes(10), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
                boolean x$43 = qual$3.append$default$2();
                return qual$3.append(x$42, x$43);
            }
            {
                this.log$10 = log$10;
            }
        });
        Iterable indexFiles = (Iterable)((Log)log.elem).logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$7) {
                return x$7.index().file();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ((Log)log.elem).close();
        indexFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                bw.write("  ");
                bw.close();
            }
        });
        log.elem = new Log(this.logDir(), config, 200L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final ObjectRef log$10;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((MessageAndOffset)((Log)this.log$10.elem).read((long)i, 100, (Option)None$.MODULE$).messageSet().head()).offset());
            }
            {
                this.log$10 = log$10;
            }
        });
        ((Log)log.elem).close();
    }

    @Test
    public void testTruncateTo() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * setSize;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$11;

            public final LogAppendInfo apply(int i) {
                return this.log$11.append(this.set$3, this.log$11.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$11 = log$11;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segments.", (long)1L, (long)log.numberOfSegments());
        Assert.assertEquals((String)"Log end offset should be equal to number of messages", (long)msgPerSeg, (long)log.logEndOffset());
        long lastOffset = log.logEndOffset();
        long size2 = log.size();
        log.truncateTo(log.logEndOffset());
        Assert.assertEquals((String)"Should not change offset", (long)lastOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should not change log size", (long)size2, (long)log.size());
        log.truncateTo(log.logEndOffset() + 1L);
        Assert.assertEquals((String)"Should not change offset but should log error", (long)lastOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should not change log size", (long)size2, (long)log.size());
        log.truncateTo((long)(msgPerSeg / 2));
        Assert.assertEquals((String)"Should change offset", (long)log.logEndOffset(), (long)(msgPerSeg / 2));
        Assert.assertTrue((String)"Should change log size", (log.size() < size2 ? 1 : 0) != 0);
        log.truncateTo(0L);
        Assert.assertEquals((String)"Should change offset", (long)0L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should change log size", (long)0L, (long)log.size());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$11;

            public final LogAppendInfo apply(int i) {
                return this.log$11.append(this.set$3, this.log$11.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$11 = log$11;
            }
        });
        Assert.assertEquals((String)"Should be back to original offset", (long)log.logEndOffset(), (long)lastOffset);
        Assert.assertEquals((String)"Should be back to original size", (long)log.size(), (long)size2);
        log.truncateFullyAndStartAt(log.logEndOffset() - (long)(msgPerSeg - 1));
        Assert.assertEquals((String)"Should change offset", (long)log.logEndOffset(), (long)(lastOffset - (long)(msgPerSeg - 1)));
        Assert.assertEquals((String)"Should change log size", (long)log.size(), (long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$11;

            public final LogAppendInfo apply(int i) {
                return this.log$11.append(this.set$3, this.log$11.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$11 = log$11;
            }
        });
        Assert.assertTrue((String)"Should be ahead of to original offset", (log.logEndOffset() > (long)msgPerSeg ? 1 : 0) != 0);
        Assert.assertEquals((String)"log size should be same as before", (long)size2, (long)log.size());
        log.truncateTo(0L);
        Assert.assertEquals((String)"Should change offset", (long)0L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should change log size", (long)log.size(), (long)0L);
    }

    @Test
    public void testIndexResizingAtTruncation() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * setSize;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        LogConfig config = new LogConfig((Map)logProps);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$12;

            public final LogAppendInfo apply(int i) {
                return this.log$12.append(this.set$4, this.log$12.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$12 = log$12;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$12;

            public final LogAppendInfo apply(int i) {
                return this.log$12.append(this.set$4, this.log$12.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$12 = log$12;
            }
        });
        Assert.assertEquals((String)"There should be exactly 2 segment.", (long)2L, (long)log.numberOfSegments());
        Assert.assertEquals((String)"The index of the first segment should be trimmed to empty", (long)0L, (long)((LogSegment)log.logSegments().toList().apply(0)).index().maxEntries());
        log.truncateTo(0L);
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        Assert.assertEquals((String)"The index of segment 1 should be resized to maxIndexSize", (long)(Predef$.MODULE$.Integer2int(log.config().maxIndexSize()) / 8), (long)((LogSegment)log.logSegments().toList().apply(0)).index().maxEntries());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$12;

            public final LogAppendInfo apply(int i) {
                return this.log$12.append(this.set$4, this.log$12.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$12 = log$12;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
    }

    @Test
    public void testBogusIndexSegmentsAreRemoved() {
        File bogusIndex1 = Log$.MODULE$.indexFilename(this.logDir(), 0L);
        File bogusIndex2 = Log$.MODULE$.indexFilename(this.logDir(), 5L);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertTrue((String)"The first index file should have been replaced with a larger file", (bogusIndex1.length() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((String)"The second index file should have been deleted.", (boolean)bogusIndex2.exists());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$5;
            private final Log log$13;

            public final LogAppendInfo apply(int i) {
                return this.log$13.append(this.set$5, this.log$13.append$default$2());
            }
            {
                this.set$5 = set$5;
                this.log$13 = log$13;
            }
        });
        log.delete();
    }

    @Test
    public void testReopenThenTruncate() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(10000));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$6;
            private final ObjectRef log$14;

            public final LogAppendInfo apply(int i) {
                Log qual$4 = (Log)this.log$14.elem;
                ByteBufferMessageSet x$44 = this.set$6;
                boolean x$45 = qual$4.append$default$2();
                return qual$4.append(x$44, x$45);
            }
            {
                this.set$6 = set$6;
                this.log$14 = log$14;
            }
        });
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        ((Log)log.elem).truncateTo(3L);
        Assert.assertEquals((String)"All but one segment should be deleted.", (long)1L, (long)((Log)log.elem).numberOfSegments());
        Assert.assertEquals((String)"Log end offset should be 3.", (long)3L, (long)((Log)log.elem).logEndOffset());
    }

    @Test
    public void testAsyncDelete() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        int asyncDeleteMs = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(10000));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(asyncDeleteMs));
        LogConfig config = new LogConfig((Map)logProps);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$7;
            private final Log log$15;

            public final LogAppendInfo apply(int i) {
                return this.log$15.append(this.set$7, this.log$15.append$default$2());
            }
            {
                this.set$7 = set$7;
                this.log$15 = log$15;
            }
        });
        LogSegment[] segments = (LogSegment[])log.logSegments().toArray(ClassTag$.MODULE$.apply(LogSegment.class));
        File[] oldFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$8) {
                return x$8.log().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$9) {
                return x$9.index().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        log.deleteOldSegments((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment s) {
                return true;
            }
        });
        Assert.assertEquals((String)"Only one segment should remain.", (long)1L, (long)log.numberOfSegments());
        Assert.assertTrue((String)"All log and index files should end in .deleted", (Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$10) {
                return x$10.log().file().getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }) && Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$11) {
                return x$11.index().file().getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The .deleted files should still be there.", (Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$12) {
                return x$12.log().file().exists();
            }
        }) && Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$13) {
                return x$13.index().file().exists();
            }
        }) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The original file should be gone.", (boolean)Predef$.MODULE$.refArrayOps((Object[])oldFiles).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$14) {
                return !x$14.exists();
            }
        }));
        File[] deletedFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$15) {
                return x$15.log().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$16) {
                return x$16.index().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        this.time().sleep(asyncDeleteMs + 1);
        Assert.assertTrue((String)"Files should all be gone.", (boolean)Predef$.MODULE$.refArrayOps((Object[])deletedFiles).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$17) {
                return !x$17.exists();
            }
        }));
    }

    @Test
    public void testOpenDeletesObsoleteFiles() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$8;
            private final ObjectRef log$16;

            public final LogAppendInfo apply(int i) {
                Log qual$5 = (Log)this.log$16.elem;
                ByteBufferMessageSet x$46 = this.set$8;
                boolean x$47 = qual$5.append$default$2();
                return qual$5.append(x$46, x$47);
            }
            {
                this.set$8 = set$8;
                this.log$16 = log$16;
            }
        });
        ((Log)log.elem).deleteOldSegments((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment s) {
                return true;
            }
        });
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"The deleted segments should be gone.", (long)1L, (long)((Log)log.elem).numberOfSegments());
    }

    @Test
    public void testAppendMessageWithNullPayload() {
        Log log = new Log(this.logDir(), LogConfig$.MODULE$.apply(), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Message[] messageArray = new Message[1];
        messageArray[0] = new Message(null);
        log.append(new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray)), log.append$default$2());
        MessageSet messageSet = log.read(0L, 4096, (Option)None$.MODULE$).messageSet();
        Assert.assertEquals((long)0L, (long)((MessageAndOffset)messageSet.head()).offset());
        Assert.assertTrue((String)"Message payload should be null.", (boolean)((MessageAndOffset)messageSet.head()).message().isNull());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAppendWithOutOfOrderOffsetsThrowsException() {
        Log log = new Log(this.logDir(), LogConfig$.MODULE$.apply(), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Message[] messages2 = (Message[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Message.class));
        Predef$.MODULE$.refArrayOps((Object[])messages2).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$17;

            public final LogAppendInfo apply(Message message) {
                return this.log$17.append(new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{message})), this.log$17.append$default$2());
            }
            {
                this.log$17 = log$17;
            }
        });
        ByteBufferMessageSet invalidMessage = new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes())}));
        log.append(invalidMessage, false);
    }

    @Test
    public void testCorruptLog() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(65536));
        LogConfig config = new LogConfig((Map)logProps);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        long recoveryPoint = 50L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, config, set, recoveryPoint){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final LogConfig config$1;
            public final ByteBufferMessageSet set$9;
            private final long recoveryPoint$1;

            public final void apply(int iteration) {
                this.apply$mcVI$sp(iteration);
            }

            public void apply$mcVI$sp(int iteration) {
                this.$outer.logDir().mkdirs();
                ObjectRef log = new ObjectRef((Object)new Log(this.$outer.logDir(), this.config$1, 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time()));
                int numMessages = 50 + TestUtils$.MODULE$.random().nextInt(50);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCorruptLog$1 $outer;
                    private final ObjectRef log$18;

                    public final LogAppendInfo apply(int i) {
                        Log qual$6 = (Log)this.log$18.elem;
                        ByteBufferMessageSet x$48 = this.$outer.set$9;
                        boolean x$49 = qual$6.append$default$2();
                        return qual$6.append(x$48, x$49);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.log$18 = log$18;
                    }
                });
                Iterable messages2 = (Iterable)((Log)log.elem).logSegments().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<MessageAndOffset> apply(LogSegment x$18) {
                        return x$18.log().iterator().toList();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                ((Log)log.elem).close();
                TestUtils$.MODULE$.appendNonsenseToFile(((Log)log.elem).activeSegment().index().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
                TestUtils$.MODULE$.appendNonsenseToFile(((Log)log.elem).activeSegment().log().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
                log.elem = new Log(this.$outer.logDir(), this.config$1, this.recoveryPoint$1, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                Assert.assertEquals((long)numMessages, (long)((Log)log.elem).logEndOffset());
                Assert.assertEquals((String)"Messages in the log after recovery should be the same.", (Object)messages2, (Object)((Log)log.elem).logSegments().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<MessageAndOffset> apply(LogSegment x$19) {
                        return x$19.log().iterator().toList();
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
                Utils.delete((File)this.$outer.logDir());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.set$9 = set$9;
                this.recoveryPoint$1 = recoveryPoint$1;
            }
        });
    }

    @Test
    public void testCleanShutdownFile() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(65536));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig config = new LogConfig((Map)logProps);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        File parentLogDir = this.logDir().getParentFile();
        Assert.assertTrue((String)"Data directory %s must exist", (boolean)parentLogDir.isDirectory());
        File cleanShutdownFile = new File(parentLogDir, Log$.MODULE$.CleanShutdownFile());
        cleanShutdownFile.createNewFile();
        Assert.assertTrue((String)".kafka_cleanshutdown must exist", (boolean)cleanShutdownFile.exists());
        long recoveryPoint = 0L;
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$10;
            private final ObjectRef log$19;

            public final LogAppendInfo apply(int i) {
                Log qual$7 = (Log)this.log$19.elem;
                ByteBufferMessageSet x$50 = this.set$10;
                boolean x$51 = qual$7.append$default$2();
                return qual$7.append(x$50, x$51);
            }
            {
                this.set$10 = set$10;
                this.log$19 = log$19;
            }
        });
        ((Log)log.elem).close();
        recoveryPoint = ((Log)log.elem).logEndOffset();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((long)recoveryPoint, (long)((Log)log.elem).logEndOffset());
        cleanShutdownFile.delete();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.logDir()), this.topicPartitionName(topic, partition)));
        TopicAndPartition topicAndPartition = Log$.MODULE$.parseTopicPartitionName(dir);
        Assert.assertEquals((Object)topic, (Object)topicAndPartition.asTuple()._1());
        Assert.assertEquals((long)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (long)topicAndPartition.asTuple()._2$mcI$sp());
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        try {
            File dir = new File("");
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append((Object)dir.getCanonicalPath()).toString());
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        try {
            File dir = null;
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append(dir).toString());
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.logDir()), File.separator)).append((Object)topic).append((Object)partition).toString());
        try {
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append((Object)dir.getCanonicalPath()).toString());
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.logDir()), this.topicPartitionName(topic, partition)));
        try {
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append((Object)dir.getCanonicalPath()).toString());
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.logDir()), this.topicPartitionName(topic, partition)));
        try {
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append((Object)dir.getCanonicalPath()).toString());
        }
        catch (Exception exception) {
            return;
        }
    }

    public String topicPartitionName(String topic, String partition) {
        return new StringBuilder().append((Object)File.separator).append((Object)topic).append((Object)"-").append((Object)partition).toString();
    }

    @Test
    public void testDeleteOldSegmentsMethod() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = new LogConfig((Map)logProps);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$11;
            private final Log log$20;

            public final LogAppendInfo apply(int i) {
                return this.log$20.append(this.set$11, this.log$20.append$default$2());
            }
            {
                this.set$11 = set$11;
                this.log$20 = log$20;
            }
        });
        log.deleteOldSegments((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$20) {
                return true;
            }
        });
        Assert.assertEquals((String)"The deleted segments should be gone.", (long)1L, (long)log.numberOfSegments());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$11;
            private final Log log$20;

            public final LogAppendInfo apply(int i) {
                return this.log$20.append(this.set$11, this.log$20.append$default$2());
            }
            {
                this.set$11 = set$11;
                this.log$20 = log$20;
            }
        });
        log.delete();
        Assert.assertEquals((String)"The number of segments should be 0", (long)0L, (long)log.numberOfSegments());
        Assert.assertEquals((String)"The number of deleted segments shoud be zero.", (long)0L, (long)log.deleteOldSegments((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$21) {
                return true;
            }
        }));
    }

    private final Iterator read$1(int offset, Log log$6) {
        return ByteBufferMessageSet$.MODULE$.deepIterator((MessageAndOffset)log$6.read((long)offset, 4096, log$6.read$default$3()).messageSet().head());
    }
}

