/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kafka.cluster.Broker;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u000f\t\tR*\u001a;bI\u0006$\u0018mQ1dQ\u0016$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011%Q#A\u0003bgN+G/\u0006\u0002\u0017CQ\u0011qC\u000b\t\u00041uyR\"A\r\u000b\u0005iY\u0012\u0001B;uS2T\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t\u00191+\u001a;\u0011\u0005\u0001\nC\u0002\u0001\u0003\u0006EM\u0011\ra\t\u0002\u0002)F\u0011Ae\n\t\u0003\u0013\u0015J!A\n\u0006\u0003\u000f9{G\u000f[5oOB\u0011\u0011\u0002K\u0005\u0003S)\u00111!\u00118z\u0011\u0015Y3\u00031\u0001-\u0003\u0015)G.Z7t!\rIQfH\u0005\u0003])\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003\u0005:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018MT8o\u000bbL7\u000f^5oOR{\u0007/[2t)\u0005\u0011\u0004CA\u00054\u0013\t!$B\u0001\u0003V]&$\bFA\u00187!\t9D(D\u00019\u0015\tI$(A\u0003kk:LGOC\u0001<\u0003\ry'oZ\u0005\u0003{a\u0012A\u0001V3ti\")q\b\u0001C\u0001c\u0005\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0015\u0003}YBQA\u0011\u0001\u0005\u0002E\n1fZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0003\u0003ZBQ!\u0012\u0001\u0005\u0002E\n1eZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1SKBd\u0017nY1O_R\fe/Y5mC\ndW\r\u000b\u0002Em!)\u0001\n\u0001C\u0001c\u0005yr-\u001a;U_BL7-T3uC\u0012\fG/Y%te:{G/\u0011<bS2\f'\r\\3)\u0005\u001d3\u0004\"B&\u0001\t\u0003\t\u0014\u0001M4fiR{\u0007/[2NKR\fG-\u0019;b/&$\bNT8o'V\u0004\bo\u001c:uK\u0012\u001cVmY;sSRL\bK]8u_\u000e|G\u000e\u000b\u0002Km!)a\n\u0001C\u0001c\u0005qs-\u001a;BY&4XM\u0011:pW\u0016\u00148o\u00155pk2$gj\u001c;CK6+H/\u0019;fI\nKX\u000b\u001d3bi\u0016\u001c\u0015m\u00195fQ\tie\u0007")
public class MetadataCacheTest {
    private <T> java.util.Set<T> asSet(Seq<T> elems) {
        return new HashSet((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(elems).asJava());
    }

    @Test
    public void getTopicMetadataNonExistingTopics() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), SecurityProtocol.PLAINTEXT, cache.getTopicMetadata$default$3());
        Assert.assertTrue((boolean)topicMetadata.isEmpty());
    }

    @Test
    public void getTopicMetadata() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        scala.collection.immutable.Set brokers = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataCacheTest $outer;

            public final UpdateMetadataRequest.Broker apply(int brokerId) {
                return new UpdateMetadataRequest.Broker(brokerId, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.$outer.kafka$server$MetadataCacheTest$$securityProtocolToEndPoint$1(brokerId)).asJava(), "rack1");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, 0, 0, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}), zkVersion, this.asSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(topic, 1)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, 1, 1, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), zkVersion, this.asSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(topic, 2)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, 2, 2, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)}), zkVersion, this.asSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)}))))}));
        UpdateMetadataRequest updateMetadataRequest = new UpdateMetadataRequest(controllerId, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava());
        cache.updateCache(15, updateMetadataRequest);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SecurityProtocol[]{SecurityProtocol.PLAINTEXT, SecurityProtocol.SSL}))).foreach((Function1)new Serializable(this, topic, cache){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataCacheTest $outer;
            private final String topic$1;
            private final MetadataCache cache$1;

            public final void apply(SecurityProtocol securityProtocol) {
                Seq topicMetadatas = this.cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic$1})), securityProtocol, this.cache$1.getTopicMetadata$default$3());
                Assert.assertEquals((long)1L, (long)topicMetadatas.size());
                MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
                Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
                Assert.assertEquals((Object)this.topic$1, (Object)topicMetadata.topic());
                Buffer partitionMetadatas = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MetadataResponse.PartitionMetadata x$1) {
                        return x$1.partition();
                    }
                }, (Ordering)Ordering.Int$.MODULE$);
                Assert.assertEquals((long)3L, (long)partitionMetadatas.size());
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, securityProtocol, partitionMetadatas){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTopicMetadata$1 $outer;
                    private final SecurityProtocol securityProtocol$1;
                    private final Buffer partitionMetadatas$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)this.partitionMetadatas$1.apply(i);
                        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
                        Assert.assertEquals((long)i, (long)partitionMetadata.partition());
                        Node leader = partitionMetadata.leader();
                        Assert.assertEquals((long)i, (long)leader.id());
                        UpdateMetadataRequest.EndPoint endPoint = (UpdateMetadataRequest.EndPoint)this.$outer.kafka$server$MetadataCacheTest$$anonfun$$$outer().kafka$server$MetadataCacheTest$$securityProtocolToEndPoint$1(partitionMetadata.leader().id()).apply((Object)this.securityProtocol$1);
                        Assert.assertEquals((Object)endPoint.host, (Object)leader.host());
                        Assert.assertEquals((long)endPoint.port, (long)leader.port());
                        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{i})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Node x$2) {
                                return x$2.id();
                            }
                        }, Buffer$.MODULE$.canBuildFrom()));
                        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{i})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Node x$3) {
                                return x$3.id();
                            }
                        }, Buffer$.MODULE$.canBuildFrom()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.securityProtocol$1 = securityProtocol$1;
                        this.partitionMetadatas$1 = partitionMetadatas$1;
                    }
                });
            }

            public /* synthetic */ MetadataCacheTest kafka$server$MetadataCacheTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.cache$1 = cache$1;
            }
        });
    }

    @Test
    public void getTopicMetadataPartitionLeaderNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        UpdateMetadataRequest.Broker[] brokerArray = new UpdateMetadataRequest.Broker[1];
        brokerArray[0] = new UpdateMetadataRequest.Broker(0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)new UpdateMetadataRequest.EndPoint("foo", 9092))}))).asJava(), null);
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])brokerArray));
        int leader = 1;
        int leaderEpoch = 1;
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader, leaderEpoch, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}), zkVersion, this.asSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}))))}));
        UpdateMetadataRequest updateMetadataRequest = new UpdateMetadataRequest(controllerId, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava());
        cache.updateCache(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), SecurityProtocol.PLAINTEXT, cache.getTopicMetadata$default$3());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, (Object)partitionMetadata.error());
        Assert.assertTrue((boolean)partitionMetadata.isr().isEmpty());
        Assert.assertEquals((long)1L, (long)partitionMetadata.replicas().size());
        Assert.assertEquals((long)0L, (long)((Node)partitionMetadata.replicas().get(0)).id());
    }

    @Test
    public void getTopicMetadataReplicaNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        UpdateMetadataRequest.Broker[] brokerArray = new UpdateMetadataRequest.Broker[1];
        brokerArray[0] = new UpdateMetadataRequest.Broker(0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)new UpdateMetadataRequest.EndPoint("foo", 9092))}))).asJava(), null);
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])brokerArray));
        int leader = 0;
        int leaderEpoch = 0;
        java.util.Set replicas = this.asSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}));
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas))}));
        UpdateMetadataRequest updateMetadataRequest = new UpdateMetadataRequest(controllerId, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava());
        cache.updateCache(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), SecurityProtocol.PLAINTEXT, false);
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$5) {
                return x$5.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), SecurityProtocol.PLAINTEXT, true);
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$6) {
                return x$6.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$7) {
                return x$7.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataIsrNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)new UpdateMetadataRequest.EndPoint("foo", 9092))}))).asJava(), "rack1")}));
        int leader = 0;
        int leaderEpoch = 0;
        java.util.Set replicas = this.asSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}));
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas))}));
        UpdateMetadataRequest updateMetadataRequest = new UpdateMetadataRequest(controllerId, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava());
        cache.updateCache(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), SecurityProtocol.PLAINTEXT, false);
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$8) {
                return x$8.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$9) {
                return x$9.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), SecurityProtocol.PLAINTEXT, true);
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$10) {
                return x$10.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$11) {
                return x$11.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataWithNonSupportedSecurityProtocol() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)new UpdateMetadataRequest.EndPoint("foo", 9092))}))).asJava(), "")}));
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.Set replicas = this.asSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}));
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, 3, replicas))}));
        UpdateMetadataRequest updateMetadataRequest = new UpdateMetadataRequest(2, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava());
        cache.updateCache(15, updateMetadataRequest);
        try {
            Seq result = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), SecurityProtocol.SSL, cache.getTopicMetadata$default$3());
            Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception should be thrown by `getTopicMetadata` with non-supported SecurityProtocol, ", " was returned instead"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result})));
        }
        catch (BrokerEndPointNotAvailableException brokerEndPointNotAvailableException) {
            // empty catch block
        }
    }

    @Test
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        scala.collection.immutable.Set initialBrokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).toSet();
        this.updateCache$1(initialBrokerIds, topic, cache);
        Seq aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).toSet(), topic, cache);
        Assert.assertEquals((Object)initialBrokerIds, (Object)((TraversableOnce)aliveBrokersFromCache.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Broker x$12) {
                return x$12.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public final scala.collection.immutable.Map kafka$server$MetadataCacheTest$$securityProtocolToEndPoint$1(int brokerId) {
        String host = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)}));
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)new UpdateMetadataRequest.EndPoint(host, 9092)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.SSL), (Object)new UpdateMetadataRequest.EndPoint(host, 9093))}));
    }

    private final void updateCache$1(scala.collection.immutable.Set brokerIds, String topic$2, MetadataCache cache$2) {
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)brokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UpdateMetadataRequest.Broker apply(int brokerId) {
                return new UpdateMetadataRequest.Broker(brokerId, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)new UpdateMetadataRequest.EndPoint("foo", 9092))}))).asJava(), "");
            }
        }, Set$.MODULE$.canBuildFrom());
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.Set replicas = this.asSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}));
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(topic$2, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, 3, replicas))}));
        UpdateMetadataRequest updateMetadataRequest = new UpdateMetadataRequest(2, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava());
        cache$2.updateCache(15, updateMetadataRequest);
    }
}

