/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.ProducerRequest;
import kafka.api.Request$;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.Partition;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.producer.DefaultPartitioner;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Resource;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.StringEncoder;
import kafka.server.BrokerState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.OffsetCheckpoint;
import kafka.utils.FixedValuePartitioner;
import kafka.utils.IntEncoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.SystemTime$;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$$anonfun$getMessages$2$;
import kafka.utils.Time;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class TestUtils$
implements Logging {
    public static final TestUtils$ MODULE$;
    private final String IoTmpDir;
    private final String Letters;
    private final String Digits;
    private final String LettersAndDigits;
    private final Random seededRandom;
    private final Random random;
    private final int RandomPort;
    private final int MockZkPort;
    private final String MockZkConnect;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TestUtils$ testUtils$ = this;
        synchronized (testUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public String IoTmpDir() {
        return this.IoTmpDir;
    }

    public String Letters() {
        return this.Letters;
    }

    public String Digits() {
        return this.Digits;
    }

    public String LettersAndDigits() {
        return this.LettersAndDigits;
    }

    public Random seededRandom() {
        return this.seededRandom;
    }

    public Random random() {
        return this.random;
    }

    public int RandomPort() {
        return this.RandomPort;
    }

    public int MockZkPort() {
        return this.MockZkPort;
    }

    public String MockZkConnect() {
        return this.MockZkConnect;
    }

    public File tempDir() {
        return this.tempRelativeDir(this.IoTmpDir());
    }

    public String tempTopic() {
        return new StringBuilder().append((Object)"testTopic").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(1000000))).toString();
    }

    public File tempRelativeDir(String parent) {
        File parentFile = new File(parent);
        parentFile.mkdirs();
        return TestUtils.tempDirectory((Path)parentFile.toPath(), (String)"kafka-");
    }

    /*
     * WARNING - void declaration
     */
    public File randomPartitionLogDir(File parentDir) {
        void var3_3;
        int attempts = 1000;
        File f = (File)package$.MODULE$.Iterator().continually((Function0)new Serializable(parentDir){
            public static final long serialVersionUID = 0L;
            private final File parentDir$1;

            public final File apply() {
                return new File(this.parentDir$1, new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.random().nextInt(1000000))).toString());
            }
            {
                this.parentDir$1 = parentDir$1;
            }
        }).take(attempts).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.mkdir();
            }
        }).getOrElse((Function0)new Serializable(attempts){
            public static final long serialVersionUID = 0L;
            private final int attempts$1;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory after ", " attempts"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.attempts$1)})));
            }
            {
                this.attempts$1 = attempts$1;
            }
        });
        f.deleteOnExit();
        return var3_3;
    }

    public File tempFile() {
        return TestUtils.tempFile();
    }

    public FileChannel tempChannel() {
        return new RandomAccessFile(this.tempFile(), "rw").getChannel();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(KafkaConfig config, Time time) {
        void var3_3;
        KafkaServer server = new KafkaServer(config, time, KafkaServer$.MODULE$.$lessinit$greater$default$3());
        server.startup();
        return var3_3;
    }

    public Time createServer$default$2() {
        return SystemTime$.MODULE$;
    }

    public Seq<Properties> createBrokerConfigs(int numConfigs, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSsl, boolean enableSaslPlaintext, boolean enableSaslSsl, Map<Object, String> rackInfo) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numConfigs).map((Function1)new Serializable(zkConnect, enableControlledShutdown, enableDeleteTopic, interBrokerSecurityProtocol, trustStoreFile, saslProperties, enablePlaintext, enableSsl, enableSaslPlaintext, enableSaslSsl, rackInfo){
            public static final long serialVersionUID = 0L;
            private final String zkConnect$1;
            private final boolean enableControlledShutdown$1;
            private final boolean enableDeleteTopic$1;
            private final Option interBrokerSecurityProtocol$1;
            private final Option trustStoreFile$1;
            private final Option saslProperties$1;
            private final boolean enablePlaintext$1;
            private final boolean enableSsl$1;
            private final boolean enableSaslPlaintext$1;
            private final boolean enableSaslSsl$1;
            private final Map rackInfo$1;

            public final Properties apply(int node) {
                int x$10 = node;
                String x$11 = this.zkConnect$1;
                boolean x$12 = this.enableControlledShutdown$1;
                boolean x$13 = this.enableDeleteTopic$1;
                int x$14 = TestUtils$.MODULE$.RandomPort();
                Option x$15 = this.interBrokerSecurityProtocol$1;
                Option x$16 = this.trustStoreFile$1;
                Option x$17 = this.saslProperties$1;
                boolean x$18 = this.enablePlaintext$1;
                boolean x$19 = this.enableSsl$1;
                boolean x$20 = this.enableSaslPlaintext$1;
                boolean x$21 = this.enableSaslSsl$1;
                Option x$22 = this.rackInfo$1.get((Object)BoxesRunTime.boxToInteger((int)node));
                int x$23 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                int x$24 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                int x$25 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                return TestUtils$.MODULE$.createBrokerConfig(x$10, x$11, x$12, x$13, x$14, (Option<SecurityProtocol>)x$15, (Option<File>)x$16, (Option<Properties>)x$17, x$18, x$20, x$23, x$19, x$24, x$21, x$25, (Option<String>)x$22);
            }
            {
                this.zkConnect$1 = zkConnect$1;
                this.enableControlledShutdown$1 = enableControlledShutdown$1;
                this.enableDeleteTopic$1 = enableDeleteTopic$1;
                this.interBrokerSecurityProtocol$1 = interBrokerSecurityProtocol$1;
                this.trustStoreFile$1 = trustStoreFile$1;
                this.saslProperties$1 = saslProperties$1;
                this.enablePlaintext$1 = enablePlaintext$1;
                this.enableSsl$1 = enableSsl$1;
                this.enableSaslPlaintext$1 = enableSaslPlaintext$1;
                this.enableSaslSsl$1 = enableSaslSsl$1;
                this.rackInfo$1 = rackInfo$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public String getBrokerListStrFromServers(Seq<KafkaServer> servers, SecurityProtocol protocol) {
        return ((TraversableOnce)servers.map((Function1)new Serializable(protocol){
            public static final long serialVersionUID = 0L;
            private final SecurityProtocol protocol$1;

            public final String apply(KafkaServer s) {
                return Utils.formatAddress((String)s.config().hostName(), (Integer)Predef$.MODULE$.int2Integer(s.boundPort(this.protocol$1)));
            }
            {
                this.protocol$1 = protocol$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public SecurityProtocol getBrokerListStrFromServers$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Properties createBrokerConfig(int nodeId, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, int port, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSaslPlaintext, int saslPlaintextPort, boolean enableSsl, int sslPort, boolean enableSaslSsl, int saslSslPort, Option<String> rack) {
        ArrayBuffer protocolAndPorts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = enablePlaintext || this.shouldEnable$1(SecurityProtocol.PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)port))) : BoxedUnit.UNIT;
        Object object2 = enableSsl || this.shouldEnable$1(SecurityProtocol.SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.SSL), (Object)BoxesRunTime.boxToInteger((int)sslPort))) : BoxedUnit.UNIT;
        Object object3 = enableSaslPlaintext || this.shouldEnable$1(SecurityProtocol.SASL_PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.SASL_PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)saslPlaintextPort))) : BoxedUnit.UNIT;
        Object object4 = enableSaslSsl || this.shouldEnable$1(SecurityProtocol.SASL_SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.SASL_SSL), (Object)BoxesRunTime.boxToInteger((int)saslSslPort))) : BoxedUnit.UNIT;
        String listeners = ((TraversableOnce)protocolAndPorts.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<SecurityProtocol, Object> x0$1) {
                Tuple2<SecurityProtocol, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol.name, BoxesRunTime.boxToInteger((int)port)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",");
        Properties props = new Properties();
        Object object5 = nodeId >= 0 ? props.put("broker.id", ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString()) : BoxedUnit.UNIT;
        props.put("listeners", listeners);
        props.put("log.dir", this.tempDir().getAbsolutePath());
        props.put("zookeeper.connect", zkConnect);
        props.put("replica.socket.timeout.ms", "1500");
        props.put("controller.socket.timeout.ms", "1500");
        props.put("controlled.shutdown.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)enableControlledShutdown)).toString());
        props.put("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)enableDeleteTopic)).toString());
        props.put("controlled.shutdown.retry.backoff.ms", "100");
        props.put("log.cleaner.dedupe.buffer.size", "2097152");
        rack.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String x$3) {
                return this.props$1.put("broker.rack", x$3);
            }
            {
                this.props$1 = props$1;
            }
        });
        if (protocolAndPorts.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<SecurityProtocol, Object> x0$2) {
                Tuple2<SecurityProtocol, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
                    boolean bl = TestUtils$.MODULE$.kafka$utils$TestUtils$$usesSslTransportLayer(protocol);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })) {
            props.putAll((java.util.Map<?, ?>)this.sslConfigs(Mode.SERVER, false, trustStoreFile, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"server", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nodeId)}))));
        }
        if (protocolAndPorts.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<SecurityProtocol, Object> x0$3) {
                Tuple2<SecurityProtocol, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
                    boolean bl = TestUtils$.MODULE$.kafka$utils$TestUtils$$usesSaslTransportLayer(protocol);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })) {
            props.putAll((java.util.Map<?, ?>)this.saslConfigs(saslProperties));
        }
        interBrokerSecurityProtocol.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(SecurityProtocol protocol) {
                return this.props$1.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), protocol.name);
            }
            {
                this.props$1 = props$1;
            }
        });
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        return props;
    }

    public boolean createBrokerConfigs$default$3() {
        return true;
    }

    public boolean createBrokerConfigs$default$4() {
        return false;
    }

    public Option<SecurityProtocol> createBrokerConfigs$default$5() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfigs$default$6() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfigs$default$7() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfigs$default$8() {
        return true;
    }

    public boolean createBrokerConfigs$default$9() {
        return false;
    }

    public boolean createBrokerConfigs$default$10() {
        return false;
    }

    public boolean createBrokerConfigs$default$11() {
        return false;
    }

    public Map<Object, String> createBrokerConfigs$default$12() {
        return (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public boolean createBrokerConfig$default$4() {
        return false;
    }

    public int createBrokerConfig$default$5() {
        return this.RandomPort();
    }

    public Option<SecurityProtocol> createBrokerConfig$default$6() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfig$default$7() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfig$default$8() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfig$default$9() {
        return true;
    }

    public boolean createBrokerConfig$default$10() {
        return false;
    }

    public int createBrokerConfig$default$11() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$12() {
        return false;
    }

    public int createBrokerConfig$default$13() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$14() {
        return false;
    }

    public int createBrokerConfig$default$15() {
        return this.RandomPort();
    }

    public Option<String> createBrokerConfig$default$16() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Map<Object, Option<Object>> createTopic(ZkUtils zkUtils, String topic, int numPartitions, int replicationFactor, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminUtils$.MODULE$.createTopic(zkUtils, topic, numPartitions, replicationFactor, topicConfig, AdminUtils$.MODULE$.createTopic$default$6());
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(zkUtils, topic, servers){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$2;
            private final String topic$2;
            private final Seq servers$2;

            public final Tuple2<Object, Option<Object>> apply(int x0$4) {
                int n = x0$4;
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers$2, this.topic$2, n, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils$2, this.topic$2, n, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6()));
                return tuple2;
            }
            {
                this.zkUtils$2 = zkUtils$2;
                this.topic$2 = topic$2;
                this.servers$2 = servers$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public scala.collection.immutable.Map<Object, Option<Object>> createTopic(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers) {
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(zkUtils, topic, partitionReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        return ((TraversableOnce)partitionReplicaAssignment.keySet().map((Function1)new Serializable(zkUtils, topic, servers){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final String topic$1;
            private final Seq servers$1;

            public final Tuple2<Object, Option<Object>> apply(int x0$5) {
                int n = x0$5;
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers$1, this.topic$1, n, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils$1, this.topic$1, n, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6()));
                return tuple2;
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.topic$1 = topic$1;
                this.servers$1 = servers$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public int createTopic$default$3() {
        return 1;
    }

    public int createTopic$default$4() {
        return 1;
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public Properties createConsumerProperties(String zkConnect, String groupId, String consumerId, long consumerTimeout) {
        Properties props = new Properties();
        props.put("zookeeper.connect", zkConnect);
        props.put("group.id", groupId);
        props.put("consumer.id", consumerId);
        props.put("consumer.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)consumerTimeout)).toString());
        props.put("zookeeper.session.timeout.ms", "6000");
        props.put("zookeeper.sync.time.ms", "200");
        props.put("auto.commit.interval.ms", "1000");
        props.put("rebalance.max.retries", "4");
        props.put("auto.offset.reset", "smallest");
        props.put("num.consumer.fetchers", "2");
        return props;
    }

    public long createConsumerProperties$default$4() {
        return -1L;
    }

    public ByteBufferMessageSet singleMessageSet(byte[] payload, CompressionCodec codec, byte[] key, byte magicValue) {
        return new ByteBufferMessageSet(codec, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(payload, key, Message$.MODULE$.NoTimestamp(), magicValue)}));
    }

    public CompressionCodec singleMessageSet$default$2() {
        return NoCompressionCodec$.MODULE$;
    }

    public byte[] singleMessageSet$default$3() {
        return null;
    }

    public byte singleMessageSet$default$4() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] randomBytes(int numBytes) {
        void var2_2;
        byte[] bytes = new byte[numBytes];
        this.seededRandom().nextBytes(bytes);
        return var2_2;
    }

    public String randomString(int len) {
        StringBuilder b = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final StringBuilder b$1;

            public final StringBuilder apply(int i) {
                return this.b$1.append(TestUtils$.MODULE$.LettersAndDigits().charAt(TestUtils$.MODULE$.seededRandom().nextInt(TestUtils$.MODULE$.LettersAndDigits().length())));
            }
            {
                this.b$1 = b$1;
            }
        });
        return b.toString();
    }

    public void checkEquals(ByteBuffer b1, ByteBuffer b2) {
        Assert.assertEquals((String)"Buffers should have equal length", (long)(b1.limit() - b1.position()), (long)(b2.limit() - b2.position()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), b1.limit() - b1.position()).foreach$mVc$sp((Function1)new Serializable(b1, b2){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer b1$1;
            private final ByteBuffer b2$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)new StringBuilder().append((Object)"byte ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" byte not equal.").toString(), (long)this.b1$1.get(this.b1$1.position() + i), (long)this.b2$1.get(this.b1$1.position() + i));
            }
            {
                this.b1$1 = b1$1;
                this.b2$1 = b2$1;
            }
        });
    }

    public <T> void checkEquals(Iterator<T> expected, Iterator<T> actual) {
        int length = 0;
        while (expected.hasNext() && actual.hasNext()) {
            ++length;
            Assert.assertEquals((Object)expected.next(), (Object)actual.next());
        }
        if (expected.hasNext()) {
            int length1 = length;
            while (expected.hasNext()) {
                expected.next();
                ++length1;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- first has more: ").append((Object)BoxesRunTime.boxToInteger((int)length1)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
        if (actual.hasNext()) {
            int length2 = length;
            while (actual.hasNext()) {
                actual.next();
                ++length2;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- second has more: ").append((Object)BoxesRunTime.boxToInteger((int)length2)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
    }

    public <T> void checkLength(Iterator<T> s1, int expectedLength) {
        int n = 0;
        while (s1.hasNext()) {
            ++n;
            s1.next();
        }
        Assert.assertEquals((long)expectedLength, (long)n);
    }

    public <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assert.assertEquals(s1.next(), s2.next());
        }
        Assert.assertFalse((String)"Iterators have uneven length--first has more", (boolean)s1.hasNext());
        Assert.assertFalse((String)"Iterators have uneven length--second has more", (boolean)s2.hasNext());
    }

    public <T> Iterator<T> stackedIterator(Seq<Iterator<T>> s) {
        return new Iterator<T>(s){
            private Iterator<T> cur;
            private final Iterator<Iterator<T>> topIterator;

            public Iterator<T> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                return Iterator.class.grouped((Iterator)this, (int)size2);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start2, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start2) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start2, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
            }

            private Iterator<T> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<T> x$1) {
                this.cur = x$1;
            }

            private Iterator<Iterator<T>> topIterator() {
                return this.topIterator;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.cur() == null) {
                        if (this.topIterator().hasNext()) {
                            this.cur_$eq((Iterator)this.topIterator().next());
                        } else {
                            return false;
                        }
                    }
                    if (this.cur().hasNext()) {
                        return true;
                    }
                    this.cur_$eq(null);
                }
            }

            public T next() {
                return (T)this.cur().next();
            }
            {
                GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.cur = null;
                this.topIterator = s$1.iterator();
            }
        };
    }

    public String hexString(byte[] bytes) {
        return this.hexString(ByteBuffer.wrap(bytes));
    }

    public String hexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("0x");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.limit()).foreach((Function1)new Serializable(buffer, builder){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;
            private final StringBuilder builder$1;

            public final StringBuilder apply(int i) {
                return this.builder$1.append(String.format("%x", this.buffer$1.get(this.buffer$1.position() + i)));
            }
            {
                this.buffer$1 = buffer$1;
                this.builder$1 = builder$1;
            }
        });
        return builder.toString();
    }

    public <K, V> Producer<K, V> createProducer(String brokerList, String encoder, String keyEncoder, String partitioner, Properties producerProps) {
        Properties props = this.getProducerConfig(brokerList);
        if (producerProps != null) {
            props.putAll((java.util.Map<?, ?>)producerProps);
        }
        props.put("serializer.class", encoder);
        props.put("key.serializer.class", keyEncoder);
        props.put("partitioner.class", partitioner);
        return new Producer(new ProducerConfig(props));
    }

    public <K, V> String createProducer$default$2() {
        return DefaultEncoder.class.getName();
    }

    public <K, V> String createProducer$default$3() {
        return DefaultEncoder.class.getName();
    }

    public <K, V> String createProducer$default$4() {
        return DefaultPartitioner.class.getName();
    }

    public <K, V> Properties createProducer$default$5() {
        return null;
    }

    private Properties securityConfigs(Mode mode, SecurityProtocol securityProtocol, Option<File> trustStoreFile, String certAlias, Option<Properties> saslProperties) {
        Properties props = new Properties();
        if (this.kafka$utils$TestUtils$$usesSslTransportLayer(securityProtocol)) {
            SecurityProtocol securityProtocol2 = securityProtocol;
            SecurityProtocol securityProtocol3 = SecurityProtocol.SSL;
            props.putAll((java.util.Map<?, ?>)this.sslConfigs(mode, !(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null), trustStoreFile, certAlias));
        }
        if (this.kafka$utils$TestUtils$$usesSaslTransportLayer(securityProtocol)) {
            props.putAll((java.util.Map<?, ?>)this.saslConfigs(saslProperties));
        }
        props.put("security.protocol", securityProtocol.name);
        return props;
    }

    public Properties producerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "producer", saslProperties);
    }

    public <K, V> KafkaProducer<K, V> createNewProducer(String brokerList, int acks, long maxBlockMs, long bufferSize, int retries, long lingerMs, long requestTimeoutMs, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Serializer<K> keySerializer, Serializer<V> valueSerializer, Option<Properties> props) {
        Properties producerProps = (Properties)props.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Properties apply() {
                return new Properties();
            }
        });
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", ((Object)BoxesRunTime.boxToInteger((int)acks)).toString());
        producerProps.put("max.block.ms", ((Object)BoxesRunTime.boxToLong((long)maxBlockMs)).toString());
        producerProps.put("buffer.memory", ((Object)BoxesRunTime.boxToLong((long)bufferSize)).toString());
        producerProps.put("retries", ((Object)BoxesRunTime.boxToInteger((int)retries)).toString());
        producerProps.put("request.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)requestTimeoutMs)).toString());
        Map defaultProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"retry.backoff.ms"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"reconnect.backoff.ms"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"linger.ms"), (Object)((Object)BoxesRunTime.boxToLong((long)lingerMs)).toString())}));
        defaultProps.foreach((Function1)new Serializable(producerProps){
            public static final long serialVersionUID = 0L;
            private final Properties producerProps$1;

            public final Object apply(Tuple2<String, String> x0$6) {
                Tuple2<String, String> tuple2 = x0$6;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    BoxedUnit boxedUnit = this.producerProps$1.containsKey(key) ? BoxedUnit.UNIT : this.producerProps$1.put(key, value);
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producerProps$1 = producerProps$1;
            }
        });
        if (!producerProps.containsKey("security.protocol")) {
            producerProps.putAll((java.util.Map<?, ?>)this.producerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        }
        return new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public <K, V> int createNewProducer$default$2() {
        return -1;
    }

    public <K, V> long createNewProducer$default$3() {
        return 60000L;
    }

    public <K, V> long createNewProducer$default$4() {
        return 0x100000L;
    }

    public <K, V> int createNewProducer$default$5() {
        return 0;
    }

    public <K, V> long createNewProducer$default$6() {
        return 0L;
    }

    public <K, V> long createNewProducer$default$7() {
        return 10240L;
    }

    public <K, V> SecurityProtocol createNewProducer$default$8() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createNewProducer$default$9() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createNewProducer$default$10() {
        return None$.MODULE$;
    }

    public <K, V> ByteArraySerializer createNewProducer$default$11() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createNewProducer$default$12() {
        return new ByteArraySerializer();
    }

    public <K, V> Option<Properties> createNewProducer$default$13() {
        return None$.MODULE$;
    }

    public boolean kafka$utils$TestUtils$$usesSslTransportLayer(SecurityProtocol securityProtocol) {
        boolean bl;
        SecurityProtocol securityProtocol2 = securityProtocol;
        SecurityProtocol securityProtocol3 = SecurityProtocol.SSL;
        SecurityProtocol securityProtocol4 = securityProtocol2;
        if (!(securityProtocol3 != null ? !securityProtocol3.equals(securityProtocol4) : securityProtocol4 != null)) {
            bl = true;
        } else {
            SecurityProtocol securityProtocol5 = SecurityProtocol.SASL_SSL;
            SecurityProtocol securityProtocol6 = securityProtocol2;
            bl = !(securityProtocol5 != null ? !securityProtocol5.equals(securityProtocol6) : securityProtocol6 != null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public boolean kafka$utils$TestUtils$$usesSaslTransportLayer(SecurityProtocol securityProtocol) {
        boolean bl;
        SecurityProtocol securityProtocol2 = securityProtocol;
        SecurityProtocol securityProtocol3 = SecurityProtocol.SASL_PLAINTEXT;
        SecurityProtocol securityProtocol4 = securityProtocol2;
        if (!(securityProtocol3 != null ? !securityProtocol3.equals(securityProtocol4) : securityProtocol4 != null)) {
            bl = true;
        } else {
            SecurityProtocol securityProtocol5 = SecurityProtocol.SASL_SSL;
            SecurityProtocol securityProtocol6 = securityProtocol2;
            bl = !(securityProtocol5 != null ? !securityProtocol5.equals(securityProtocol6) : securityProtocol6 != null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public Properties consumerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "consumer", saslProperties);
    }

    public KafkaConsumer<byte[], byte[]> createNewConsumer(String brokerList, String groupId, String autoOffsetReset, long partitionFetchSize, String partitionAssignmentStrategy, int sessionTimeout, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Option<Properties> props) {
        Properties consumerProps = (Properties)props.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Properties apply() {
                return new Properties();
            }
        });
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("auto.offset.reset", autoOffsetReset);
        consumerProps.put("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToLong((long)partitionFetchSize)).toString());
        Map defaultProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"retry.backoff.ms"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"reconnect.backoff.ms"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"key.deserializer"), (Object)"org.apache.kafka.common.serialization.ByteArrayDeserializer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"value.deserializer"), (Object)"org.apache.kafka.common.serialization.ByteArrayDeserializer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partition.assignment.strategy"), (Object)partitionAssignmentStrategy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"session.timeout.ms"), (Object)((Object)BoxesRunTime.boxToInteger((int)sessionTimeout)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"group.id"), (Object)groupId)}));
        defaultProps.foreach((Function1)new Serializable(consumerProps){
            public static final long serialVersionUID = 0L;
            private final Properties consumerProps$1;

            public final Object apply(Tuple2<String, String> x0$7) {
                Tuple2<String, String> tuple2 = x0$7;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    BoxedUnit boxedUnit = this.consumerProps$1.containsKey(key) ? BoxedUnit.UNIT : this.consumerProps$1.put(key, value);
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.consumerProps$1 = consumerProps$1;
            }
        });
        if (!consumerProps.containsKey("security.protocol")) {
            consumerProps.putAll((java.util.Map<?, ?>)this.consumerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        }
        return new KafkaConsumer(consumerProps);
    }

    public String createNewConsumer$default$2() {
        return "group";
    }

    public String createNewConsumer$default$3() {
        return "earliest";
    }

    public long createNewConsumer$default$4() {
        return 4096L;
    }

    public String createNewConsumer$default$5() {
        return RangeAssignor.class.getName();
    }

    public int createNewConsumer$default$6() {
        return 30000;
    }

    public Option<File> createNewConsumer$default$8() {
        return None$.MODULE$;
    }

    public Option<Properties> createNewConsumer$default$9() {
        return None$.MODULE$;
    }

    public Option<Properties> createNewConsumer$default$10() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getProducerConfig(String brokerList) {
        void var2_2;
        Properties props = new Properties();
        props.put("metadata.broker.list", brokerList);
        props.put("message.send.max.retries", "5");
        props.put("retry.backoff.ms", "1000");
        props.put("request.timeout.ms", "2000");
        props.put("request.required.acks", "-1");
        props.put("send.buffer.bytes", "65536");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getSyncProducerConfig(int port) {
        void var2_2;
        Properties props = new Properties();
        props.put("host", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        props.put("request.timeout.ms", "500");
        props.put("request.required.acks", "1");
        props.put("serializer.class", StringEncoder.class.getName());
        return var2_2;
    }

    public void updateConsumerOffset(ConsumerConfig config, String path, long offset) {
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        zkUtils.updatePersistentPath(path, ((Object)BoxesRunTime.boxToLong((long)offset)).toString(), zkUtils.updatePersistentPath$default$3());
        zkUtils.close();
    }

    public Iterator<Message> getMessageIterator(Iterator<MessageAndOffset> iter) {
        return new IteratorTemplate<Message>(iter){
            private final Iterator iter$1;

            public Message makeNext() {
                return this.iter$1.hasNext() ? ((MessageAndOffset)this.iter$1.next()).message() : (Message)this.allDone();
            }
            {
                this.iter$1 = iter$1;
            }
        };
    }

    public Seq<Broker> createBrokersInZk(ZkUtils zkUtils, Seq<Object> ids) {
        return this.createBrokersInZk((Seq<BrokerMetadata>)((Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$4) {
                return new BrokerMetadata(x$4, (Option)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom())), zkUtils);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> createBrokersInZk(Seq<BrokerMetadata> brokerMetadatas, ZkUtils zkUtils) {
        void var3_3;
        Seq brokers = (Seq)brokerMetadatas.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(BrokerMetadata b) {
                SecurityProtocol protocol = SecurityProtocol.PLAINTEXT;
                return new Broker(b.id(), (Map)((TraversableOnce)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)protocol), (Object)new EndPoint("localhost", 6667, protocol))}))).toMap(Predef$.MODULE$.conforms()), b.rack());
            }
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1)new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$3;

            public final void apply(Broker b) {
                this.zkUtils$3.registerBrokerInZk(b.id(), "localhost", 6667, b.endPoints(), -1, b.rack(), ApiVersion$.MODULE$.latestVersion());
            }
            {
                this.zkUtils$3 = zkUtils$3;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> deleteBrokersInZk(ZkUtils zkUtils, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int id) {
                return new Broker(id, "localhost", 6667, SecurityProtocol.PLAINTEXT);
            }
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1)new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$7;

            public final boolean apply(Broker b) {
                return this.zkUtils$7.deletePath(new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)b).toString());
            }
            {
                this.zkUtils$7 = zkUtils$7;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getMsgStrings(int n) {
        void var2_2;
        ListBuffer buffer = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ListBuffer buffer$2;

            public final ListBuffer<String> apply(int i) {
                return this.buffer$2.$plus$eq((Object)new StringBuilder().append((Object)"msg").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
            }
            {
                this.buffer$2 = buffer$2;
            }
        });
        return var2_2;
    }

    public ProducerRequest produceRequest(String topic, int partition, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        return this.produceRequestWithAcks((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{partition}))), message, acks, timeout, correlationId, clientId);
    }

    public int produceRequest$default$6() {
        return 0;
    }

    public ProducerRequest produceRequestWithAcks(Seq<String> topics, Seq<Object> partitions, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        Seq data = (Seq)topics.flatMap((Function1)new Serializable(partitions, message){
            public static final long serialVersionUID = 0L;
            private final Seq partitions$1;
            public final ByteBufferMessageSet message$1;

            public final Seq<Tuple2<TopicAndPartition, ByteBufferMessageSet>> apply(String topic) {
                return (Seq)this.partitions$1.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.9 $outer;
                    private final String topic$11;

                    public final Tuple2<TopicAndPartition, ByteBufferMessageSet> apply(int partition) {
                        return new Tuple2((Object)new TopicAndPartition(this.topic$11, partition), (Object)this.$outer.message$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$11 = topic$11;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.partitions$1 = partitions$1;
                this.message$1 = message$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new ProducerRequest(correlationId, clientId, (short)acks, timeout, (scala.collection.mutable.Map)Map$.MODULE$.apply(data));
    }

    public int produceRequestWithAcks$default$6() {
        return 0;
    }

    public void makeLeaderForPartition(ZkUtils zkUtils, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap, int controllerEpoch) {
        leaderPerPartitionMap.foreach((Function1)new Serializable(zkUtils, topic, controllerEpoch){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$4;
            public final String topic$5;
            private final int controllerEpoch$1;

            public final void apply(Tuple2<Object, Object> leaderForPartition) {
                int partition = leaderForPartition._1$mcI$sp();
                int leader = leaderForPartition._2$mcI$sp();
                try {
                    Option currentLeaderAndIsrOpt = this.zkUtils$4.getLeaderAndIsrForPartition(this.topic$5, partition);
                    LeaderAndIsr newLeaderAndIsr = null;
                    Option option = currentLeaderAndIsrOpt;
                    None$ none$ = None$.MODULE$;
                    if (!(option != null ? !option.equals(none$) : none$ != null)) {
                        newLeaderAndIsr = new LeaderAndIsr(leader, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader})));
                    } else {
                        newLeaderAndIsr = (LeaderAndIsr)currentLeaderAndIsrOpt.get();
                        newLeaderAndIsr.leader_$eq(leader);
                        LeaderAndIsr leaderAndIsr = newLeaderAndIsr;
                        leaderAndIsr.leaderEpoch_$eq(leaderAndIsr.leaderEpoch() + 1);
                        LeaderAndIsr leaderAndIsr2 = newLeaderAndIsr;
                        leaderAndIsr2.zkVersion_$eq(leaderAndIsr2.zkVersion() + 1);
                    }
                    this.zkUtils$4.updatePersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(this.topic$5, partition), this.zkUtils$4.leaderAndIsrZkData(newLeaderAndIsr, this.controllerEpoch$1), this.zkUtils$4.updatePersistentPath$default$3());
                }
                catch (Throwable throwable) {
                    TestUtils$.MODULE$.error((Function0<String>)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.makeLeaderForPartition.1 $outer;
                        private final int partition$5;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Error while electing leader for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$5, BoxesRunTime.boxToInteger((int)this.partition$5)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.partition$5 = partition$5;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable oe$1;

                        public final Throwable apply() {
                            return this.oe$1;
                        }
                        {
                            this.oe$1 = oe$1;
                        }
                    });
                }
            }
            {
                this.zkUtils$4 = zkUtils$4;
                this.topic$5 = topic$5;
                this.controllerEpoch$1 = controllerEpoch$1;
            }
        });
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged(ZkUtils zkUtils, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(!oldLeaderOpt.isDefined() || !newLeaderOpt.isDefined(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't define both the old and the new leader";
            }
        });
        long startTime = System.currentTimeMillis();
        boolean isLeaderElectedOrChanged = false;
        this.trace((Function0<String>)new Serializable(topic, partition, oldLeaderOpt, newLeaderOpt){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final int partition$1;
            private final Option oldLeaderOpt$1;
            private final Option newLeaderOpt$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Waiting for leader to be elected or changed for partition [%s,%d], older leader is %s, new leader is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1), this.oldLeaderOpt$1, this.newLeaderOpt$1}));
            }
            {
                this.topic$3 = topic$3;
                this.partition$1 = partition$1;
                this.oldLeaderOpt$1 = oldLeaderOpt$1;
                this.newLeaderOpt$1 = newLeaderOpt$1;
            }
        });
        None$ leader = None$.MODULE$;
        while (!isLeaderElectedOrChanged && System.currentTimeMillis() < startTime + timeoutMs) {
            None$ none$;
            block13: {
                block12: {
                    BoxedUnit boxedUnit;
                    block11: {
                        BoxedUnit boxedUnit2;
                        leader = zkUtils.getLeaderForPartition(topic, partition);
                        none$ = leader;
                        if (!(none$ instanceof Some)) break block11;
                        Some some = (Some)none$;
                        int l = BoxesRunTime.unboxToInt((Object)some.x());
                        if (newLeaderOpt.isDefined() && BoxesRunTime.unboxToInt((Object)newLeaderOpt.get()) == l) {
                            this.trace((Function0<String>)new Serializable(topic, partition, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$3;
                                private final int partition$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Expected new leader %d is elected for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.l$1), this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                                }
                                {
                                    this.topic$3 = topic$3;
                                    this.partition$1 = partition$1;
                                    this.l$1 = l$1;
                                }
                            });
                            isLeaderElectedOrChanged = true;
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else if (oldLeaderOpt.isDefined() && BoxesRunTime.unboxToInt((Object)oldLeaderOpt.get()) != l) {
                            this.trace((Function0<String>)new Serializable(topic, partition, oldLeaderOpt, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$3;
                                private final int partition$1;
                                private final Option oldLeaderOpt$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Leader for partition [%s,%d] is changed from %d to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1), this.oldLeaderOpt$1.get(), BoxesRunTime.boxToInteger((int)this.l$1)}));
                                }
                                {
                                    this.topic$3 = topic$3;
                                    this.partition$1 = partition$1;
                                    this.oldLeaderOpt$1 = oldLeaderOpt$1;
                                    this.l$1 = l$1;
                                }
                            });
                            isLeaderElectedOrChanged = true;
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else if (oldLeaderOpt.isDefined()) {
                            this.trace((Function0<String>)new Serializable(topic, partition, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$3;
                                private final int partition$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Current leader for partition [%s,%d] is %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1), BoxesRunTime.boxToInteger((int)this.l$1)}));
                                }
                                {
                                    this.topic$3 = topic$3;
                                    this.partition$1 = partition$1;
                                    this.l$1 = l$1;
                                }
                            });
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            this.trace((Function0<String>)new Serializable(topic, partition, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$3;
                                private final int partition$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Leader %d is elected for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.l$1), this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                                }
                                {
                                    this.topic$3 = topic$3;
                                    this.partition$1 = partition$1;
                                    this.l$1 = l$1;
                                }
                            });
                            isLeaderElectedOrChanged = true;
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit2;
                        break block12;
                    }
                    None$ none$2 = None$.MODULE$;
                    None$ none$3 = none$;
                    if (none$2 != null ? !none$2.equals(none$3) : none$3 != null) break block13;
                    this.trace((Function0<String>)new Serializable(topic, partition){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;
                        private final int partition$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Leader for partition [%s,%d] is not elected yet")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                        }
                        {
                            this.topic$3 = topic$3;
                            this.partition$1 = partition$1;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                Thread.sleep(BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(timeoutMs)).min((Object)BoxesRunTime.boxToLong((long)100L))));
                continue;
            }
            throw new MatchError((Object)none$);
        }
        if (!isLeaderElectedOrChanged) {
            Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString("Timing out after %d ms since leader is not elected or changed for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timeoutMs), topic, BoxesRunTime.boxToInteger((int)partition)})));
        }
        return leader;
    }

    public long waitUntilLeaderIsElectedOrChanged$default$4() {
        return 5000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$6() {
        return None$.MODULE$;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        LongRef wait = new LongRef(1L);
        long startTime = System.currentTimeMillis();
        {
            block.apply$mcV$sp();
            return;
        }
    }

    public boolean waitUntilTrue(Function0<Object> condition, String msg, long waitTime) {
        long startTime = System.currentTimeMillis();
        while (!condition.apply$mcZ$sp()) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                Assert.fail((String)msg);
            }
            Thread.sleep(BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(waitTime)).min((Object)BoxesRunTime.boxToLong((long)100L))));
        }
        return true;
    }

    public long waitUntilTrue$default$3() {
        return 5000L;
    }

    public boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaServer server) {
        Option option;
        block4: {
            Option option2;
            block7: {
                boolean bl;
                block3: {
                    boolean bl2;
                    block6: {
                        block5: {
                            Option replicaOpt;
                            block2: {
                                Option partitionOpt;
                                option = partitionOpt = server.replicaManager().getPartition(topic, partitionId);
                                None$ none$ = None$.MODULE$;
                                Option option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block2;
                                bl = false;
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            Partition partition = (Partition)some.x();
                            option2 = replicaOpt = partition.leaderReplicaIfLocal();
                            None$ none$ = None$.MODULE$;
                            Option option4 = option2;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block5;
                            bl2 = false;
                            break block6;
                        }
                        if (!(option2 instanceof Some)) break block7;
                        bl2 = true;
                    }
                    bl = bl2;
                }
                return bl;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer createRequestByteBuffer(RequestOrResponse request) {
        void var2_2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(request.sizeInBytes() + 2);
        byteBuffer.putShort(BoxesRunTime.unboxToShort((Object)request.requestId().get()));
        request.writeTo(byteBuffer);
        byteBuffer.rewind();
        return var2_2;
    }

    public int waitUntilMetadataIsPropagated(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        IntRef leader = new IntRef(-1);
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topic, partition, leader){
            public static final long serialVersionUID = 0L;
            private final Seq servers$3;
            public final String topic$4;
            public final int partition$2;
            public final IntRef leader$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$3.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilMetadataIsPropagated.1 $outer;

                    public final boolean apply(boolean result, KafkaServer server) {
                        Option option;
                        block4: {
                            boolean bl;
                            block3: {
                                block2: {
                                    Option partitionStateOpt;
                                    option = partitionStateOpt = server.apis().metadataCache().getPartitionInfo(this.$outer.topic$4, this.$outer.partition$2);
                                    None$ none$ = None$.MODULE$;
                                    Option option2 = option;
                                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                                    bl = false;
                                    break block3;
                                }
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
                                this.$outer.leader$1.elem = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
                                bl = result && Request$.MODULE$.isValidBrokerId(this.$outer.leader$1.elem);
                            }
                            return bl;
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.servers$3 = servers$3;
                this.topic$4 = topic$4;
                this.partition$2 = partition$2;
                this.leader$1 = leader$1;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)timeout)})), timeout);
        return leader.elem;
    }

    public long waitUntilMetadataIsPropagated$default$4() {
        return 5000L;
    }

    public void waitUntilLeaderIsKnown(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topic, partition){
            public static final long serialVersionUID = 0L;
            private final Seq servers$6;
            public final String topic$10;
            public final int partition$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$6.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilLeaderIsKnown.1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return server.replicaManager().getPartition(this.$outer.topic$10, this.$outer.partition$4).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Partition x$5) {
                                return x$5.leaderReplicaIfLocal().isDefined();
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$6 = servers$6;
                this.topic$10 = topic$10;
                this.partition$4 = partition$4;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] leaders not made yet after %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)timeout)})), timeout);
    }

    public long waitUntilLeaderIsKnown$default$4() {
        return 5000L;
    }

    public void writeNonsenseToFile(File fileName, long position, int size2) {
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(position);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).foreach$mVc$sp((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final RandomAccessFile file$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.file$1.writeByte(TestUtils$.MODULE$.random().nextInt(255));
            }
            {
                this.file$1 = file$1;
            }
        });
        file.close();
    }

    public void appendNonsenseToFile(File fileName, int size2) {
        FileOutputStream file = new FileOutputStream(fileName, true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).foreach$mVc$sp((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final FileOutputStream file$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.file$2.write(TestUtils$.MODULE$.random().nextInt(255));
            }
            {
                this.file$2 = file$2;
            }
        });
        file.close();
    }

    public void checkForPhantomInSyncReplicas(ZkUtils zkUtils, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas) {
        Seq inSyncReplicas = zkUtils.getInSyncReplicasForPartition(topic, partitionToBeReassigned);
        Set phantomInSyncReplicas = (Set)inSyncReplicas.toSet().$minus$minus((GenTraversableOnce)assignedReplicas.toSet());
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("All in sync replicas %s must be in the assigned replica list %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inSyncReplicas, assignedReplicas})), (phantomInSyncReplicas.size() == 0 ? 1 : 0) != 0);
    }

    public void ensureNoUnderReplicatedPartitions(ZkUtils zkUtils, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas, Seq<KafkaServer> servers) {
        this.waitUntilTrue((Function0<Object>)new Serializable(zkUtils, topic, partitionToBeReassigned, assignedReplicas){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$5;
            private final String topic$6;
            private final int partitionToBeReassigned$1;
            private final Seq assignedReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Seq inSyncReplicas = this.zkUtils$5.getInSyncReplicasForPartition(this.topic$6, this.partitionToBeReassigned$1);
                return inSyncReplicas.size() == this.assignedReplicas$1.size();
            }
            {
                this.zkUtils$5 = zkUtils$5;
                this.topic$6 = topic$6;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
                this.assignedReplicas$1 = assignedReplicas$1;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under replicated")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3());
        ObjectRef leader = new ObjectRef((Object)None$.MODULE$);
        this.waitUntilTrue((Function0<Object>)new Serializable(zkUtils, topic, partitionToBeReassigned, leader){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$5;
            private final String topic$6;
            private final int partitionToBeReassigned$1;
            private final ObjectRef leader$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.leader$2.elem = this.zkUtils$5.getLeaderForPartition(this.topic$6, this.partitionToBeReassigned$1);
                return ((Option)this.leader$2.elem).isDefined();
            }
            {
                this.zkUtils$5 = zkUtils$5;
                this.topic$6 = topic$6;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
                this.leader$2 = leader$2;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is unavailable")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, leader){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final ObjectRef leader$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                KafkaServer leaderBroker = (KafkaServer)((IterableLike)this.servers$4.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.ensureNoUnderReplicatedPartitions.3 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() == BoxesRunTime.unboxToInt((Object)((Option)this.$outer.leader$2.elem).get());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).head();
                return leaderBroker.replicaManager().underReplicatedPartitionCount() == 0;
            }
            {
                this.servers$4 = servers$4;
                this.leader$2 = leader$2;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under-replicated as reported by the leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned), ((Option)leader.elem).get()})), this.waitUntilTrue$default$3());
    }

    public boolean checkIfReassignPartitionPathExists(ZkUtils zkUtils) {
        return zkUtils.pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
    }

    public void verifyNonDaemonThreadsStatus(String threadNamePrefix) {
        Assert.assertEquals((long)0L, (long)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Thread apply(Object x$6) {
                return (Thread)x$6;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Thread.class)))).count((Function1)new Serializable(threadNamePrefix){
            public static final long serialVersionUID = 0L;
            private final String threadNamePrefix$1;

            public final boolean apply(Thread t) {
                return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.threadNamePrefix$1);
            }
            {
                this.threadNamePrefix$1 = threadNamePrefix$1;
            }
        }));
    }

    public LogManager createLogManager(File[] logDirs, LogConfig defaultConfig, CleanerConfig cleanerConfig, MockTime time) {
        File[] x$35 = logDirs;
        Map x$36 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        LogConfig x$37 = defaultConfig;
        CleanerConfig x$38 = cleanerConfig;
        int x$39 = 4;
        long x$40 = 1000L;
        long x$41 = 10000L;
        long x$42 = 1000L;
        MockScheduler x$43 = time.scheduler();
        MockTime x$44 = time;
        BrokerState x$45 = new BrokerState();
        return new LogManager(x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, (Scheduler)x$43, x$45, (Time)x$44);
    }

    public File[] createLogManager$default$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public LogConfig createLogManager$default$2() {
        return LogConfig$.MODULE$.apply();
    }

    public CleanerConfig createLogManager$default$3() {
        boolean x$72 = false;
        int x$73 = CleanerConfig$.MODULE$.apply$default$1();
        long x$74 = CleanerConfig$.MODULE$.apply$default$2();
        double x$75 = CleanerConfig$.MODULE$.apply$default$3();
        int x$76 = CleanerConfig$.MODULE$.apply$default$4();
        int x$77 = CleanerConfig$.MODULE$.apply$default$5();
        double x$78 = CleanerConfig$.MODULE$.apply$default$6();
        long x$79 = CleanerConfig$.MODULE$.apply$default$7();
        String x$80 = CleanerConfig$.MODULE$.apply$default$9();
        return new CleanerConfig(x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$72, x$80);
    }

    public MockTime createLogManager$default$4() {
        return new MockTime();
    }

    public List<String> sendMessages(Seq<KafkaServer> servers, String topic, int numMessages, int partition, CompressionCodec compression) {
        List list;
        String header = new StringOps(Predef$.MODULE$.augmentString("test-%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition)}));
        Properties props = new Properties();
        props.put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)compression.codec())).toString());
        IndexedSeq ms = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(header){
            public static final long serialVersionUID = 0L;
            private final String header$1;

            public final String apply(int x) {
                return new StringBuilder().append((Object)this.header$1).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)x)).toString();
            }
            {
                this.header$1 = header$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        if (partition >= 0) {
            Producer producer = this.createProducer(this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), IntEncoder.class.getName(), FixedValuePartitioner.class.getName(), props);
            producer.send((Seq)ms.map((Function1)new Serializable(topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$8;
                private final int partition$3;

                public final KeyedMessage<Object, String> apply(String m) {
                    return new KeyedMessage(this.topic$8, (Object)BoxesRunTime.boxToInteger((int)this.partition$3), (Object)m);
                }
                {
                    this.topic$8 = topic$8;
                    this.partition$3 = partition$3;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom()));
            this.debug((Function0<String>)new Serializable(topic, partition, ms){
                public static final long serialVersionUID = 0L;
                private final String topic$8;
                private final int partition$3;
                private final IndexedSeq ms$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sent %d messages for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ms$1.size()), this.topic$8, BoxesRunTime.boxToInteger((int)this.partition$3)}));
                }
                {
                    this.topic$8 = topic$8;
                    this.partition$3 = partition$3;
                    this.ms$1 = ms$1;
                }
            });
            producer.close();
            list = ms.toList();
        } else {
            Producer producer = this.createProducer(this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), DefaultPartitioner.class.getName(), props);
            producer.send((Seq)ms.map((Function1)new Serializable(topic){
                public static final long serialVersionUID = 0L;
                private final String topic$8;

                public final KeyedMessage<String, String> apply(String m) {
                    return new KeyedMessage(this.topic$8, (Object)this.topic$8, (Object)m);
                }
                {
                    this.topic$8 = topic$8;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom()));
            producer.close();
            this.debug((Function0<String>)new Serializable(topic, ms){
                public static final long serialVersionUID = 0L;
                private final String topic$8;
                private final IndexedSeq ms$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sent %d messages for topic [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ms$1.size()), this.topic$8}));
                }
                {
                    this.topic$8 = topic$8;
                    this.ms$1 = ms$1;
                }
            });
            list = ms.toList();
        }
        return list;
    }

    public int sendMessages$default$4() {
        return -1;
    }

    public CompressionCodec sendMessages$default$5() {
        return NoCompressionCodec$.MODULE$;
    }

    public Seq<String> produceMessages(Seq<KafkaServer> servers, String topic, int numMessages) {
        String x$46 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$47 = 5;
        long x$48 = 2000L;
        int x$49 = this.createNewProducer$default$2();
        long x$50 = this.createNewProducer$default$3();
        long x$51 = this.createNewProducer$default$4();
        long x$52 = this.createNewProducer$default$6();
        SecurityProtocol x$53 = this.createNewProducer$default$8();
        Option<File> x$54 = this.createNewProducer$default$9();
        Option<Properties> x$55 = this.createNewProducer$default$10();
        ByteArraySerializer x$56 = this.createNewProducer$default$11();
        ByteArraySerializer x$57 = this.createNewProducer$default$12();
        Option<Properties> x$58 = this.createNewProducer$default$13();
        KafkaProducer producer = this.createNewProducer(x$46, x$49, x$50, x$51, x$47, x$52, x$48, x$53, x$54, x$55, (Serializer)x$56, (Serializer)x$57, x$58);
        IndexedSeq values = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int x) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq futures = (IndexedSeq)values.map((Function1)new Serializable(topic, producer){
            public static final long serialVersionUID = 0L;
            private final String topic$9;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(String value) {
                return this.producer$1.send(new ProducerRecord(this.topic$9, null, null, (Object)value.getBytes()));
            }
            {
                this.topic$9 = topic$9;
                this.producer$1 = producer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                return x$7.get();
            }
        });
        producer.close();
        this.debug((Function0<String>)new Serializable(topic, values){
            public static final long serialVersionUID = 0L;
            private final String topic$9;
            private final IndexedSeq values$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sent ", " messages for topic [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.values$1.size()), this.topic$9}));
            }
            {
                this.topic$9 = topic$9;
                this.values$1 = values$1;
            }
        });
        return values;
    }

    public void produceMessage(Seq<KafkaServer> servers, String topic, String message) {
        String x$59 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$60 = 5;
        long x$61 = 2000L;
        int x$62 = this.createNewProducer$default$2();
        long x$63 = this.createNewProducer$default$3();
        long x$64 = this.createNewProducer$default$4();
        long x$65 = this.createNewProducer$default$6();
        SecurityProtocol x$66 = this.createNewProducer$default$8();
        Option<File> x$67 = this.createNewProducer$default$9();
        Option<Properties> x$68 = this.createNewProducer$default$10();
        ByteArraySerializer x$69 = this.createNewProducer$default$11();
        ByteArraySerializer x$70 = this.createNewProducer$default$12();
        Option<Properties> x$71 = this.createNewProducer$default$13();
        KafkaProducer producer = this.createNewProducer(x$59, x$62, x$63, x$64, x$60, x$65, x$61, x$66, x$67, x$68, (Serializer)x$69, (Serializer)x$70, x$71);
        producer.send(new ProducerRecord(topic, (Object)topic.getBytes(), (Object)message.getBytes())).get();
        producer.close();
    }

    public List<String> getMessages(Map<String, List<KafkaStream<String, String>>> topicMessageStreams, int nMessagesPerThread) {
        ObjectRef messages2 = new ObjectRef((Object)Nil$.MODULE$);
        boolean shouldGetAllMessages = nMessagesPerThread < 0;
        topicMessageStreams.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, List<KafkaStream<String, String>>> check$ifrefutable$1) {
                Tuple2<String, List<KafkaStream<String, String>>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(nMessagesPerThread, messages2, shouldGetAllMessages){
            public static final long serialVersionUID = 0L;
            public final int nMessagesPerThread$1;
            public final ObjectRef messages$1;
            public final boolean shouldGetAllMessages$1;

            public final void apply(Tuple2<String, List<KafkaStream<String, String>>> x$8) {
                Tuple2<String, List<KafkaStream<String, String>>> tuple2 = x$8;
                if (tuple2 != null) {
                    List messageStreams = (List)tuple2._2();
                    messageStreams.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getMessages.2 $outer;

                        public final void apply(KafkaStream<String, String> messageStream) {
                            ConsumerTimeoutException consumerTimeoutException2;
                            block3: {
                                ConsumerIterator iterator = messageStream.iterator();
                                try {
                                    for (int i = 0; this.$outer.shouldGetAllMessages$1 && iterator.hasNext() || i < this.$outer.nMessagesPerThread$1; ++i) {
                                        Assert.assertTrue((boolean)iterator.hasNext());
                                        String message = (String)iterator.next().message();
                                        this.$outer.messages$1.elem = ((List)this.$outer.messages$1.elem).$colon$colon((Object)message);
                                        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, message){
                                            public static final long serialVersionUID = 0L;
                                            private final String message$3;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"received message: ").append((Object)this.message$3).toString();
                                            }
                                            {
                                                this.message$3 = message$3;
                                            }
                                        });
                                    }
                                }
                                catch (ConsumerTimeoutException consumerTimeoutException2) {
                                    if (!this.$outer.shouldGetAllMessages$1) break block3;
                                    TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$getMessages$2$$anonfun$apply$5 $outer;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"consumer timed out after receiving ").append((Object)BoxesRunTime.boxToInteger((int)((List)this.$outer.kafka$utils$TestUtils$$anonfun$$anonfun$$$outer().messages$1.elem).length())).append((Object)" message(s).").toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }
                                return;
                            }
                            throw consumerTimeoutException2;
                        }

                        public /* synthetic */ anonfun.getMessages.2 kafka$utils$TestUtils$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.nMessagesPerThread$1 = nMessagesPerThread$1;
                this.messages$1 = messages$1;
                this.shouldGetAllMessages$1 = shouldGetAllMessages$1;
            }
        });
        return ((List)messages2.elem).reverse();
    }

    public int getMessages$default$2() {
        return -1;
    }

    public void verifyTopicDeletion(ZkUtils zkUtils, String topic, int numPartitions, Seq<KafkaServer> servers) {
        IndexedSeq topicAndPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final String topic$7;

            public final TopicAndPartition apply(int x$9) {
                return new TopicAndPartition(this.topic$7, x$9);
            }
            {
                this.topic$7 = topic$7;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.waitUntilTrue((Function0<Object>)new Serializable(zkUtils, topic){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$6;
            private final String topic$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.zkUtils$6.pathExists(ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$7));
            }
            {
                this.zkUtils$6 = zkUtils$6;
                this.topic$7 = topic$7;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even after a replica is restarted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), this.waitUntilTrue$default$3());
        this.waitUntilTrue((Function0<Object>)new Serializable(zkUtils, topic){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$6;
            private final String topic$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.zkUtils$6.pathExists(ZkUtils$.MODULE$.getTopicPath(this.topic$7));
            }
            {
                this.zkUtils$6 = zkUtils$6;
                this.topic$7 = topic$7;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Topic path /brokers/topics/%s not deleted after /admin/delete_topic/%s path is deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, topic})), this.waitUntilTrue$default$3());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicAndPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$5;
            public final IndexedSeq topicAndPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$5.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.3 $outer;

                    public final boolean apply(KafkaServer server) {
                        return this.$outer.topicAndPartitions$1.forall((Function1)new Serializable(this, server){
                            public static final long serialVersionUID = 0L;
                            private final KafkaServer server$1;

                            public final boolean apply(TopicAndPartition tp) {
                                Option option = this.server$1.replicaManager().getPartition(tp.topic(), tp.partition());
                                None$ none$ = None$.MODULE$;
                                return !(option != null ? !option.equals(none$) : none$ != null);
                            }
                            {
                                this.server$1 = server$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$5 = servers$5;
                this.topicAndPartitions$1 = topicAndPartitions$1;
            }
        }, "Replica manager's should have deleted all of this topic's partitions", this.waitUntilTrue$default$3());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)servers.forall((Function1)new Serializable(topicAndPartitions){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq topicAndPartitions$1;

            public final boolean apply(KafkaServer server) {
                return this.topicAndPartitions$1.forall((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    private final KafkaServer server$2;

                    public final boolean apply(TopicAndPartition tp) {
                        return this.server$2.getLogManager().getLog(tp).isEmpty();
                    }
                    {
                        this.server$2 = server$2;
                    }
                });
            }
            {
                this.topicAndPartitions$1 = topicAndPartitions$1;
            }
        }));
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicAndPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$5;
            public final IndexedSeq topicAndPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$5.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.4 $outer;

                    public final boolean apply(KafkaServer server) {
                        return this.$outer.topicAndPartitions$1.forall((Function1)new Serializable(this, server){
                            public static final long serialVersionUID = 0L;
                            private final KafkaServer server$3;

                            public final boolean apply(TopicAndPartition tp) {
                                Map[] checkpoints = (Map[])Predef$.MODULE$.refArrayOps((Object[])this.server$3.getLogManager().logDirs()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Map<TopicAndPartition, Object> apply(File logDir) {
                                        return new OffsetCheckpoint(new File(logDir, "cleaner-offset-checkpoint")).read();
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)));
                                return Predef$.MODULE$.refArrayOps((Object[])checkpoints).forall((Function1)new Serializable(this, tp){
                                    public static final long serialVersionUID = 0L;
                                    private final TopicAndPartition tp$1;

                                    public final boolean apply(Map<TopicAndPartition, Object> checkpointsPerLogDir) {
                                        return !checkpointsPerLogDir.contains((Object)this.tp$1);
                                    }
                                    {
                                        this.tp$1 = tp$1;
                                    }
                                });
                            }
                            {
                                this.server$3 = server$3;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$5 = servers$5;
                this.topicAndPartitions$1 = topicAndPartitions$1;
            }
        }, "Cleaner offset for deleted partition should have been removed", this.waitUntilTrue$default$3());
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    public Properties sslConfigs(Mode mode, boolean clientCert, Option<File> trustStoreFile, String certAlias) {
        File trustStore = (File)trustStoreFile.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception("SSL enabled but no trustStoreFile provided");
            }
        });
        java.util.Map sslConfigs2 = TestSslUtils.createSslConfig((boolean)clientCert, (boolean)true, (Mode)mode, (File)trustStore, (String)certAlias);
        Properties sslProps = new Properties();
        JavaConversions$.MODULE$.mapAsScalaMap(sslConfigs2).foreach((Function1)new Serializable(sslProps){
            public static final long serialVersionUID = 0L;
            private final Properties sslProps$1;

            public final Object apply(Tuple2<String, Object> x0$8) {
                Tuple2<String, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    Object object = this.sslProps$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sslProps$1 = sslProps$1;
            }
        });
        return sslProps;
    }

    public Properties saslConfigs(Option<Properties> saslProperties) {
        Option<Properties> option;
        block4: {
            Properties properties;
            block3: {
                block2: {
                    Properties properties2;
                    option = saslProperties;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    properties = properties2 = (Properties)some.x();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Properties> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                properties = new Properties();
            }
            return properties;
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public X509TrustManager trustAllCerts() {
        void var1_1;
        X509TrustManager trustManager = new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        return var1_1;
    }

    public boolean waitAndVerifyAcls(Set<Acl> expected, Authorizer authorizer, Resource resource) {
        return this.waitUntilTrue((Function0<Object>)new Serializable(expected, authorizer, resource){
            public static final long serialVersionUID = 0L;
            private final Set expected$1;
            private final Authorizer authorizer$1;
            private final Resource resource$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set set = this.authorizer$1.getAcls(this.resource$1);
                Set set2 = this.expected$1;
                return !(set != null ? !set.equals(set2) : set2 != null);
            }
            {
                this.expected$1 = expected$1;
                this.authorizer$1 = authorizer$1;
                this.resource$1 = resource$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected acls ", " but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, authorizer.getAcls(resource)})), 10000L);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void assertConcurrent(String message, Seq<Function0<Object>> functions, int timeoutMs) {
        ArrayBuffer exceptions;
        block7: {
            ArrayBuffer arrayBuffer;
            int numThreads = functions.size();
            ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
            exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            try {
                java.util.List runnables = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)functions.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Function0<Object> function) {
                        return new Callable<BoxedUnit>(this, function){
                            private final Function0 function$1;

                            public void call() {
                                this.function$1.apply();
                            }
                            {
                                this.function$1 = function$1;
                            }
                        };
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava();
                Buffer futures = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(threadPool.invokeAll(runnables, timeoutMs, TimeUnit.MILLISECONDS)).asScala();
                futures.foreach((Function1)new Serializable(message, timeoutMs, exceptions){
                    public static final long serialVersionUID = 0L;
                    private final String message$2;
                    private final int timeoutMs$1;
                    private final ArrayBuffer exceptions$1;

                    public final Object apply(Future<BoxedUnit> future) {
                        BoxedUnit boxedUnit;
                        if (future.isCancelled()) {
                            TestUtils$.MODULE$.kafka$utils$TestUtils$$failWithTimeout$1(this.message$2, this.timeoutMs$1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            try {
                                boxedUnit = future.get();
                            }
                            catch (Exception exception) {
                                boxedUnit = this.exceptions$1.$plus$eq((Object)exception);
                            }
                        }
                        return boxedUnit;
                    }
                    {
                        this.message$2 = message$2;
                        this.timeoutMs$1 = timeoutMs$1;
                        this.exceptions$1 = exceptions$1;
                    }
                });
                arrayBuffer = BoxedUnit.UNIT;
                threadPool.shutdownNow();
                break block7;
            }
            catch (Throwable throwable) {
                arrayBuffer = exceptions.$plus$eq((Object)throwable);
                break block7;
                catch (InterruptedException interruptedException) {
                    this.kafka$utils$TestUtils$$failWithTimeout$1(message, timeoutMs);
                    arrayBuffer = BoxedUnit.UNIT;
                }
                finally {
                    threadPool.shutdownNow();
                }
            }
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed with exception(s) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, exceptions})), (boolean)exceptions.isEmpty());
    }

    private final boolean shouldEnable$1(SecurityProtocol protocol, Option interBrokerSecurityProtocol$2) {
        return BoxesRunTime.unboxToBoolean((Object)interBrokerSecurityProtocol$2.fold((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, (Function1)new Serializable(protocol){
            public static final long serialVersionUID = 0L;
            private final SecurityProtocol protocol$2;

            public final boolean apply(SecurityProtocol x$2) {
                SecurityProtocol securityProtocol = x$2;
                SecurityProtocol securityProtocol2 = this.protocol$2;
                return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
            }
            {
                this.protocol$2 = protocol$2;
            }
        }));
    }

    public final void kafka$utils$TestUtils$$failWithTimeout$1(String message$2, int timeoutMs$1) {
        Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Timed out, the concurrent functions took more than ", " milliseconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message$2, BoxesRunTime.boxToInteger((int)timeoutMs$1)})));
    }

    private TestUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.IoTmpDir = System.getProperty("java.io.tmpdir");
        this.Letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        this.Digits = "0123456789";
        this.LettersAndDigits = new StringBuilder().append((Object)this.Letters()).append((Object)this.Digits()).toString();
        this.seededRandom = new Random(192348092834L);
        this.random = new Random();
        this.RandomPort = 0;
        this.MockZkPort = 1;
        this.MockZkConnect = new StringBuilder().append((Object)"127.0.0.1:").append((Object)BoxesRunTime.boxToInteger((int)this.MockZkPort())).toString();
    }
}

