/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.IOException;
import kafka.common.KafkaStorageException;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u000f\r&dW-T3tg\u0006<WmU3u\u0011!Y\u0002A!A!\u0002\u00131\u0012\u0001\u00027pO\u0002B\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0006S:$W\r_\u000b\u0002?A\u0011q\u0003I\u0005\u0003C\t\u00111b\u00144gg\u0016$\u0018J\u001c3fq\"A1\u0005\u0001B\u0001B\u0003%q$\u0001\u0004j]\u0012,\u0007\u0010\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005IA/[7f\u0013:$W\r_\u000b\u0002OA\u0011q\u0003K\u0005\u0003S\t\u0011\u0011\u0002V5nK&sG-\u001a=\t\u0011-\u0002!\u0011!Q\u0001\n\u001d\n!\u0002^5nK&sG-\u001a=!\u0011!i\u0003A!b\u0001\n\u0003q\u0013A\u00032bg\u0016|eMZ:fiV\tq\u0006\u0005\u0002\na%\u0011\u0011G\u0003\u0002\u0005\u0019>tw\r\u0003\u00054\u0001\t\u0005\t\u0015!\u00030\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\t\u0011U\u0002!Q1A\u0005\u0002Y\n!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgV\tq\u0007\u0005\u0002\nq%\u0011\u0011H\u0003\u0002\u0004\u0013:$\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002'%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\u0011\t\u0011u\u0002!Q1A\u0005\u00029\nAB]8mY*KG\u000f^3s\u001bND\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IaL\u0001\u000ee>dGNS5ui\u0016\u0014Xj\u001d\u0011\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000bA\u0001^5nKB\u0011qbQ\u0005\u0003\tB\u0011A\u0001V5nK\")a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"\u0002\u0002S%K\u00172kej\u0014\t\u0003/\u0001AQaA#A\u0002YAQ!H#A\u0002}AQ!J#A\u0002\u001dBQ!L#A\u0002=BQ!N#A\u0002]BQ!P#A\u0002=BQ!Q#A\u0002\tCq!\u0015\u0001A\u0002\u0013\u0005a&A\u0004de\u0016\fG/\u001a3\t\u000fM\u0003\u0001\u0019!C\u0001)\u0006Y1M]3bi\u0016$w\fJ3r)\t)\u0006\f\u0005\u0002\n-&\u0011qK\u0003\u0002\u0005+:LG\u000fC\u0004Z%\u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0013\u0007\u0003\u0004\\\u0001\u0001\u0006KaL\u0001\tGJ,\u0017\r^3eA!9Q\f\u0001a\u0001\n\u00131\u0014\u0001\u00072zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss\"9q\f\u0001a\u0001\n\u0013\u0001\u0017\u0001\b2zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss~#S-\u001d\u000b\u0003+\u0006Dq!\u00170\u0002\u0002\u0003\u0007q\u0007\u0003\u0004d\u0001\u0001\u0006KaN\u0001\u001aEf$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJL\b\u0005C\u0004f\u0001\u0001\u0007I\u0011\u00024\u0002+I|G\u000e\\5oO\n\u000b7/\u001a3US6,7\u000f^1naV\tq\rE\u0002\nQ>J!!\u001b\u0006\u0003\r=\u0003H/[8o\u0011\u001dY\u0007\u00011A\u0005\n1\f\u0011D]8mY&twMQ1tK\u0012$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0011Q+\u001c\u0005\b3*\f\t\u00111\u0001h\u0011\u0019y\u0007\u0001)Q\u0005O\u00061\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004\b\u0005C\u0004r\u0001\u0001\u0007I\u0011\u0002\u0018\u0002#5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'\u000fC\u0004t\u0001\u0001\u0007I\u0011\u0002;\u0002+5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'o\u0018\u0013fcR\u0011Q+\u001e\u0005\b3J\f\t\u00111\u00010\u0011\u00199\b\u0001)Q\u0005_\u0005\u0011R.\u0019=US6,7\u000f^1naN{g)\u0019:!Q\t1\u0018\u0010\u0005\u0002\nu&\u00111P\u0003\u0002\tm>d\u0017\r^5mK\"9Q\u0010\u0001a\u0001\n\u0013q\u0013\u0001F8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0000\u0001\u0001\u0007I\u0011BA\u0001\u0003aygMZ:fi>3W*\u0019=US6,7\u000f^1na~#S-\u001d\u000b\u0004+\u0006\r\u0001bB-\u007f\u0003\u0003\u0005\ra\f\u0005\b\u0003\u000f\u0001\u0001\u0015)\u00030\u0003UygMZ:fi>3W*\u0019=US6,7\u000f^1na\u0002B3!!\u0002z\u0011\u00191\u0005\u0001\"\u0001\u0002\u000eQ\u0019\u0002*a\u0004\u0002$\u0005\u001d\u0012\u0011FA\u0017\u0003_\t\t$a\u000f\u0002@!A\u0011\u0011CA\u0006\u0001\u0004\t\u0019\"A\u0002eSJ\u0004B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0002j_*\u0011\u0011QD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\"\u0005]!\u0001\u0002$jY\u0016Dq!!\n\u0002\f\u0001\u0007q&A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bBB\u001b\u0002\f\u0001\u0007q\u0007C\u0004\u0002,\u0005-\u0001\u0019A\u001c\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\t\ru\nY\u00011\u00010\u0011\u0019\t\u00151\u0002a\u0001\u0005\"Q\u00111GA\u0006!\u0003\u0005\r!!\u000e\u0002#\u0019LG.Z!me\u0016\fG-_#ySN$8\u000fE\u0002\n\u0003oI1!!\u000f\u000b\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0010\u0002\fA\u0005\t\u0019A\u001c\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u0015\u0005\u0005\u00131\u0002I\u0001\u0002\u0004\t)$A\u0006qe\u0016\fG\u000e\\8dCR,\u0007BBA#\u0001\u0011\u0005a&\u0001\u0003tSj,\u0007bBA%\u0001\u0011\u0005\u00111J\u0001\u0007CB\u0004XM\u001c3\u0015\u0013U\u000bi%!\u0015\u0002V\u0005e\u0003bBA(\u0003\u000f\u0002\raL\u0001\fM&\u00148\u000f^(gMN,G\u000fC\u0004\u0002T\u0005\u001d\u0003\u0019A\u0018\u0002!1\f'oZ3tiRKW.Z:uC6\u0004\bbBA,\u0003\u000f\u0002\raL\u0001\u0019_\u001a47/\u001a;PM2\u000b'oZ3tiRKW.Z:uC6\u0004\b\u0002CA.\u0003\u000f\u0002\r!!\u0018\u0002\u00115,7o]1hKN\u0004B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G\"\u0011aB7fgN\fw-Z\u0005\u0005\u0003O\n\tG\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0015\u0005\u0003\u000f\nY\u0007E\u0002\u0010\u0003[J1!a\u001c\u0011\u00055qwN\u001c;ie\u0016\fGm]1gK\"A\u00111\u000f\u0001\u0005\u0002\t\t)(A\bue\u0006t7\u000f\\1uK>3gm]3u)\u0019\t9(a!\u0002\bB1\u0011\"!\u001f\u0002~]J1!a\u001f\u000b\u0005\u0019!V\u000f\u001d7feA\u0019q#a \n\u0007\u0005\u0005%A\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000f\u0005\u0015\u0015\u0011\u000fa\u0001_\u00051qN\u001a4tKRD\u0011\"!#\u0002rA\u0005\t\u0019A\u001c\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\u0011\t\t(!$\u0011\u0007=\ty)C\u0002\u0002\u0012B\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u0011\u001d\t)\n\u0001C\u0001\u0003/\u000bAA]3bIRa\u0011\u0011TAS\u0003O\u000bY+a,\u00024B!\u00111TAQ\u001b\t\tiJC\u0002\u0002 \u0012\taa]3sm\u0016\u0014\u0018\u0002BAR\u0003;\u0013QBR3uG\"$\u0015\r^1J]\u001a|\u0007bBA\u0013\u0003'\u0003\ra\f\u0005\b\u0003S\u000b\u0019\n1\u0001h\u0003%i\u0017\r_(gMN,G\u000fC\u0004\u0002.\u0006M\u0005\u0019A\u001c\u0002\u000f5\f\u0007pU5{K\"I\u0011\u0011WAJ!\u0003\u0005\raL\u0001\f[\u0006D\bk\\:ji&|g\u000e\u0003\u0006\u00026\u0006M\u0005\u0013!a\u0001\u0003k\tQ\"\\5o\u001f:,W*Z:tC\u001e,\u0007\u0006BAJ\u0003\u001bCq!a/\u0001\t\u0003\ti,A\u0004sK\u000e|g/\u001a:\u0015\u0007]\ny\fC\u0004\u0002B\u0006e\u0006\u0019A\u001c\u0002\u001d5\f\u00070T3tg\u0006<WmU5{K\"\"\u0011\u0011XA6\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013\fA\u0003\\8bI2\u000b'oZ3tiRKW.Z:uC6\u0004HcA+\u0002L\"Q\u0011QZAc!\u0003\u0005\r!!\u000e\u0002\u0019I,\u0017\r\u001a+p\u0019><WI\u001c3\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\u0006AAo\\*ue&tw\r\u0006\u0002\u0002VB!\u0011q[Ao\u001b\t\tIN\u0003\u0003\u0002\\\u0006m\u0011\u0001\u00027b]\u001eLA!a8\u0002Z\n11\u000b\u001e:j]\u001eDq!a9\u0001\t\u0003\t)/\u0001\u0006ueVt7-\u0019;f)>$2aNAt\u0011\u001d\t))!9A\u0002=BC!!9\u0002l!9\u0011Q\u001e\u0001\u0005\u0002\u0005=\u0018A\u00038fqR|eMZ:fiR\tq\u0006\u000b\u0003\u0002l\u00065\u0005bBA{\u0001\u0011\u0005\u0011q_\u0001\u0006M2,8\u000f\u001b\u000b\u0002+\"\"\u00111_AG\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u007f\f!c\u00195b]\u001e,g)\u001b7f'V4g-\u001b=fgR)QK!\u0001\u0003\u0012!A!1AA~\u0001\u0004\u0011)!A\u0005pY\u0012\u001cVO\u001a4jqB!!q\u0001B\u0007\u001d\rI!\u0011B\u0005\u0004\u0005\u0017Q\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002`\n=!b\u0001B\u0006\u0015!A!1CA~\u0001\u0004\u0011)!A\u0005oK^\u001cVO\u001a4jq\"9!q\u0003\u0001\u0005\u0002\u0005]\u0018aF8o\u0005\u0016\u001cw.\\3J]\u0006\u001cG/\u001b<f'\u0016<W.\u001a8u\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;\t\u0011\u0003^5nK^\u000b\u0017\u000e^3e\r>\u0014(k\u001c7m)\u0015y#q\u0004B\u0012\u0011\u001d\u0011\tC!\u0007A\u0002=\n1A\\8x\u0011\u001d\u0011)C!\u0007A\u0002=\n\u0001#\\3tg\u0006<W\rV5nKN$\u0018-\u001c9\t\u000f\t%\u0002\u0001\"\u0001\u0003,\u0005)b-\u001b8e\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004H\u0003\u0002B\u0017\u0005k\u0001B!\u00035\u00030A\u0019qC!\r\n\u0007\tM\"AA\bUS6,7\u000f^1na>3gm]3u\u0011\u001d\u00119Da\nA\u0002=\n\u0011\u0002^5nKN$\u0018-\u001c9\t\u000f\tm\u0002\u0001\"\u0001\u0002x\u0006)1\r\\8tK\"9!q\b\u0001\u0005\u0002\u0005]\u0018A\u00023fY\u0016$X\r\u0003\u0004\u0003D\u0001!\tAL\u0001\rY\u0006\u001cH/T8eS\u001aLW\r\u001a\u0005\u0007\u0003'\u0002A\u0011\u0001\u0018\t\u000f\t%\u0003\u0001\"\u0001\u0003L\u0005\u0001B.Y:u\u001b>$\u0017NZ5fI~#S-\u001d\u000b\u0005\u0003k\u0011i\u0005C\u0004\u0003P\t\u001d\u0003\u0019A\u0018\u0002\u00055\u001c\b\"\u0003B*\u0001E\u0005I\u0011\u0001B+\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIQ*\"Aa\u0016+\u0007=\u0012If\u000b\u0002\u0003\\A!!Q\fB4\u001b\t\u0011yF\u0003\u0003\u0003b\t\r\u0014!C;oG\",7m[3e\u0015\r\u0011)GC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B5\u0005?\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011i\u0007AI\u0001\n\u0003\u0011y'\u0001\bsK\u0006$G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tE$\u0006BA\u001b\u00053B\u0011B!\u001e\u0001#\u0003%\tAa\u001e\u00023Q\u0014\u0018M\\:mCR,wJ\u001a4tKR$C-\u001a4bk2$HEM\u000b\u0003\u0005sR3a\u000eB-\u0011%\u0011i\bAI\u0001\n\u0003\u0011y'\u0001\u0010m_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e\u001d\u0013eK\u001a\fW\u000f\u001c;%c!\u001a\u0001!a\u001b\b\u0013\t\r%!!A\t\u0002\t\u0015\u0015A\u0003'pON+w-\\3oiB\u0019qCa\"\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005\u0013\u001b2Aa\"\t\u0011\u001d1%q\u0011C\u0001\u0005\u001b#\"A!\"\t\u0015\tE%qQI\u0001\n\u0003\u0011y'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\u000e\u0005\u000b\u0005+\u00139)%A\u0005\u0002\t]\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003\b\u0003\u0006\u0003\u001a\n\u001d\u0015\u0013!C\u0001\u0005_\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012J\u0004")
public class LogSegment
implements Logging {
    private final FileMessageSet log;
    private final OffsetIndex index;
    private final TimeIndex timeIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private Option<Object> rollingBasedTimestamp;
    private volatile long kafka$log$LogSegment$$maxTimestampSoFar;
    private volatile long kafka$log$LogSegment$$offsetOfMaxTimestamp;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$9() {
        return LogSegment$.MODULE$.$lessinit$greater$default$9();
    }

    public static int $lessinit$greater$default$8() {
        return LogSegment$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$7() {
        return LogSegment$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileMessageSet log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public TimeIndex timeIndex() {
        return this.timeIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public long created() {
        return this.created;
    }

    public void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    public long kafka$log$LogSegment$$maxTimestampSoFar() {
        return this.kafka$log$LogSegment$$maxTimestampSoFar;
    }

    private void kafka$log$LogSegment$$maxTimestampSoFar_$eq(long x$1) {
        this.kafka$log$LogSegment$$maxTimestampSoFar = x$1;
    }

    public long kafka$log$LogSegment$$offsetOfMaxTimestamp() {
        return this.kafka$log$LogSegment$$offsetOfMaxTimestamp;
    }

    private void kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(long x$1) {
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp = x$1;
    }

    public long size() {
        return this.log().sizeInBytes();
    }

    public void append(long firstOffset, long largestTimestamp, long offsetOfLargestTimestamp, ByteBufferMessageSet messages) {
        if (messages.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, firstOffset, largestTimestamp, offsetOfLargestTimestamp, messages){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long firstOffset$1;
                private final long largestTimestamp$1;
                private final long offsetOfLargestTimestamp$1;
                private final ByteBufferMessageSet messages$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d with largest timestamp %d at offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.firstOffset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes()), BoxesRunTime.boxToLong((long)this.largestTimestamp$1), BoxesRunTime.boxToLong((long)this.offsetOfLargestTimestamp$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.firstOffset$1 = firstOffset$1;
                    this.largestTimestamp$1 = largestTimestamp$1;
                    this.offsetOfLargestTimestamp$1 = offsetOfLargestTimestamp$1;
                    this.messages$1 = messages$1;
                }
            });
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.log().append(messages);
            if (largestTimestamp > this.kafka$log$LogSegment$$maxTimestampSoFar()) {
                this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(largestTimestamp);
                this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(offsetOfLargestTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(firstOffset, physicalPosition);
                this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + messages.sizeInBytes());
        }
    }

    public Tuple2<OffsetPosition, Object> translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        Tuple2<OffsetPosition, Object> tuple2;
        block7: {
            Option<Object> option;
            block10: {
                int n;
                int adjustedMaxSize;
                LogOffsetMetadata offsetMetadata;
                int messageSetSize2;
                OffsetPosition startPosition;
                block9: {
                    int logSize;
                    block8: {
                        Tuple2 tuple22;
                        if (maxSize < 0) {
                            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
                        }
                        logSize = this.log().sizeInBytes();
                        Tuple2<OffsetPosition, Object> startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
                        if (startOffsetAndSize == null) {
                            return null;
                        }
                        tuple2 = startOffsetAndSize;
                        if (tuple2 == null) break block7;
                        OffsetPosition startPosition2 = (OffsetPosition)tuple2._1();
                        int messageSetSize3 = tuple2._2$mcI$sp();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)startPosition2, (Object)BoxesRunTime.boxToInteger((int)messageSetSize3));
                        startPosition = (OffsetPosition)tuple23._1();
                        messageSetSize2 = tuple23._2$mcI$sp();
                        offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition.position());
                        int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, messageSetSize2) : maxSize;
                        if (adjustedMaxSize == 0) {
                            return new FetchDataInfo(offsetMetadata, MessageSet$.MODULE$.Empty(), FetchDataInfo$.MODULE$.apply$default$3());
                        }
                        option = maxOffset;
                        None$ none$ = None$.MODULE$;
                        Option<Object> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                        n = package$.MODULE$.min((int)(maxPosition - (long)startPosition.position()), adjustedMaxSize);
                        break block9;
                    }
                    if (!(option instanceof Some)) break block10;
                    Some some = (Some)option;
                    long offset = BoxesRunTime.unboxToLong((Object)some.x());
                    if (offset < startOffset) {
                        return new FetchDataInfo(offsetMetadata, MessageSet$.MODULE$.Empty(), false);
                    }
                    Tuple2<OffsetPosition, Object> mapping = this.translateOffset(offset, startPosition.position());
                    int endPosition = mapping == null ? logSize : ((OffsetPosition)mapping._1()).position();
                    n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition.position(), (long)adjustedMaxSize);
                }
                int length = n;
                return new FetchDataInfo(offsetMetadata, this.log().read(startPosition.position(), length), adjustedMaxSize < messageSetSize2);
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple2);
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public int recover(int maxMessageSize) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        this.timeIndex().truncate();
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int validBytes = 0;
        int lastIndexEntry = 0;
        Iterator<MessageAndOffset> iter = this.log().iterator(maxMessageSize);
        this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(Message$.MODULE$.NoTimestamp());
        try {
            while (iter.hasNext()) {
                MessageAndOffset entry2 = (MessageAndOffset)iter.next();
                entry2.message().ensureValid();
                if (entry2.message().timestamp() > this.kafka$log$LogSegment$$maxTimestampSoFar()) {
                    this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(entry2.message().timestamp());
                    this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(entry2.offset());
                }
                if (validBytes - lastIndexEntry > this.indexIntervalBytes()) {
                    long startOffset = entry2.firstOffset();
                    this.index().append(startOffset, validBytes);
                    this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                    lastIndexEntry = validBytes;
                }
                validBytes += MessageSet$.MODULE$.entrySize(entry2.message());
            }
        }
        catch (CorruptRecordException corruptRecordException) {
            this.logger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes), corruptRecordException.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes;
        this.log().truncateTo(validBytes);
        this.index().trimToValidSize();
        this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public void loadLargestTimestamp(boolean readToLogEnd) {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(lastTimeIndexEntry.offset());
        if (readToLogEnd) {
            OffsetPosition offsetPosition = this.index().lookup(lastTimeIndexEntry.offset());
            TimestampOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
            if (maxTimestampOffsetAfterLastEntry.timestamp() > lastTimeIndexEntry.timestamp()) {
                this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp());
                this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(maxTimestampOffsetAfterLastEntry.offset());
            }
        }
    }

    public boolean loadLargestTimestamp$default$1() {
        return false;
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset) {
        Tuple2<OffsetPosition, Object> mapping = this.translateOffset(offset, this.translateOffset$default$2());
        if (mapping == null) {
            return 0;
        }
        this.index().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.index().resize(this.index().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        Tuple2<OffsetPosition, Object> tuple2 = mapping;
        if (tuple2 != null) {
            OffsetPosition offsetPosition;
            OffsetPosition offsetPosition2;
            OffsetPosition offsetPosition3 = offsetPosition2 = (offsetPosition = (OffsetPosition)tuple2._1());
            int bytesTruncated = this.log().truncateTo(offsetPosition3.position());
            if (this.log().sizeInBytes() == 0) {
                this.created_$eq(this.time.milliseconds());
                this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
            }
            this.bytesSinceLastIndexEntry_$eq(0);
            if (this.kafka$log$LogSegment$$maxTimestampSoFar() >= 0L) {
                this.loadLargestTimestamp(true);
            }
            return bytesTruncated;
        }
        throw new MatchError(tuple2);
    }

    public long nextOffset() {
        Option<MessageAndOffset> option;
        block6: {
            long l;
            block3: {
                long l2;
                block5: {
                    block4: {
                        FetchDataInfo ms;
                        block2: {
                            ms = this.read(this.index().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
                            if (ms != null) break block2;
                            l = this.baseOffset();
                            break block3;
                        }
                        option = ms.messageSet().lastOption();
                        None$ none$ = None$.MODULE$;
                        Option<MessageAndOffset> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        l2 = this.baseOffset();
                        break block5;
                    }
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    MessageAndOffset last = (MessageAndOffset)some.x();
                    l2 = last.nextOffset();
                }
                l = l2;
            }
            return l;
        }
        throw new MatchError(option);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.index().flush();
                this.$outer.timeIndex().flush();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        try {
            this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("log", iOException, oldSuffix, newSuffix);
        }
        try {
            this.index().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("index", iOException, oldSuffix, newSuffix);
        }
        try {
            this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.timeIndex().file().getPath(), oldSuffix, newSuffix)));
            return;
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("timeindex", iOException, oldSuffix, newSuffix);
        }
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        Option<Object> option;
        Iterator<MessageAndOffset> iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((MessageAndOffset)iter.next()).message().timestamp())));
        }
        long l = (option = this.rollingBasedTimestamp()) instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).x())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public Option<TimestampOffset> findOffsetByTimestamp(long timestamp2) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp2);
        int position = this.index().lookup(timestampOffset.offset()).position();
        return this.log().searchForTimestamp(timestamp2, position);
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().maybeAppend(this.$outer.kafka$log$LogSegment$$maxTimestampSoFar(), this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        boolean deletedTimeIndex = this.timeIndex().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of log ").append((Object)this.log().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of index ").append((Object)this.index().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedTimeIndex && this.timeIndex().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of time index ").append((Object)this.timeIndex().file().getName()).append((Object)" failed.").toString());
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.kafka$log$LogSegment$$maxTimestampSoFar() >= 0L ? this.kafka$log$LogSegment$$maxTimestampSoFar() : this.lastModified();
    }

    public boolean lastModified_$eq(long ms) {
        this.log().file().setLastModified(ms);
        this.index().file().setLastModified(ms);
        return this.timeIndex().file().setLastModified(ms);
    }

    private final KafkaStorageException kafkaStorageException$1(String fileType, IOException e, String oldSuffix$1, String newSuffix$1) {
        return new KafkaStorageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to change the ", " file suffix from ", " to ", " for log segment ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, oldSuffix$1, newSuffix$1, BoxesRunTime.boxToLong((long)this.baseOffset())})), e);
    }

    public LogSegment(FileMessageSet log, OffsetIndex index, TimeIndex timeIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.index = index;
        this.timeIndex = timeIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.kafka$log$LogSegment$$maxTimestampSoFar = timeIndex.lastEntry().timestamp();
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp = timeIndex.lastEntry().offset();
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, long rollJitterMs, Time time, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(dir, startOffset), fileAlreadyExists, initFileSize, preallocate), new OffsetIndex(Log$.MODULE$.indexFilename(dir, startOffset), startOffset, maxIndexSize), new TimeIndex(Log$.MODULE$.timeIndexFilename(dir, startOffset), startOffset, maxIndexSize), startOffset, indexIntervalBytes, rollJitterMs, time);
    }
}

