/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminUtilities;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.TestAdminUtils;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.log4j.Logger;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001\u001d\u0011QDU3bgNLwM\u001c)beRLG/[8og\u000e{W.\\1oIR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001\u0001\u0019!C\u00017\u0005)1-\u00197mgV\tA\u0004\u0005\u0002\n;%\u0011aD\u0003\u0002\u0004\u0013:$\bb\u0002\u0011\u0001\u0001\u0004%\t!I\u0001\nG\u0006dGn]0%KF$\"AI\u0013\u0011\u0005%\u0019\u0013B\u0001\u0013\u000b\u0005\u0011)f.\u001b;\t\u000f\u0019z\u0012\u0011!a\u00019\u0005\u0019\u0001\u0010J\u0019\t\r!\u0002\u0001\u0015)\u0003\u001d\u0003\u0019\u0019\u0017\r\u001c7tA!)!\u0006\u0001C\u0001W\u0005A2\u000f[8vY\u00124\u0015N\u001c3N_ZLgn\u001a*fa2L7-Y:\u0015\u0003\tB#!K\u0017\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014!\u00026v]&$(\"\u0001\u001a\u0002\u0007=\u0014x-\u0003\u00025_\t!A+Z:u\u0011\u00151\u0004\u0001\"\u0001,\u0003Y\u001a\bn\\;mI\u001aKg\u000eZ'pm&twMU3qY&\u001c\u0017m],iK:\u0004&o\u001c9pg\u0016$\u0017j]*vEN,Go\u00144Fq&\u001cH/\u001b8hQ\t)T\u0006C\u0003:\u0001\u0011\u00051&\u0001\u0016tQ>,H\u000e\u001a$j]\u0012luN^5oOJ+\u0007\u000f\\5dCNlU\u000f\u001c;ja2,\u0007+\u0019:uSRLwN\\:)\u0005aj\u0003\"\u0002\u001f\u0001\t\u0003Y\u0013AJ:i_VdGMR5oI6{g/\u001b8h%\u0016\u0004H.[2bg6+H\u000e^5qY\u0016$v\u000e]5dg\"\u00121(\f\u0005\u0006\u007f\u0001!\taK\u00014g\"|W\u000f\u001c3GS:$Wj\u001c<j]\u001e\u0014V\r\u001d7jG\u0006\u001cX*\u001e7uSBdW\rV8qS\u000e\u001c\u0018I\u001c3QCJ$\u0018\u000e^5p]ND#AP\u0017\t\u000b\t\u0003A\u0011A\u0016\u0002UMDw.\u001e7e\r&tG\rV<p\u001b>4\u0018N\\4SKBd\u0017nY1t\u0013:\u001c\u0016-\\3QCJ$\u0018\u000e^5p]\"\u0012\u0011)\f\u0005\u0006\u000b\u0002!\taK\u0001=g\"|W\u000f\u001c3O_R|e/\u001a:xe&$X-\u00128uSRL8i\u001c8gS\u001e\u001cx\u000b[3o+B$\u0017\r^5oORC'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7\u000f\u000b\u0002E[!)\u0001\n\u0001C\u0001W\u0005\u00192\u000f[8vY\u0012\u001cV\r^)v_R\fG*[7ji\"\u0012q)\f\u0005\u0006\u0017\u0002!\taK\u0001\u0017g\"|W\u000f\u001c3Va\u0012\fG/Z)v_R\fG*[7ji\"\u0012!*\f\u0005\u0006\u001d\u0002!\taK\u00015g\"|W\u000f\u001c3O_R|e/\u001a:xe&$X-\u0012=jgRLgn\u001a)s_B,'\u000f^5fg^CWM\u001c'j[&$\u0018j]!eI\u0016$\u0007FA'.\u0011\u0015\t\u0006\u0001\"\u0001,\u0003\u001d\u001a\bn\\;mIJ+Wn\u001c<f)\"\u0014x\u000e\u001e;mK2KW.\u001b;Ge>l\u0017\t\u001c7Ce>\\WM]:)\u0005Ak\u0003\"\u0002+\u0001\t\u0003Y\u0013\u0001O:i_VdGMU3n_Z,G\u000b\u001b:piRdWMU3qY&\u001c\u0017\rT5ti\n\u000b7/\u001a3P]B\u0013x\u000e]8tK\u0012\f5o]5h]6,g\u000e\u001e\u0015\u0003'6BQa\u0016\u0001\u0005\u0002a\u000b!![:\u0016\u0005ecFC\u0001.f!\tYF\f\u0004\u0001\u0005\u000bu3&\u0019\u00010\u0003\u0003Q\u000b\"a\u00182\u0011\u0005%\u0001\u0017BA1\u000b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!C2\n\u0005\u0011T!aA!os\")aM\u0016a\u00015\u0006\ta\u000fC\u0003i\u0001\u0011\u00051&A\u0003tKR,\b\u000f\u000b\u0002hUB\u0011af[\u0005\u0003Y>\u0012aAQ3g_J,\u0007\"\u00028\u0001\t\u0003y\u0017AB:uk\nT6\n\u0006\u0003qg\u0006=\u0001CA\br\u0013\t\u0011\bCA\u0004[WV#\u0018\u000e\\:\t\u000fQl\u0007\u0013!a\u0001k\u0006\u0011R\r_5ti&tw-Q:tS\u001etW.\u001a8u!\u0015180`A\u0004\u001b\u00059(B\u0001=z\u0003\u001diW\u000f^1cY\u0016T!A\u001f\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002}o\n\u0019Q*\u00199\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t\u0001B\u0001\u0007G>lWn\u001c8\n\u0007\u0005\u0015qPA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004R!!\u0003\u0002\fqi\u0011!_\u0005\u0004\u0003\u001bI(aA*fc\"I\u0011\u0011C7\u0011\u0002\u0003\u0007\u0011qA\u0001\bEJ|7.\u001a:t\u0011%\t)\u0002AI\u0001\n\u0003\t9\"\u0001\ttiV\u0014'l\u0013\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0004\u0016\u0004k\u0006m1FAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\"\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u000b\u0002\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005=\u0002!%A\u0005\u0002\u0005E\u0012\u0001E:uk\nT6\n\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019D\u000b\u0003\u0002\b\u0005m\u0001")
public class ReassignPartitionsCommandTest
implements Logging {
    private int calls;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommandTest reassignPartitionsCommandTest = this;
        synchronized (reassignPartitionsCommandTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int calls() {
        return this.calls;
    }

    public void calls_$eq(int x$1) {
        this.calls = x$1;
    }

    @Test
    public void shouldFindMovingReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"0:102", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                Assert.assertEquals((Object)"0:100,0:101", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasWhenProposedIsSubsetOfExisting() {
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        scala.collection.immutable.Map existingSuperset = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic3", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})))}));
        scala.collection.immutable.Map proposedSubset = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})))}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"0:102,2:102", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                Assert.assertEquals((Object)"0:100,0:101,2:100,2:101", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                Assert.assertEquals((Object)"topic1", (Object)topic);
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existingSuperset, (Map)proposedSubset, (AdminUtilities)mock);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultiplePartitions() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"0:102,1:102", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                Assert.assertEquals((Object)"0:100,0:101,1:100,1:101", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopics() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), control}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                String string;
                String string2 = string = topic;
                if (!("topic1" != null ? !"topic1".equals(string2) : string2 != null)) {
                    Assert.assertEquals((Object)"0:100,0:101", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                    Assert.assertEquals((Object)"0:102", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string3 = string;
                    if (!("topic2" != null ? !"topic2".equals(string3) : string3 != null)) {
                        Assert.assertEquals((Object)"0:101,0:102", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                        Assert.assertEquals((Object)"0:100", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Assert.fail((String)"Unexpected topic $topic");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopicsAndPartitions() {
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100})))}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                String string;
                String string2 = string = topic;
                if (!("topic1" != null ? !"topic1".equals(string2) : string2 != null)) {
                    Assert.assertEquals((Object)"0:102,1:102", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                    Assert.assertEquals((Object)"0:100,0:101,1:100,1:101", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string3 = string;
                    if (!("topic2" != null ? !"topic2".equals(string3) : string3 != null)) {
                        Assert.assertEquals((Object)"0:100,1:100", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                        Assert.assertEquals((Object)"0:101,0:102,1:101,1:102", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindTwoMovingReplicasInSamePartition() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102, 103}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 104, 105}))), control}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"0:104,0:105", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                Assert.assertEquals((Object)"0:100,0:101,0:102,0:103", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldNotOverwriteEntityConfigsWhenUpdatingThrottledReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null, ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        Properties existingProperties = CoreUtils$.MODULE$.propsWith("some-key", "some-value");
        TestAdminUtils mock = new TestAdminUtils(this, existingProperties){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;
            private final Properties existingProperties$1;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"some-value", (Object)configChange.getProperty("some-key"));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entityName) {
                return this.existingProperties$1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.existingProperties$1 = existingProperties$1;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldSetQuotaLimit() {
        scala.collection.mutable.Map existing = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        ZkUtils zk = this.stubZK((scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>)existing, this.stubZK$default$2());
        AdminUtilities admin = (AdminUtilities)EasyMock.createMock(AdminUtilities.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Map)proposed, admin);
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), EasyMock.anyString(), EasyMock.anyString())).andStubReturn((Object)new Properties());
        admin.changeBrokerConfig(this.is(zk), (Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(1000L);
        JavaConversions$.MODULE$.asScalaBuffer(propsCapture.getValues()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties actual) {
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
            }
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldUpdateQuotaLimit() {
        scala.collection.mutable.Map existing = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        ZkUtils zk = this.stubZK((scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>)existing, this.stubZK$default$2());
        AdminUtilities admin = (AdminUtilities)EasyMock.createMock(AdminUtilities.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Map)proposed, admin);
        admin.changeBrokerConfig(this.is(zk), (Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        Properties existingConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)"10"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"100")}));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Broker()), this.is("100"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Broker()), this.is("101"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Broker()), this.is("102"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(1000L);
        JavaConversions$.MODULE$.asScalaBuffer(propsCapture.getValues()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties actual) {
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
            }
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldNotOverwriteExistingPropertiesWhenLimitIsAdded() {
        scala.collection.mutable.Map existing = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        ZkUtils zk = this.stubZK((scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>)existing, this.stubZK$default$2());
        AdminUtilities admin = (AdminUtilities)EasyMock.createMock(AdminUtilities.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(zk, (Map)proposed, admin);
        admin.changeBrokerConfig(this.is(zk), (Seq)((List)EasyMock.anyObject()), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Broker()), EasyMock.anyString())).andReturn((Object)CoreUtils$.MODULE$.propsWith("useful.key", "useful.value")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{admin});
        assigner.maybeLimit(1000L);
        JavaConversions$.MODULE$.asScalaBuffer(propsCapture.getValues()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties actual) {
                Assert.assertEquals((Object)"useful.value", (Object)actual.getProperty("useful.key"));
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
                Assert.assertEquals((Object)"1000", (Object)actual.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
            }
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldRemoveThrottleLimitFromAllBrokers() {
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}));
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map status = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)ReassignmentCompleted$.MODULE$)}));
        Properties existingBrokerConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)"10"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"100"), new Tuple2((Object)"useful.key", (Object)"value")}));
        Seq x$2 = brokers;
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> x$3 = this.stubZK$default$1();
        ZkUtils zk = this.stubZK(x$3, (Seq<Object>)x$2);
        AdminUtilities admin = (AdminUtilities)EasyMock.createMock(AdminUtilities.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Topic()), EasyMock.anyString())).andStubReturn((Object)new Properties());
        admin.changeBrokerConfig(this.is(zk), (Seq)EasyMock.anyObject(), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Broker()), this.is("100"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Broker()), this.is("101"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Broker()), this.is("102"))).andReturn((Object)TestUtils$.MODULE$.copyOf(existingBrokerConfigs));
        EasyMock.replay((Object[])new Object[]{admin});
        ReassignPartitionsCommand$.MODULE$.removeThrottle(zk, (Map)proposed, (Map)status, admin);
        JavaConversions$.MODULE$.asScalaBuffer(propsCapture.getValues()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties capture) {
                Assert.assertEquals((Object)"value", (Object)capture.get("useful.key"));
                Assert.assertNull((Object)capture.get(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()));
                Assert.assertNull((Object)capture.get(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()));
            }
        });
        Assert.assertEquals((long)3L, (long)propsCapture.getValues().size());
    }

    @Test
    public void shouldRemoveThrottleReplicaListBasedOnProposedAssignment() {
        scala.collection.mutable.Map proposed = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}));
        scala.collection.mutable.Map status = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)ReassignmentCompleted$.MODULE$)}));
        Properties existingConfigs = CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"1:100:2:100"), new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)"1:101,2:101"), new Tuple2((Object)"useful.key", (Object)"value")}));
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}));
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> x$5 = this.stubZK$default$1();
        ZkUtils zk = this.stubZK(x$5, (Seq<Object>)x$4);
        AdminUtilities admin = (AdminUtilities)EasyMock.createMock(AdminUtilities.class);
        Capture propsCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Broker()), EasyMock.anyString())).andStubReturn((Object)new Properties());
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Topic()), this.is("topic1"))).andStubReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        EasyMock.expect((Object)admin.fetchEntityConfig(this.is(zk), this.is(ConfigType$.MODULE$.Topic()), this.is("topic2"))).andStubReturn((Object)TestUtils$.MODULE$.copyOf(existingConfigs));
        admin.changeTopicConfig(this.is(zk), this.is("topic1"), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        admin.changeTopicConfig(this.is(zk), this.is("topic2"), (Properties)EasyMock.capture((Capture)propsCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{admin});
        ReassignPartitionsCommand$.MODULE$.removeThrottle(zk, (Map)proposed, (Map)status, admin);
        JavaConversions$.MODULE$.asScalaBuffer(propsCapture.getValues()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Properties actual) {
                Assert.assertEquals((Object)"value", (Object)actual.getProperty("useful.key"));
                Assert.assertNull((Object)actual.getProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                Assert.assertNull((Object)actual.getProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
            }
        });
        Assert.assertEquals((long)2L, (long)propsCapture.getValues().size());
    }

    public <T> T is(T v) {
        return (T)EasyMock.eq(v);
    }

    @Before
    public void setup() {
        this.calls_$eq(0);
    }

    /*
     * WARNING - void declaration
     */
    public ZkUtils stubZK(scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> existingAssignment, Seq<Object> brokers) {
        void var3_3;
        ZkUtils zk = (ZkUtils)EasyMock.createMock(ZkUtils.class);
        EasyMock.expect((Object)zk.getReplicaAssignmentForTopics((Seq)EasyMock.anyObject())).andStubReturn(existingAssignment);
        EasyMock.expect((Object)zk.getAllBrokersInCluster()).andStubReturn(brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int x$1) {
                return TestUtils$.MODULE$.createBroker(x$1, "", 1, TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        EasyMock.replay((Object[])new Object[]{zk});
        return var3_3;
    }

    public scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> stubZK$default$1() {
        return (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Seq<Object> stubZK$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public ReassignPartitionsCommandTest() {
        Logging.class.$init$((Logging)this);
        this.calls = 0;
    }
}

