/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.api.BaseProducerSendTest$callback$4$;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005uh!B\u0001\u0003\u0003\u00039!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005]!\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0003y\u0012aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0015\u0003\u0001\u00022!I\u0016/\u001d\t\u0011\u0003F\u0004\u0002$M5\tAE\u0003\u0002&\r\u00051AH]8pizJ\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S)\nq\u0001]1dW\u0006<WMC\u0001(\u0013\taSFA\u0002TKFT!!\u000b\u0016\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0011AB:feZ,'/\u0003\u00024a\tY1*\u00194lC\u000e{gNZ5h\u0011%)\u0004\u00011AA\u0002\u0013%a'\u0001\u0005d_:\u001cX/\\3s+\u00059\u0004\u0003\u0002\u001d@\u0003\u0006k\u0011!\u000f\u0006\u0003kiR!a\u000f\u001f\u0002\u000f\rd\u0017.\u001a8ug*\u0011Q!\u0010\u0006\u0003}9\ta!\u00199bG\",\u0017B\u0001!:\u00055Y\u0015MZ6b\u0007>t7/^7feB\u0019!iQ#\u000e\u0003)J!\u0001\u0012\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\t3\u0015BA$+\u0005\u0011\u0011\u0015\u0010^3\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0013Q\u0015\u0001D2p]N,X.\u001a:`I\u0015\fHCA&O!\t\u0011E*\u0003\u0002NU\t!QK\\5u\u0011\u001dy\u0005*!AA\u0002]\n1\u0001\u001f\u00132\u0011\u0019\t\u0006\u0001)Q\u0005o\u0005I1m\u001c8tk6,'\u000f\t\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0003%\u0001(o\u001c3vG\u0016\u00148/F\u0001V!\r16,X\u0007\u0002/*\u0011\u0001,W\u0001\b[V$\u0018M\u00197f\u0015\tQ&&\u0001\u0006d_2dWm\u0019;j_:L!\u0001X,\u0003\r\t+hMZ3s!\u0011q\u0016-Q!\u000e\u0003}S!\u0001\u0019\u001e\u0002\u0011A\u0014x\u000eZ;dKJL!AY0\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u0019!\u0007\u0001)A\u0005+\u0006Q\u0001O]8ek\u000e,'o\u001d\u0011\t\u000f\u0019\u0004!\u0019!C\tO\u0006)Ao\u001c9jGV\t\u0001\u000e\u0005\u0002j]6\t!N\u0003\u0002lY\u0006!A.\u00198h\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c6\u0003\rM#(/\u001b8h\u0011\u0019\t\b\u0001)A\u0005Q\u00061Ao\u001c9jG\u0002Bqa\u001d\u0001C\u0002\u0013%A/\u0001\u0006ok6\u0014VmY8sIN,\u0012!\u001e\t\u0003\u0005ZL!a\u001e\u0016\u0003\u0007%sG\u000f\u0003\u0004z\u0001\u0001\u0006I!^\u0001\f]Vl'+Z2pe\u0012\u001c\b\u0005C\u0003|\u0001\u0011\u0005C0A\u0003tKR,\u0006\u000fF\u0001LQ\tQh\u0010E\u0002\u0000\u0003\u0007i!!!\u0001\u000b\u0005-q\u0011\u0002BA\u0003\u0003\u0003\u0011aAQ3g_J,\u0007BBA\u0005\u0001\u0011\u0005C0\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t9!!\u0004\u0011\u0007}\fy!\u0003\u0003\u0002\u0012\u0005\u0005!!B!gi\u0016\u0014\bbBA\u000b\u0001\u0011E\u0011qC\u0001\u000fGJ,\u0017\r^3Qe>$WoY3s)%i\u0016\u0011DA\u0015\u0003[\t9\u0004\u0003\u0005\u0002\u001c\u0005M\u0001\u0019AA\u000f\u0003)\u0011'o\\6fe2K7\u000f\u001e\t\u0005\u0003?\t)CD\u0002C\u0003CI1!a\t+\u0003\u0019\u0001&/\u001a3fM&\u0019q.a\n\u000b\u0007\u0005\r\"\u0006C\u0005\u0002,\u0005M\u0001\u0013!a\u0001k\u00069!/\u001a;sS\u0016\u001c\bBCA\u0018\u0003'\u0001\n\u00111\u0001\u00022\u0005AA.\u001b8hKJl5\u000fE\u0002C\u0003gI1!!\u000e+\u0005\u0011auN\\4\t\u0015\u0005e\u00121\u0003I\u0001\u0002\u0004\tY$A\u0003qe>\u00048\u000fE\u0003C\u0003{\t\t%C\u0002\u0002@)\u0012aa\u00149uS>t\u0007\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dC.\u0001\u0003vi&d\u0017\u0002BA&\u0003\u000b\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\ty\u0005\u0001C\t\u0003#\n\u0001C]3hSN$XM\u001d)s_\u0012,8-\u001a:\u0015\u0007u\u000b\u0019\u0006\u0003\u0004a\u0003\u001b\u0002\r!\u0018\u0005\b\u0003/\u0002A\u0011BA-\u0003M\u0001x\u000e\u001c7V]RLGNT;n%\u0016\u001cwN\u001d3t)\u0011\tY&a\u0019\u0011\t\u0005Z\u0013Q\f\t\u0006q\u0005}\u0013)Q\u0005\u0004\u0003CJ$AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\u0005\u0007g\u0006U\u0003\u0019A;\t\r\u0005\u001d\u0004\u0001\"\u0001}\u00039!Xm\u001d;TK:$wJ\u001a4tKRDC!!\u001a\u0002lA\u0019q0!\u001c\n\t\u0005=\u0014\u0011\u0001\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002t\u0001!\t\u0001`\u0001(i\u0016\u001cHoU3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\r\u000b\u0003\u0002r\u0005-\u0004BBA=\u0001\u0011\u0005A0\u0001\u0016uKN$8+\u001a8e\u001d>t7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3XSRD7I]3bi\u0016$\u0016.\\3)\t\u0005]\u00141\u000e\u0005\b\u0003\u007f\u0002A\u0011CAA\u00035\u0019XM\u001c3B]\u00124VM]5gsR91*a!\u0002\u0006\u0006\u001d\u0005B\u00021\u0002~\u0001\u0007Q\f\u0003\u0005t\u0003{\u0002\n\u00111\u0001v\u0011)\tI)! \u0011\u0002\u0003\u0007\u0011\u0011G\u0001\ni&lWm\\;u\u001bNDq!!$\u0001\t#\ty)\u0001\ftK:$\u0017I\u001c3WKJLg-\u001f+j[\u0016\u001cH/Y7q)\u0015Y\u0015\u0011SAJ\u0011\u0019\u0001\u00171\u0012a\u0001;\"A\u0011QSAF\u0001\u0004\t9*A\u0007uS6,7\u000f^1naRK\b/\u001a\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003\u0019\u0011XmY8sI*\u0019\u0011\u0011\u0015\u001f\u0002\r\r|W.\\8o\u0013\u0011\t)+a'\u0003\u001bQKW.Z:uC6\u0004H+\u001f9f\u0011\u0019\tI\u000b\u0001C\u0001y\u0006IA/Z:u\u00072|7/\u001a\u0015\u0005\u0003O\u000bY\u0007\u0003\u0004\u00020\u0002!\t\u0001`\u0001\u0014i\u0016\u001cHoU3oIR{\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003[\u000bY\u0007\u0003\u0004\u00026\u0002!\t\u0001`\u0001)i\u0016\u001cHoU3oI\n+gm\u001c:f\u0003:$\u0017I\u001a;feB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\u001c\u0015\u0005\u0003g\u000bY\u0007\u0003\u0004\u0002<\u0002!\t\u0001`\u0001\ni\u0016\u001cHO\u00127vg\"DC!!/\u0002l!1\u0011\u0011\u0019\u0001\u0005\u0002q\f\u0001\u0006^3ti\u000ecwn]3XSRD',\u001a:p)&lWm\\;u\rJ|WnQ1mY\u0016\u0014H\u000b\u001b:fC\u0012DC!a0\u0002l!1\u0011q\u0019\u0001\u0005\u0002q\f\u0001\u0006^3ti\u000ecwn]3XSRD',\u001a:p)&lWm\\;u\rJ|WnU3oI\u0016\u0014H\u000b\u001b:fC\u0012DC!!2\u0002l!I\u0011Q\u001a\u0001\u0012\u0002\u0013E\u0011qZ\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u0012\u0012TCAAiU\r)\u00181[\u0016\u0003\u0003+\u0004B!a6\u0002b6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u001c\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002d\u0006e'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u001d\u0001\u0012\u0002\u0013E\u0011\u0011^\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u0012\u001aTCAAvU\u0011\t\t$a5\t\u0013\u0005=\b!%A\u0005\u0012\u0005E\u0018\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u001f\u0016\u0005\u0003w\t\u0019\u000eC\u0005\u0002x\u0002\t\n\u0011\"\u0005\u0002P\u000692/\u001a8e\u0003:$g+\u001a:jMf$C-\u001a4bk2$HE\r\u0005\n\u0003w\u0004\u0011\u0013!C\t\u0003S\fqc]3oI\u0006sGMV3sS\u001aLH\u0005Z3gCVdG\u000fJ\u001a")
public abstract class BaseProducerSendTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> kafka$api$BaseProducerSendTest$$consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1$lzycompute(int x$1, VolatileObjectRef x$2) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$2.elem != null) return (BaseProducerSendTest$callback$3$)x$2.elem;
            x$2.elem = new BaseProducerSendTest$callback$3$(this, x$1);
            return (BaseProducerSendTest$callback$3$)x$2.elem;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2$lzycompute(TimestampType x$1, int x$2, long x$3, long x$4, VolatileObjectRef x$5) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$5.elem != null) return (BaseProducerSendTest$callback$4$)x$5.elem;
            x$5.elem = new BaseProducerSendTest$callback$4$(this, x$1, x$2, x$3, x$4);
            return (BaseProducerSendTest$callback$4$)x$5.elem;
        }
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        KafkaServerTestHarness$class.configureSecurityBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public int boundPort(KafkaServer server) {
        return KafkaServerTestHarness$class.boundPort(this, server);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public ListenerName listenerName() {
        return KafkaServerTestHarness$class.listenerName(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> serverSaslProperties() {
        return KafkaServerTestHarness$class.serverSaslProperties(this);
    }

    @Override
    public Option<Properties> clientSaslProperties() {
        return KafkaServerTestHarness$class.clientSaslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void killBroker(int index) {
        KafkaServerTestHarness$class.killBroker(this, index);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)4)).toString());
        int x$19 = numServers;
        String x$20 = this.zkConnect();
        boolean x$21 = false;
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$23 = this.trustStoreFile();
        Option<Properties> x$24 = this.serverSaslProperties();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$19, x$20, x$21, x$25, (Option<SecurityProtocol>)x$22, x$23, x$24, x$26, x$27, x$28, x$29, x$30).map((Function1)new Serializable(this, overridingProps){
            public static final long serialVersionUID = 0L;
            private final Properties overridingProps$1;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps$1);
            }
            {
                this.overridingProps$1 = overridingProps$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public KafkaConsumer<byte[], byte[]> kafka$api$BaseProducerSendTest$$consumer() {
        return this.kafka$api$BaseProducerSendTest$$consumer;
    }

    private void kafka$api$BaseProducerSendTest$$consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.kafka$api$BaseProducerSendTest$$consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        String x$31 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$32 = SecurityProtocol.PLAINTEXT;
        String x$33 = TestUtils$.MODULE$.createNewConsumer$default$2();
        String x$34 = TestUtils$.MODULE$.createNewConsumer$default$3();
        long x$35 = TestUtils$.MODULE$.createNewConsumer$default$4();
        String x$36 = TestUtils$.MODULE$.createNewConsumer$default$5();
        int x$37 = TestUtils$.MODULE$.createNewConsumer$default$6();
        Option<File> x$38 = TestUtils$.MODULE$.createNewConsumer$default$8();
        Option<Properties> x$39 = TestUtils$.MODULE$.createNewConsumer$default$9();
        Option<Properties> x$40 = TestUtils$.MODULE$.createNewConsumer$default$10();
        this.kafka$api$BaseProducerSendTest$$consumer_$eq(TestUtils$.MODULE$.createNewConsumer(x$31, x$33, x$34, x$35, x$36, x$37, x$32, x$38, x$39, x$40));
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$api$BaseProducerSendTest$$consumer().close();
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        KafkaServerTestHarness$class.tearDown(this);
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int retries, long lingerMs, Option<Properties> props) {
        String x$41 = brokerList;
        SecurityProtocol x$42 = this.securityProtocol();
        Option<File> x$43 = this.trustStoreFile();
        Option<Properties> x$44 = this.clientSaslProperties();
        int x$45 = retries;
        long x$46 = lingerMs;
        Option<Properties> x$47 = props;
        int x$48 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$49 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$50 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$51 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$52 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$53 = TestUtils$.MODULE$.createNewProducer$default$12();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$41, x$48, x$49, x$50, x$45, x$46, x$51, x$42, x$43, x$44, x$52, x$53, x$47);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public long createProducer$default$3() {
        return 0L;
    }

    public Option<Properties> createProducer$default$4() {
        return None$.MODULE$;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<ConsumerRecord<byte[], byte[]>> kafka$api$BaseProducerSendTest$$pollUntilNumRecords(int numRecords) {
        void var2_2;
        ArrayBuffer records2 = new ArrayBuffer();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numRecords, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final int numRecords$1;
            private final ArrayBuffer records$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$1.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)this.$outer.kafka$api$BaseProducerSendTest$$consumer().poll(50L)).asScala());
                return this.records$1.size() == this.numRecords$1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
                this.records$1 = records$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " records until timeout, but expected ", " records."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records2.size()), BoxesRunTime.boxToInteger((int)numRecords)})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return var2_2;
    }

    @Test
    public void testSendOffset() {
        VolatileObjectRef callback$module = new VolatileObjectRef(null);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());
        int partition = 0;
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(), (Object)"value".getBytes());
                producer.send(record4, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module));
                throw this.fail("Should not allow sending a record without topic", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, partition, record0, callback$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$1;
                    private final int partition$1;
                    private final ProducerRecord record0$1;
                    private final VolatileObjectRef callback$module$1;

                    public final Future<RecordMetadata> apply(int _) {
                        return this.producer$1.send(this.record0$1, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$1(this.partition$1, this.callback$module$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.partition$1 = partition$1;
                        this.record0$1 = record0$1;
                        this.callback$module$1 = callback$module$1;
                    }
                });
                Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)(this.kafka$api$BaseProducerSendTest$$numRecords() + 4))).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            }
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", "gzip");
        String x$54 = this.brokerList();
        long x$55 = Long.MAX_VALUE;
        Some x$56 = new Some((Object)producerProps);
        int x$57 = this.createProducer$default$2();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$54, x$57, x$55, (Option<Properties>)x$56);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        String x$58 = this.brokerList();
        long x$59 = Long.MAX_VALUE;
        int x$60 = this.createProducer$default$2();
        Option<Properties> x$61 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$58, x$60, x$59, x$61);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1)new Serializable(this, producer, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$3;
                private final int partition$2;

                public final Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> apply(int i) {
                    ProducerRecord record = new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$2), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                    return new Tuple2((Object)record, (Object)this.producer$3.send(record));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$3 = producer$3;
                    this.partition$2 = partition$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(timeoutMs, TimeUnit.MILLISECONDS);
            int lastOffset = BoxesRunTime.unboxToInt((Object)recordAndFutures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$2;

                public final int apply(int x0$1, Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> x1$1) {
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), x1$1);
                    if (tuple2 != null) {
                        int offset = tuple2._1$mcI$sp();
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            Future future = (Future)tuple22._2();
                            RecordMetadata recordMetadata = (RecordMetadata)future.get();
                            Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                            Assert.assertEquals((long)this.partition$2, (long)recordMetadata.partition());
                            Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                            int n = offset + 1;
                            return n;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.partition$2 = partition$2;
                }
            }));
            Assert.assertEquals((long)numRecords, (long)lastOffset);
            return;
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        VolatileObjectRef callback$module = new VolatileObjectRef(null);
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            Object object = !(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) ? topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime") : topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), topicProps);
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, timestampType, partition, baseTimestamp, startTime, callback$module){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$2;
                private final TimestampType timestampType$1;
                private final int partition$3;
                private final long baseTimestamp$1;
                private final long startTime$1;
                private final VolatileObjectRef callback$module$2;

                public final Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> apply(int i) {
                    ProducerRecord record = new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$3), Predef$.MODULE$.long2Long(this.baseTimestamp$1 + (long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                    return new Tuple2((Object)record, (Object)this.producer$2.send(record, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$2(this.timestampType$1, this.partition$3, this.baseTimestamp$1, this.startTime$1, this.callback$module$2)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$2 = producer$2;
                    this.timestampType$1 = timestampType$1;
                    this.partition$3 = partition$3;
                    this.baseTimestamp$1 = baseTimestamp$1;
                    this.startTime$1 = startTime$1;
                    this.callback$module$2 = callback$module$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(20000L, TimeUnit.MILLISECONDS);
            recordAndFutures.foreach((Function1)new Serializable(this, timestampType, startTime){
                public static final long serialVersionUID = 0L;
                private final TimestampType timestampType$1;
                private final long startTime$1;

                public final void apply(Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> x0$2) {
                    Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        ProducerRecord record = (ProducerRecord)tuple2._1();
                        Future future = (Future)tuple2._2();
                        RecordMetadata recordMetadata = (RecordMetadata)future.get();
                        TimestampType timestampType = this.timestampType$1;
                        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
                        if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                            Assert.assertTrue((recordMetadata.timestamp() >= this.startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Assert.assertEquals((Object)record.timestamp(), (Object)BoxesRunTime.boxToLong((long)recordMetadata.timestamp()));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.timestampType$1 = timestampType$1;
                    this.startTime$1 = startTime$1;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have offset ", " but only successfully sent ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords()), BoxesRunTime.boxToLong((long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset())})), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset());
            return;
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testClose() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, record0){
                public static final long serialVersionUID = 0L;
                private final KafkaProducer producer$4;
                private final ProducerRecord record0$2;

                public final Future<RecordMetadata> apply(int _) {
                    return this.producer$4.send(this.record0$2);
                }
                {
                    this.producer$4 = producer$4;
                    this.record0$2 = record0$2;
                }
            });
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords())).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
            return;
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testSendToPartition() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 1;
            long now = System.currentTimeMillis();
            IndexedSeq futures = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$5;
                private final int partition$4;
                private final long now$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$5.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$4), Predef$.MODULE$.long2Long(this.now$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$5 = producer$5;
                    this.partition$4 = partition$4;
                    this.now$1 = now$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$3) {
                    return x$3.get(30L, TimeUnit.SECONDS);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$1) {
                    Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$4;

                public final void apply(Tuple2<RecordMetadata, Object> x$4) {
                    Tuple2<RecordMetadata, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                        Assert.assertEquals((long)this.partition$4, (long)recordMetadata.partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.partition$4 = partition$4;
                }
            });
            this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
            Seq<ConsumerRecord<byte[], byte[]>> records2 = this.kafka$api$BaseProducerSendTest$$pollUntilNumRecords(this.kafka$api$BaseProducerSendTest$$numRecords());
            ((IterableLike)records2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, partition, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$4;
                private final long now$1;

                public final void apply(Tuple2<ConsumerRecord<byte[], byte[]>, Object> x0$3) {
                    Tuple2<ConsumerRecord<byte[], byte[]>, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        ConsumerRecord record = (ConsumerRecord)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)record.topic());
                        Assert.assertEquals((long)this.partition$4, (long)record.partition());
                        Assert.assertEquals((long)i, (long)record.offset());
                        Assert.assertNull((Object)record.key());
                        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1))})), (Object)new String((byte[])record.value()));
                        Assert.assertEquals((long)this.now$1, (long)record.timestamp());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.partition$4 = partition$4;
                    this.now$1 = now$1;
                }
            });
            return;
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition0 = 0;
        IndexedSeq futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final KafkaProducer producer$6;
            private final int partition0$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition0$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producer$6 = producer$6;
                this.partition0$1 = partition0$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$5) {
                return x$5.get(30L, TimeUnit.SECONDS);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$2) {
                Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final int partition0$1;

            public final void apply(Tuple2<RecordMetadata, Object> x$6) {
                Tuple2<RecordMetadata, Object> tuple2 = x$6;
                if (tuple2 != null) {
                    RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                    int offset = tuple2._2$mcI$sp();
                    Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                    Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                    Assert.assertEquals((long)this.partition0$1, (long)recordMetadata.partition());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partition0$1 = partition0$1;
            }
        });
        int partition1 = 1;
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes()));
            throw this.fail("Should not allow sending a record to a partition not present in the metadata", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        }
        catch (KafkaException kafkaException) {
            AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic(), 2, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            IndexedSeq futures1 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$6;
                private final int partition1$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition1$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$6 = producer$6;
                    this.partition1$1 = partition1$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                    return x$7.get(30L, TimeUnit.SECONDS);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures1.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$3) {
                    Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$3;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition1$1;

                public final void apply(Tuple2<RecordMetadata, Object> x$8) {
                    Tuple2<RecordMetadata, Object> tuple2 = x$8;
                    if (tuple2 != null) {
                        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                        Assert.assertEquals((long)this.partition1$1, (long)recordMetadata.partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.partition1$1 = partition1$1;
                }
            });
            futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$6;
                private final int partition0$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition0$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$6 = producer$6;
                    this.partition0$1 = partition0$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$9) {
                    return x$9.get(30L, TimeUnit.SECONDS);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$4) {
                    Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$4;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition0$1;

                public final void apply(Tuple2<RecordMetadata, Object> x$10) {
                    Tuple2<RecordMetadata, Object> tuple2 = x$10;
                    if (tuple2 != null) {
                        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                        Assert.assertEquals((long)this.partition0$1, (long)recordMetadata.partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.partition0$1 = partition0$1;
                }
            });
            return;
        }
    }

    @Test
    public void testFlush() {
        String x$62 = this.brokerList();
        long x$63 = Long.MAX_VALUE;
        int x$64 = this.createProducer$default$2();
        Option<Properties> x$65 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$62, x$64, x$63, x$65);
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, producer, record){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                public final KafkaProducer producer$7;
                public final ProducerRecord record$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testFlush$1 $outer;

                        public final Future<RecordMetadata> apply(int x$11) {
                            return this.$outer.producer$7.send(this.$outer.record$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$12) {
                            return !x$12.isDone();
                        }
                    }));
                    this.producer$7.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$13) {
                            return x$13.isDone();
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$7 = producer$7;
                    this.record$1 = record$1;
                }
            });
            return;
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition = 0;
        this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, record0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            public final ProducerRecord record0$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                String x$66 = this.$outer.brokerList();
                long x$67 = Long.MAX_VALUE;
                int x$68 = this.$outer.createProducer$default$2();
                Option<Properties> x$69 = this.$outer.createProducer$default$4();
                KafkaProducer<byte[], byte[]> producer = this.$outer.createProducer(x$66, x$68, x$67, x$69);
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;
                    private final KafkaProducer producer$8;

                    public final Future<RecordMetadata> apply(int x$14) {
                        return this.producer$8.send(this.$outer.record0$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.producer$8 = producer$8;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Future<RecordMetadata> x$15) {
                        return !x$15.isDone();
                    }
                }));
                producer.close(0L, TimeUnit.MILLISECONDS);
                responses.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;

                    public final void apply(Future<RecordMetadata> future) {
                        try {
                            future.get();
                            throw this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer().fail("No message should be sent successfully.", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
                        }
                        catch (Exception exception) {
                            Assert.assertEquals((Object)"java.lang.IllegalStateException: Producer is closed forcefully.", (Object)exception.getMessage());
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)this.$outer.kafka$api$BaseProducerSendTest$$consumer().poll(50L).count());
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record0$3 = record0$3;
            }
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition = 0;
        this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            public final ProducerRecord record$2;

            public final Seq<ConsumerRecord<byte[], byte[]>> apply(int i) {
                String x$70 = this.$outer.brokerList();
                long x$71 = Long.MAX_VALUE;
                int x$72 = this.$outer.createProducer$default$2();
                Option<Properties> x$73 = this.$outer.createProducer$default$4();
                KafkaProducer<byte[], byte[]> producer = this.$outer.createProducer(x$70, x$72, x$71, x$73);
                try {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromSenderThread$1 $outer;
                        private final KafkaProducer producer$9;

                        public final Future<RecordMetadata> apply(int i) {
                            public class Kafka_api_BaseProducerSendTest$CloseCallback$1
                            implements Callback {
                                public final KafkaProducer<byte[], byte[]> kafka$api$BaseProducerSendTest$CloseCallback$$producer;
                                private final boolean sendRecords;
                                public final /* synthetic */ BaseProducerSendTest $outer;
                                public final ProducerRecord record$2;

                                public void onCompletion(RecordMetadata metadata, Exception exception) {
                                    if (this.sendRecords) {
                                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$CloseCallback$$$outer().kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ Kafka_api_BaseProducerSendTest$CloseCallback$1 $outer;

                                            public final Future<RecordMetadata> apply(int x$16) {
                                                return this.$outer.kafka$api$BaseProducerSendTest$CloseCallback$$producer.send(this.$outer.record$2);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(0L, TimeUnit.MILLISECONDS);
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(Long.MAX_VALUE, TimeUnit.MICROSECONDS);
                                }

                                public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$CloseCallback$$$outer() {
                                    return this.$outer;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public Kafka_api_BaseProducerSendTest$CloseCallback$1(BaseProducerSendTest $outer, KafkaProducer<byte[], byte[]> producer, boolean sendRecords2) {
                                    void var4_4;
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer = producer;
                                    this.sendRecords = sendRecords2;
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.record$2 = var4_4;
                                }
                            }
                            return this.producer$9.send(this.$outer.record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1(this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer(), this.producer$9, i == 0, this.$outer.record$2));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.producer$9 = producer$9;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$17) {
                            return !x$17.isDone();
                        }
                    }));
                    producer.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$18) {
                            return x$18.isDone();
                        }
                    }));
                    return this.$outer.kafka$api$BaseProducerSendTest$$pollUntilNumRecords(this.$outer.kafka$api$BaseProducerSendTest$$numRecords());
                }
                finally {
                    producer.close();
                }
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$2 = record$2;
            }
        });
    }

    public final BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1(int partition$1, VolatileObjectRef callback$module$1) {
        return callback$module$1.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$1$lzycompute(partition$1, callback$module$1) : (BaseProducerSendTest$callback$3$)callback$module$1.elem;
    }

    public final BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2(TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, VolatileObjectRef callback$module$2) {
        return callback$module$2.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$2$lzycompute(timestampType$1, partition$3, baseTimestamp$1, startTime$1, callback$module$2) : (BaseProducerSendTest$callback$4$)callback$module$2.elem;
    }

    public BaseProducerSendTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

