/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.util.Arrays;
import kafka.common.KafkaException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.junit.After;
import org.junit.Before;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;

public abstract class KafkaServerTestHarness$class {
    public static void configureSecurityBeforeServersStart(KafkaServerTestHarness $this) {
    }

    public static Seq configs(KafkaServerTestHarness $this) {
        if ($this.instanceConfigs() == null) {
            $this.instanceConfigs_$eq($this.generateConfigs());
        }
        return $this.instanceConfigs();
    }

    public static Option serverForId(KafkaServerTestHarness $this, int id) {
        return $this.servers().find((Function1)new Serializable($this, id){
            public static final long serialVersionUID = 0L;
            private final int id$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.id$1;
            }
            {
                this.id$1 = id$1;
            }
        });
    }

    public static int boundPort(KafkaServerTestHarness $this, KafkaServer server) {
        return server.boundPort($this.listenerName());
    }

    public static SecurityProtocol securityProtocol(KafkaServerTestHarness $this) {
        return SecurityProtocol.PLAINTEXT;
    }

    public static ListenerName listenerName(KafkaServerTestHarness $this) {
        return ListenerName.forSecurityProtocol((SecurityProtocol)$this.securityProtocol());
    }

    public static Option trustStoreFile(KafkaServerTestHarness $this) {
        return None$.MODULE$;
    }

    public static Option serverSaslProperties(KafkaServerTestHarness $this) {
        return None$.MODULE$;
    }

    public static Option clientSaslProperties(KafkaServerTestHarness $this) {
        return None$.MODULE$;
    }

    @Before
    public static void setUp(KafkaServerTestHarness $this) {
        $this.kafka$integration$KafkaServerTestHarness$$super$setUp();
        if ($this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        $this.configureSecurityBeforeServersStart();
        $this.servers_$eq((Buffer<KafkaServer>)((TraversableOnce)$this.configs().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig x$1) {
                return TestUtils$.MODULE$.createServer(x$1, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())).toBuffer());
        $this.brokerList_$eq(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)$this.servers(), $this.securityProtocol()));
        $this.alive_$eq(new boolean[$this.servers().length()]);
        Arrays.fill($this.alive(), true);
    }

    @After
    public static void tearDown(KafkaServerTestHarness $this) {
        if ($this.servers() != null) {
            $this.servers().foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$2) {
                    x$2.shutdown();
                }
            });
            $this.servers().foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer server) {
                    CoreUtils$.MODULE$.delete(server.config().logDirs());
                }
            });
        }
        $this.kafka$integration$KafkaServerTestHarness$$super$tearDown();
    }

    /*
     * WARNING - void declaration
     */
    public static int killRandomBroker(KafkaServerTestHarness $this) {
        void var1_1;
        int index = TestUtils$.MODULE$.random().nextInt($this.servers().length());
        $this.killBroker(index);
        return (int)var1_1;
    }

    public static void killBroker(KafkaServerTestHarness $this, int index) {
        if ($this.alive()[index]) {
            ((KafkaServer)$this.servers().apply(index)).shutdown();
            ((KafkaServer)$this.servers().apply(index)).awaitShutdown();
            $this.alive()[index] = false;
        }
    }

    public static void restartDeadBrokers(KafkaServerTestHarness $this) {
        $this.servers().indices().withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServerTestHarness $outer;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return !this.$outer.alive()[i];
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServerTestHarness $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ((KafkaServer)this.$outer.servers().apply(i)).startup();
                this.$outer.alive()[i] = true;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static void $init$(KafkaServerTestHarness $this) {
        $this.instanceConfigs_$eq(null);
        $this.servers_$eq(null);
        $this.brokerList_$eq(null);
        $this.alive_$eq(null);
        $this.kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq("User");
    }
}

